/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.datasetenhancer;

import junit.framework.TestCase;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.cataloggen.datasetenhancer.RegExpAndDurationTimeCoverageEnhancer;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.mock.MockCrawlableDataset;

public class TestRegExpAndDurationTimeCoverageEnhancer
extends TestCase {
    public TestRegExpAndDurationTimeCoverageEnhancer(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testDatasetNameMatchSuccess() {
        String matchPattern = "NDFD_CONUS_5km_([0-9]{4})([0-9]{2})([0-9]{2})_([0-9]{2})([0-9]{2}).grib2";
        String substitutionPattern = "$1-$2-$3T$4:$5:00";
        String duration = "96 hours";
        String dsName = "NDFD_CONUS_5km_20060325_1200.grib2";
        RegExpAndDurationTimeCoverageEnhancer timeCoverageEnhancer = RegExpAndDurationTimeCoverageEnhancer.getInstanceToMatchOnDatasetName((String)matchPattern, (String)substitutionPattern, (String)duration);
        TestRegExpAndDurationTimeCoverageEnhancer.assertTrue((timeCoverageEnhancer != null ? 1 : 0) != 0);
        InvDatasetImpl ds = new InvDatasetImpl(null, dsName);
        MockCrawlableDataset crDs = new MockCrawlableDataset(dsName, false);
        TestRegExpAndDurationTimeCoverageEnhancer.assertTrue((String)"Failed to add metadata.", (boolean)timeCoverageEnhancer.addMetadata((InvDataset)ds, (CrawlableDataset)crDs));
    }

    public void testDatasetNameMatchFail() {
        String matchPattern = "NDFD_CONUS_5km_([0-9]{4})([0-9]{2})([0-9]{2})_([0-9]{2})([0-9]{2}).grib2";
        String substitutionPattern = "$1-$2-$3T$4:$5:00";
        String duration = "96 hours";
        String dsName = "NDFD_CONUS_5km_200600325_1200.grib2";
        RegExpAndDurationTimeCoverageEnhancer timeCoverageEnhancer = RegExpAndDurationTimeCoverageEnhancer.getInstanceToMatchOnDatasetName((String)matchPattern, (String)substitutionPattern, (String)duration);
        TestRegExpAndDurationTimeCoverageEnhancer.assertTrue((timeCoverageEnhancer != null ? 1 : 0) != 0);
        InvDatasetImpl ds = new InvDatasetImpl(null, dsName);
        MockCrawlableDataset crDs = new MockCrawlableDataset(dsName, false);
        TestRegExpAndDurationTimeCoverageEnhancer.assertTrue((String)"Unexpected success adding metadata.", (!timeCoverageEnhancer.addMetadata((InvDataset)ds, (CrawlableDataset)crDs) ? 1 : 0) != 0);
    }

    public void testDatasetPathMatchSuccess() {
        String matchPattern = "prod/sref.([0-9]{4})([0-9]{2})([0-9]{2})/([0-9]{2})/pgrb_biasc/sref_([^.]*)\\.t\\4z\\.pgrb([0-9]{3})\\.(.*)\\.grib2$";
        String substitutionPattern = "$1-$2-$3T$4";
        String duration = "96 hours";
        String dsName = "/data/nccf/com/sref/prod/sref.20090603/03/pgrb_biasc/sref_eta.t03z.pgrb212.n2.grib2";
        RegExpAndDurationTimeCoverageEnhancer timeCoverageEnhancer = RegExpAndDurationTimeCoverageEnhancer.getInstanceToMatchOnDatasetPath((String)matchPattern, (String)substitutionPattern, (String)duration);
        TestRegExpAndDurationTimeCoverageEnhancer.assertTrue((timeCoverageEnhancer != null ? 1 : 0) != 0);
        InvDatasetImpl ds = new InvDatasetImpl(null, dsName);
        MockCrawlableDataset crDs = new MockCrawlableDataset(dsName, false);
        TestRegExpAndDurationTimeCoverageEnhancer.assertTrue((String)"Failed to add metadata.", (boolean)timeCoverageEnhancer.addMetadata((InvDataset)ds, (CrawlableDataset)crDs));
        String startDateString = ds.getLocalMetadata().getTimeCoverage().getStart().getText();
        String expectedStartDateString = "2009-06-03T03";
        TestRegExpAndDurationTimeCoverageEnhancer.assertTrue((String)("TimeCoverage start date [" + startDateString + "] not as expected [" + expectedStartDateString + "]."), (boolean)startDateString.equals(expectedStartDateString));
    }
}

