/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.cataloggen.config.DatasetNamer;
import thredds.cataloggen.config.DatasetNamerType;
import thredds.cataloggen.config.DatasetSource;
import thredds.cataloggen.config.DatasetSourceStructure;
import thredds.cataloggen.config.DatasetSourceType;
import thredds.cataloggen.config.ResultService;

public class TestDatasetNamer
extends TestCase {
    private static Logger log = LoggerFactory.getLogger(TestDatasetNamer.class);
    private String parentDsName1 = null;
    private String parentDsName2 = null;
    private String parentDsName3 = null;
    private String parentDsUrl1 = null;
    private String parentDsUrl2 = null;
    private String parentDsUrl3 = null;
    private InvDatasetImpl parentDs1 = null;
    private InvDatasetImpl parentDs2 = null;
    private InvDatasetImpl parentDs3 = null;
    private String name1 = null;
    private String name2 = null;
    private boolean addLevel1 = false;
    private boolean addLevel2 = false;
    private DatasetNamerType type1 = null;
    private DatasetNamerType type2 = null;
    private String matchPattern1 = null;
    private String matchPattern2 = null;
    private String substitutePattern1 = null;
    private String substitutePattern2 = null;
    private String attribContainer1 = null;
    private String attribContainer2 = null;
    private String attribName1 = null;
    private String attribName2 = null;
    private DatasetSource source1 = null;
    private DatasetSource source2 = null;
    private DatasetSource source3 = null;
    private ResultService resService1 = null;

    public TestDatasetNamer(String name) {
        super(name);
    }

    protected void setUp() {
        this.parentDsName1 = "parent dataset 1";
        this.parentDsName2 = "parent dataset 2";
        this.parentDsName3 = "Parent dataset 3";
        this.parentDsUrl1 = "http://server/parentDatasetUrl1";
        this.parentDsUrl2 = "http://server/parentDatasetUrl2";
        this.parentDsUrl3 = "http://server/ParentDatasetUrl3";
        this.parentDs1 = new InvDatasetImpl(null, this.parentDsName1);
        this.parentDs1.setUrlPath(this.parentDsUrl1);
        this.parentDs2 = new InvDatasetImpl(null, this.parentDsName2);
        this.parentDs2.setUrlPath(this.parentDsUrl2);
        this.parentDs3 = new InvDatasetImpl(null, this.parentDsName3);
        this.parentDs3.setUrlPath(this.parentDsUrl3);
        this.name1 = "name 1";
        this.name2 = "name 2";
        this.addLevel1 = true;
        this.addLevel2 = false;
        this.type1 = DatasetNamerType.REGULAR_EXPRESSION;
        this.type2 = DatasetNamerType.DODS_ATTRIBUTE;
        this.matchPattern1 = "match pattern 1";
        this.matchPattern2 = "match pattern 2";
        this.substitutePattern1 = "sub pattern 1";
        this.substitutePattern2 = "sub pattern 2";
        this.attribContainer1 = "attrib container 1";
        this.attribContainer2 = "attrib container 2";
        this.attribName1 = "attrib name 1";
        this.attribName2 = "attrib name 2";
        this.resService1 = new ResultService("fred", ServiceType.DODS, "http://server/dods", null, "access ");
        this.source1 = DatasetSource.newDatasetSource((String)"ds name 1", (DatasetSourceType)DatasetSourceType.LOCAL, (DatasetSourceStructure)DatasetSourceStructure.FLAT, (String)"access Point 1", (ResultService)this.resService1);
        this.source2 = DatasetSource.newDatasetSource((String)"ds name 2", (DatasetSourceType)DatasetSourceType.DODS_DIR, (DatasetSourceStructure)DatasetSourceStructure.DIRECTORY_TREE, (String)"access Point 1", (ResultService)this.resService1);
        this.source3 = DatasetSource.newDatasetSource(null, (DatasetSourceType)DatasetSourceType.DODS_FILE_SERVER, (DatasetSourceStructure)DatasetSourceStructure.DIRECTORY_TREE, (String)"access Point 1", (ResultService)this.resService1);
    }

    public void testGetters() {
        DatasetNamer dsNamer = new DatasetNamer((InvDataset)this.parentDs1, this.name1, this.addLevel1, this.type1, this.matchPattern1, this.substitutePattern1, null, null);
        TestDatasetNamer.assertEquals((Object)this.parentDs1, (Object)dsNamer.getParentDataset());
        TestDatasetNamer.assertEquals((String)this.name1, (String)dsNamer.getName());
        TestDatasetNamer.assertTrue((dsNamer.getAddLevel() == this.addLevel1 ? 1 : 0) != 0);
        TestDatasetNamer.assertEquals((Object)this.type1, (Object)dsNamer.getType());
        TestDatasetNamer.assertEquals((String)this.matchPattern1, (String)dsNamer.getMatchPattern());
        TestDatasetNamer.assertEquals((String)this.substitutePattern1, (String)dsNamer.getSubstitutePattern());
        TestDatasetNamer.assertNull((Object)dsNamer.getAttribContainer());
        TestDatasetNamer.assertNull((Object)dsNamer.getAttribName());
        dsNamer = new DatasetNamer((InvDataset)this.parentDs2, this.name2, this.addLevel2, this.type2, null, null, this.attribContainer2, this.attribName2);
        TestDatasetNamer.assertEquals((Object)this.type2, (Object)dsNamer.getType());
        TestDatasetNamer.assertEquals((String)this.attribContainer2, (String)dsNamer.getAttribContainer());
        TestDatasetNamer.assertEquals((String)this.attribName2, (String)dsNamer.getAttribName());
    }

    public void testVariousValidityConstraints() {
        StringBuilder stringBuilder = new StringBuilder();
        DatasetNamer dsNamer = new DatasetNamer((InvDataset)this.parentDs1, this.name1, this.addLevel1, null, this.matchPattern1, this.substitutePattern1, null, null);
        boolean isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertFalse((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs1, this.name1, this.addLevel1, this.type1, this.matchPattern1, this.substitutePattern1, null, null);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertTrue((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs1, this.name1, this.addLevel1, this.type1, this.matchPattern1, null, null, null);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertFalse((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs1, this.name1, this.addLevel1, this.type1, null, this.substitutePattern1, null, null);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertFalse((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs1, this.name1, this.addLevel1, this.type1, this.matchPattern1, this.substitutePattern1, this.attribContainer1, null);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertTrue((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs1, this.name1, this.addLevel1, this.type1, this.matchPattern1, this.substitutePattern1, null, this.attribName1);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertTrue((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs1, this.name1, this.addLevel1, this.type1, this.matchPattern1, this.substitutePattern1, this.attribContainer1, this.attribName1);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertTrue((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs2, this.name2, this.addLevel2, this.type2, null, null, this.attribContainer2, this.attribName2);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertTrue((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs2, this.name2, this.addLevel2, this.type2, null, null, null, this.attribName2);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertFalse((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs2, this.name2, this.addLevel2, this.type2, null, null, this.attribContainer2, null);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertFalse((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs2, this.name2, this.addLevel2, this.type2, this.matchPattern2, null, this.attribContainer2, this.attribName2);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertTrue((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs2, this.name2, this.addLevel2, this.type2, this.matchPattern2, this.substitutePattern2, this.attribContainer2, this.attribName2);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertTrue((String)stringBuilder.toString(), (boolean)isValid);
        dsNamer = new DatasetNamer((InvDataset)this.parentDs2, this.name2, this.addLevel2, this.type2, null, this.substitutePattern2, this.attribContainer2, this.attribName2);
        stringBuilder = new StringBuilder();
        isValid = dsNamer.validate(stringBuilder);
        TestDatasetNamer.assertTrue((String)stringBuilder.toString(), (boolean)isValid);
    }

    public void testNameDataset() {
        log.debug("testNameDataset(): start");
        String parentDsName = "Eta";
        String dsUrlPath = "dods/model/2004050812_eta_211.nc";
        String namerName = "Eta Namer";
        String namerMatchPattern = "([0-9][0-9][0-9][0-9])([0-9][0-9])([0-9][0-9])([0-9][0-9])_eta_211.nc$";
        String namerSubstitutionPattern = "NCEP Eta $1-$2-$3 $4:00:00 GMT";
        String dsName = "NCEP Eta 2004-05-08 12:00:00 GMT";
        InvDatasetImpl dsParent = new InvDatasetImpl(null, parentDsName);
        InvDatasetImpl ds = new InvDatasetImpl(null, null, null, null, dsUrlPath);
        DatasetNamer dsNamer = new DatasetNamer((InvDataset)dsParent, namerName, true, DatasetNamerType.REGULAR_EXPRESSION, namerMatchPattern, namerSubstitutionPattern, null, null);
        TestDatasetNamer.assertTrue((String)("Namer <" + dsNamer.getName() + "> failed to name dataset <urlPath=" + ds.getUrlPath() + ">"), (boolean)dsNamer.nameDataset(ds));
        TestDatasetNamer.assertTrue((String)("Dataset name <" + ds.getName() + "> does not match expected <" + dsName + ">."), (boolean)ds.getName().equals(dsName));
    }
}

