/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import thredds.catalog2.xml.parser.CatalogXmlUtils;

public class XMLEvent_WriteAsEncodedUnicodeMethodTest {
    private XMLInputFactory factory;

    @Before
    public void init() {
        this.factory = XMLInputFactory.newInstance();
        this.factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        this.factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }

    @Test
    public void tryWriteAsEncodedUnicode() throws XMLStreamException {
        String xml = CatalogXmlUtils.wrapThreddsXmlInCatalog("<serviceName>OPeNDAP</serviceName>", null);
        String baseUriString = "http://test.metadata.parser/tmd.xml";
        StringReader reader = new StringReader(xml);
        StreamSource source = new StreamSource(reader, baseUriString);
        XMLEventReader eventReader = this.factory.createXMLEventReader(source);
        StringWriter writer = new StringWriter();
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            event.writeAsEncodedUnicode(writer);
        }
        writer.flush();
        String resultingXml = writer.toString();
        Assert.assertTrue((String)("XMLEvent.writeAsEncodedUnicode() is working.\n" + resultingXml), (boolean)resultingXml.equals(""));
    }
}

