/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.xml.parser.CatalogXmlUtils;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParser;
import ucar.nc2.units.DateType;

public class ParseCatalogTest {
    @Test
    public void parseCatalog() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String baseUriString = "http://cat2.stax.ParseCatalogTest/simpleCatalog.xml";
        URI docBaseUri = new URI(baseUriString);
        DateType expires = new DateType(false, new Date(System.currentTimeMillis() + 3600000L));
        String xml = CatalogXmlUtils.getCatalog(expires);
        StaxThreddsXmlParser cp = StaxThreddsXmlParser.newInstance();
        CatalogBuilder catBuilder = cp.parseIntoBuilder((Reader)new StringReader(xml), docBaseUri);
        Assert.assertNotNull((Object)catBuilder);
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, expires);
    }

    @Test
    public void parseCatalogWithService() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String baseUriString = "http://cat2.stax.ParseCatalogTest/CatalogWithService.xml";
        URI docBaseUri = new URI(baseUriString);
        DateType expires = new DateType(false, new Date(System.currentTimeMillis() + 3600000L));
        String xml = CatalogXmlUtils.getCatalogWithService(expires);
        StaxThreddsXmlParser cp = StaxThreddsXmlParser.newInstance();
        CatalogBuilder catBuilder = cp.parseIntoBuilder((Reader)new StringReader(xml), docBaseUri);
        Assert.assertNotNull((Object)catBuilder);
        CatalogXmlUtils.assertCatalogWithServiceAsExpected(catBuilder, docBaseUri, expires);
    }

    @Test
    public void parseCatalogWithCompoundService() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String baseUriString = "http://cat2.stax.ParseCatalogTest/CatalogWithCompoundService.xml";
        URI docBaseUri = new URI(baseUriString);
        DateType expires = new DateType(false, new Date(System.currentTimeMillis() + 3600000L));
        String xml = CatalogXmlUtils.getCatalogWithCompoundService(expires);
        StaxThreddsXmlParser cp = StaxThreddsXmlParser.newInstance();
        CatalogBuilder catBuilder = cp.parseIntoBuilder((Reader)new StringReader(xml), docBaseUri);
        Assert.assertNotNull((Object)catBuilder);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, expires);
    }

    @Test
    public void parseContainerDatasetWithMetadataServicename() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://cat2.stax.ParseContainerDatasetTest/MetadataServiceName.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catXml = CatalogXmlUtils.wrapThreddsXmlInCatalogDatasetMetadata("<serviceName>odap</serviceName>\n");
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catXml);
        Assert.assertNotNull((Object)catBuilder);
    }

    @Test
    public void parseAccessibleDatasetWithRawServiceName() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String xml = CatalogXmlUtils.getCatalogWithSingleAccessDatasetWithRawServiceName();
        String baseUriString = "http://cat2.stax.ParseAccessibleDatasetTest/RawServiceName.xml";
        StaxThreddsXmlParser cp = StaxThreddsXmlParser.newInstance();
        URI docBaseUri = new URI(baseUriString);
        CatalogBuilder catBuilder = cp.parseIntoBuilder((Reader)new StringReader(xml), docBaseUri);
        Assert.assertNotNull((Object)catBuilder);
        CatalogXmlUtils.assertCatalogHasSingleAccessDataset(catBuilder, docBaseUri);
    }

    @Test
    public void parseAccessibleDatasetWithMetadataServiceName() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String xml = CatalogXmlUtils.getCatalogWithSingleAccessDatasetWithMetadataServiceName();
        String baseUriString = "http://cat2.stax.ParseAccessibleDatasetTest/MetadataServiceName.xml";
        StaxThreddsXmlParser cp = StaxThreddsXmlParser.newInstance();
        URI docBaseUri = new URI(baseUriString);
        CatalogBuilder catBuilder = cp.parseIntoBuilder((Reader)new StringReader(xml), docBaseUri);
        Assert.assertNotNull((Object)catBuilder);
        CatalogXmlUtils.assertCatalogHasSingleAccessDataset(catBuilder, docBaseUri);
    }

    @Test
    public void parseAccessibleDatasetWithInheritedMetadataServiceName() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String xml = CatalogXmlUtils.getCatalogWithSingleAccessDatasetWithInheritedMetadataServiceName();
        String baseUriString = "http://cat2.stax.ParseAccessibleDatasetTest/InheritedMetadataServiceName.xml";
        StaxThreddsXmlParser cp = StaxThreddsXmlParser.newInstance();
        URI docBaseUri = new URI(baseUriString);
        CatalogBuilder catBuilder = cp.parseIntoBuilder((Reader)new StringReader(xml), docBaseUri);
        Assert.assertNotNull((Object)catBuilder);
        CatalogXmlUtils.assertCatalogHasSingleAccessDataset(catBuilder, docBaseUri);
    }

    @Test
    public void parseAccessibleDatasetOldStyle() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String xml = CatalogXmlUtils.getCatalogWithSingleAccessDatasetOldStyle();
        String baseUriString = "http://cat2.stax.ParseAccessibleDatasetTest/OldStyleAccess.xml";
        StaxThreddsXmlParser cp = StaxThreddsXmlParser.newInstance();
        URI docBaseUri = new URI(baseUriString);
        CatalogBuilder catBuilder = cp.parseIntoBuilder((Reader)new StringReader(xml), docBaseUri);
        Assert.assertNotNull((Object)catBuilder);
        CatalogXmlUtils.assertCatalogHasSingleAccessDataset(catBuilder, docBaseUri);
    }

    @Test
    public void parseNestedDatasetWithRawServiceName() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String xml = CatalogXmlUtils.getNestedDatasetWithRawServiceName();
        String baseUriString = "http://cat2.stax.ParseNestedDatasetTest/RawServiceNameNotAccessible.xml";
        System.out.println("Catalog [" + baseUriString + "]:\n" + xml);
        StaxThreddsXmlParser cp = StaxThreddsXmlParser.newInstance();
        URI docBaseUri = new URI(baseUriString);
        CatalogBuilder catBuilder = cp.parseIntoBuilder((Reader)new StringReader(xml), docBaseUri);
        Assert.assertNotNull((Object)catBuilder);
        CatalogXmlUtils.assertNestedDatasetIsNotAccessible(catBuilder, docBaseUri);
    }

    @Test
    public void parseNestedDatasetWithMetadataServiceName() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String xml = CatalogXmlUtils.getNestedDatasetWithMetadataServiceName();
        String baseUriString = "http://cat2.stax.ParseNestedDatasetTest/MetadataServiceNameNotAccessible.xml";
        StaxThreddsXmlParser cp = StaxThreddsXmlParser.newInstance();
        URI docBaseUri = new URI(baseUriString);
        CatalogBuilder catBuilder = cp.parseIntoBuilder((Reader)new StringReader(xml), docBaseUri);
        Assert.assertNotNull((Object)catBuilder);
        CatalogXmlUtils.assertNestedDatasetIsNotAccessible(catBuilder, docBaseUri);
    }

    @Test
    public void parseNestedDatasetWithUninheritedMetadataServiceName() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String xml = CatalogXmlUtils.getNestedDatasetWithUninheritedMetadataServiceName();
        String baseUriString = "http://cat2.stax.ParseNestedDatasetTest/UninheritedMetadataServiceNameNotAccessible.xml";
        StaxThreddsXmlParser cp = StaxThreddsXmlParser.newInstance();
        URI docBaseUri = new URI(baseUriString);
        CatalogBuilder catBuilder = cp.parseIntoBuilder((Reader)new StringReader(xml), docBaseUri);
        Assert.assertNotNull((Object)catBuilder);
        CatalogXmlUtils.assertNestedDatasetIsNotAccessible(catBuilder, docBaseUri);
    }

    @Test
    public void parseNestedDatasetWithInheritedMetadataServiceName() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String xml = CatalogXmlUtils.getNestedDatasetWithInheritedMetadataServiceName();
        String baseUriString = "http://cat2.stax.ParseNestedDatasetTest/InheritedMetadataServiceNameNotAccessible.xml";
        StaxThreddsXmlParser cp = StaxThreddsXmlParser.newInstance();
        URI docBaseUri = new URI(baseUriString);
        CatalogBuilder catBuilder = cp.parseIntoBuilder((Reader)new StringReader(xml), docBaseUri);
        Assert.assertNotNull((Object)catBuilder);
        CatalogXmlUtils.assertNestedDatasetIsAccessible(catBuilder, docBaseUri);
    }
}

