/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser;

import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog2.Catalog;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.xml.parser.CatalogXmlUtils;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;

public class TestCatalogParser {
    @Test
    public void testCatalog() throws URISyntaxException, ThreddsXmlParserException, BuilderException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/TestCatalogParser/testCatalog.xml";
        URI docBaseUri = new URI(docBaseUriString);
        StringBuilder doc = new StringBuilder("<?xml version='1.0' encoding='UTF-8'?>\n").append("<catalog xmlns='http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0'").append(" xmlns:xlink='http://www.w3.org/1999/xlink'").append(" name='Unidata THREDDS Data Server' version='1.0.1'>\n").append("  <service name='all' serviceType='Compound' base=''>\n").append("    <service name='odap' serviceType='OPENDAP' base='/thredds/dodsC/' />\n").append("    <service name='wcs' serviceType='WCS' base='/thredds/wcs/'>\n").append("      <property name='someInfo' value='good stuff' />\n").append("    </service>").append("  </service>").append("  <property name='moreInfo' value='more good stuff' />\n").append("  <dataset name='fred'>").append("    <access urlPath='fred.nc' serviceName='odap' />").append("  </dataset>").append("  <dataset name='fred2' serviceName='odap' urlPath='fred2.nc' />").append("  <dataset name=\"Realtime data from IDD\">\n").append("    <catalogRef xlink:href=\"idd/models.xml\" xlink:title=\"NCEP Model Data\" name=\"\" />\n").append("    <catalogRef xlink:href=\"idd/radars.xml\" xlink:title=\"NEXRAD Radar\" name=\"\" />\n").append("    <catalogRef xlink:href=\"idd/obsData.xml\" xlink:title=\"Station Data\" name=\"\" />\n").append("    <catalogRef xlink:href=\"idd/satellite.xml\" xlink:title=\"Satellite Data\" name=\"\" />\n").append("  </dataset>\n").append("  <dataset name=\"Other Unidata Data\">\n").append("\n").append("    <catalogRef xlink:href=\"idd/rtmodel.xml\" xlink:title=\"Unidata Real-time Regional Model\" name=\"\" />\n").append("    <catalogRef xlink:href=\"galeon/catalog.xml\" xlink:title=\"Unidata GALEON Experimental Web Coverage Service (WCS) datasets\" name=\"\" />\n").append("    <dataset name=\"Test Restricted Dataset\" ID=\"testRestrictedDataset\" urlPath=\"restrict/testData.nc\" restrictAccess=\"tiggeData\">\n").append("      <serviceName>odap</serviceName>\n").append("      <dataType>Grid</dataType>\n").append("    </dataset>\n").append("  </dataset>\n").append("</catalog>");
        CatalogBuilder catBldr = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, doc.toString());
        String catName = "Unidata THREDDS Data Server";
        Assert.assertTrue((String)("Catalog name [" + catBldr.getName() + "] not as expected [" + catName + "]."), (boolean)catBldr.getName().equals(catName));
        Catalog cat = catBldr.build();
        cat.getServices();
        CatalogXmlUtils.writeCatalogXml(cat);
    }
}

