/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.simpleImpl.ThreddsMetadataImpl;

public class VariableTest {
    @Test
    public void checkVariableCtorAndGet() {
        String vocabAuthId = "vocabAuthId";
        String vocabAuthUrl = "vocabAuthUrl";
        ThreddsMetadataBuilder.VariableGroupBuilder mockVarGrp = this.createMockVarGroupBasic(vocabAuthId, vocabAuthUrl);
        String name = "name";
        String desc = "descrip";
        String units = "unit";
        String vocabId = "vocabId";
        String vocabName = "vocabName";
        ThreddsMetadataImpl.VariableImpl var = new ThreddsMetadataImpl.VariableImpl(name, desc, units, vocabId, vocabName, mockVarGrp);
        Assert.assertEquals((Object)name, (Object)var.getName());
        Assert.assertEquals((Object)desc, (Object)var.getDescription());
        Assert.assertEquals((Object)units, (Object)var.getUnits());
        Assert.assertEquals((Object)vocabId, (Object)var.getVocabularyId());
        Assert.assertEquals((Object)vocabName, (Object)var.getVocabularyName());
        Assert.assertEquals((Object)vocabAuthId, (Object)var.getVocabularyAuthorityId());
        Assert.assertEquals((Object)vocabAuthUrl, (Object)var.getVocabularyAuthorityUrl());
    }

    @Test
    public void checkVariableSetGet() {
        String vocabAuthId = "vocabAuthId";
        String vocabAuthUrl = "vocabAuthUrl";
        ThreddsMetadataBuilder.VariableGroupBuilder mockVarGrp = this.createMockVarGroupBasic(vocabAuthId, vocabAuthUrl);
        ThreddsMetadataImpl.VariableImpl var = new ThreddsMetadataImpl.VariableImpl("name", "descrip", "unit", "vocabId", "vocabName", mockVarGrp);
        String name2 = "name2";
        String desc2 = "descrip2";
        String units2 = "unit2";
        String vocabId2 = "vocabId2";
        String vocabName2 = "vocabName2";
        var.setName(name2);
        Assert.assertEquals((Object)name2, (Object)var.getName());
        var.setDescription(desc2);
        Assert.assertEquals((Object)desc2, (Object)var.getDescription());
        var.setUnits(units2);
        Assert.assertEquals((Object)units2, (Object)var.getUnits());
        var.setVocabularyId(vocabId2);
        Assert.assertEquals((Object)vocabId2, (Object)var.getVocabularyId());
        var.setVocabularyName(vocabName2);
        Assert.assertEquals((Object)vocabName2, (Object)var.getVocabularyName());
        Assert.assertEquals((Object)vocabAuthId, (Object)var.getVocabularyAuthorityId());
        Assert.assertEquals((Object)vocabAuthUrl, (Object)var.getVocabularyAuthorityUrl());
    }

    @Test
    public void checkVariableNoBuildIssues() {
        String vocabAuthId = "vocabAuthId";
        String vocabAuthUrl = "vocabAuthUrl";
        ThreddsMetadataBuilder.VariableGroupBuilder mockVarGrp = this.createMockVarGroupBasic(vocabAuthId, vocabAuthUrl);
        ThreddsMetadataImpl.VariableImpl var = new ThreddsMetadataImpl.VariableImpl("name", "descrip", "unit", "vocabId", "vocabName", mockVarGrp);
        BuilderIssues bldrIssues = var.getIssues();
        Assert.assertTrue((boolean)bldrIssues.isEmpty());
    }

    @Test
    public void checkVariableWithNullNameHasBuildIssue() {
        String vocabAuthId = "vocabAuthId";
        String vocabAuthUrl = "vocabAuthUrl";
        ThreddsMetadataBuilder.VariableGroupBuilder mockVarGrp = this.createMockVarGroupBasic(vocabAuthId, vocabAuthUrl);
        ThreddsMetadataImpl.VariableImpl var = new ThreddsMetadataImpl.VariableImpl(null, "descrip", "unit", "vocabId", "vocabName", mockVarGrp);
        BuilderIssues bldrIssues = var.getIssues();
        Assert.assertFalse((boolean)bldrIssues.isEmpty());
        Assert.assertEquals((long)1L, (long)bldrIssues.size());
    }

    @Test
    public void checkVariableWhereNameIsOnlyNonNullHasNoBuildIssue() {
        String vocabAuthId = "vocabAuthId";
        String vocabAuthUrl = "vocabAuthUrl";
        ThreddsMetadataBuilder.VariableGroupBuilder mockVarGrp = this.createMockVarGroupBasic(vocabAuthId, vocabAuthUrl);
        ThreddsMetadataImpl.VariableImpl var = new ThreddsMetadataImpl.VariableImpl("name", null, null, null, null, mockVarGrp);
        BuilderIssues bldrIssues = var.getIssues();
        Assert.assertTrue((boolean)bldrIssues.isEmpty());
    }

    private ThreddsMetadataBuilder.VariableGroupBuilder createMockVarGroupBasic(String vocabAuthId, String vocabAuthUrl) {
        ThreddsMetadataBuilder.VariableGroupBuilder mockVarGrp = (ThreddsMetadataBuilder.VariableGroupBuilder)EasyMock.createMock(ThreddsMetadataBuilder.VariableGroupBuilder.class);
        EasyMock.expect((Object)mockVarGrp.getVocabularyAuthorityId()).andReturn((Object)vocabAuthId);
        EasyMock.expect((Object)mockVarGrp.getVocabularyAuthorityUrl()).andReturn((Object)vocabAuthUrl);
        EasyMock.replay((Object[])new Object[]{mockVarGrp});
        return mockVarGrp;
    }
}

