/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import thredds.catalog.DataFormatType;
import thredds.catalog2.ThreddsMetadata;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.simpleImpl.ThreddsMetadataImpl;
import ucar.nc2.constants.FeatureType;

public class TestThreddsMetadataImpl {
    private ThreddsMetadataImpl tmi;
    private ThreddsMetadataBuilder tmb;
    private ThreddsMetadata tm;
    private ThreddsMetadataBuilder.DocumentationBuilder docBldr1;
    private String doc1Ref;
    private URI doc1RefUri;
    private String doc1Title;
    private ThreddsMetadataBuilder.DocumentationBuilder docBldr2;
    private String doc2Content;
    private String kp1;
    private String kp2;
    private String kp3;
    private String projectTitle;
    private ThreddsMetadata.DatePoint dateCreated;
    private ThreddsMetadata.DatePoint dateModified;
    private ThreddsMetadata.DatePoint dateIssued;
    private ThreddsMetadata.DatePoint dateValid;
    private ThreddsMetadata.DatePoint dateAvailable;
    private ThreddsMetadata.DatePoint dateMetadataCreated;
    private ThreddsMetadata.DatePoint dateMetadataModified;
    private ThreddsMetadata.DateRange temporalCoverage;
    private long dataSizeInBytes;
    private DataFormatType dataFormat;
    private FeatureType dataType;
    private String collectionType;

    @Before
    public void setUp() throws URISyntaxException {
        this.doc1Ref = "http://server/thredds/doc.xml";
        this.doc1RefUri = new URI(this.doc1Ref);
        this.doc1Title = "documentation title";
        this.doc2Content = "<x>some content</x>";
        this.tmi = new ThreddsMetadataImpl();
        this.tmb = this.tmi;
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkDatePointWithNullDateThrowsException() throws BuilderException {
        new ThreddsMetadataImpl.DatePointImpl(null, "", "");
    }

    @Test
    public void checkDatePointEquality() throws BuilderException {
        String dateString1 = "2009-08-25T12:00";
        String dateFormatString = "yyyy-MM-dd'T'HH:mm";
        String dateTypeCreated = "created";
        ThreddsMetadataImpl.DatePointImpl date1 = new ThreddsMetadataImpl.DatePointImpl(dateString1, dateFormatString, dateTypeCreated);
        ThreddsMetadataImpl.DatePointImpl date2 = new ThreddsMetadataImpl.DatePointImpl(dateString1, dateFormatString, dateTypeCreated);
        ThreddsMetadataImpl.DatePointImpl dateDiff1 = new ThreddsMetadataImpl.DatePointImpl(dateString1, dateFormatString, dateTypeCreated);
        Assert.assertEquals((Object)date1, (Object)date2);
        date1.build();
        Assert.assertEquals((Object)date1, (Object)date2);
        date2.build();
        Assert.assertEquals((Object)date1, (Object)date2);
    }

    @Test
    public void testSimpleSetGet() {
        this.projectTitle = "my project";
        this.dateCreated = new ThreddsMetadataImpl.DatePointImpl("2009-08-25T12:00", null, ThreddsMetadata.DatePointType.Created.toString());
        this.dateModified = new ThreddsMetadataImpl.DatePointImpl("2009-08-25T13:00", null, ThreddsMetadata.DatePointType.Modified.toString());
        this.dateIssued = new ThreddsMetadataImpl.DatePointImpl("2009-08-25T15:00", null, ThreddsMetadata.DatePointType.Issued.toString());
        this.dateValid = new ThreddsMetadataImpl.DatePointImpl("2009-08-25T12:00", null, ThreddsMetadata.DatePointType.Valid.toString());
        this.dateAvailable = new ThreddsMetadataImpl.DatePointImpl("2009-08-25T12:00", null, ThreddsMetadata.DatePointType.Available.toString());
        this.dateMetadataCreated = new ThreddsMetadataImpl.DatePointImpl("2009-08-25T12:00", null, ThreddsMetadata.DatePointType.MetadataCreated.toString());
        this.dateMetadataModified = new ThreddsMetadataImpl.DatePointImpl("2009-08-25T12:00", null, ThreddsMetadata.DatePointType.MetadataModified.toString());
        this.temporalCoverage = new ThreddsMetadataImpl.DateRangeImpl("2009-08-25T00:00", null, "2009-08-25T12:00", null, null, null);
        this.dataSizeInBytes = 56000L;
        this.dataFormat = DataFormatType.NETCDF;
        this.dataType = FeatureType.TRAJECTORY;
        this.collectionType = "timeSeries";
        this.tmi.addProjectName(null, this.projectTitle);
        this.tmi.setCreatedDatePointBuilder(this.dateCreated.getDate(), this.dateCreated.getDateFormat());
        this.tmi.setModifiedDatePointBuilder(this.dateModified.getDate(), this.dateModified.getDateFormat());
        this.tmi.setIssuedDatePointBuilder(this.dateIssued.getDate(), this.dateIssued.getDateFormat());
        this.tmi.setValidDatePointBuilder(this.dateValid.getDate(), this.dateValid.getDateFormat());
        this.tmi.setAvailableDatePointBuilder(this.dateAvailable.getDate(), this.dateAvailable.getDateFormat());
        this.tmi.setMetadataCreatedDatePointBuilder(this.dateMetadataCreated.getDate(), this.dateMetadataCreated.getDateFormat());
        this.tmi.setMetadataModifiedDatePointBuilder(this.dateMetadataModified.getDate(), this.dateMetadataModified.getDateFormat());
        this.tmi.setTemporalCoverageBuilder(this.temporalCoverage.getStartDate(), this.temporalCoverage.getStartDateFormat(), this.temporalCoverage.getEndDate(), this.temporalCoverage.getEndDateFormat(), this.temporalCoverage.getDuration(), this.temporalCoverage.getResolution());
        this.tmi.setDataSizeInBytes(this.dataSizeInBytes);
        this.tmi.setDataFormat(this.dataFormat);
        this.tmi.setDataType(this.dataType);
        this.tmi.setCollectionType(this.collectionType);
        this.buildBuilder();
        Assert.assertTrue((boolean)this.tmb.isBuilt());
        List projectNames = this.tmi.getProjectNames();
        Assert.assertNotNull((Object)projectNames);
        Assert.assertEquals((long)1L, (long)projectNames.size());
        ThreddsMetadata.ProjectName projectName = (ThreddsMetadata.ProjectName)projectNames.get(0);
        Assert.assertNotNull((Object)projectName);
        Assert.assertEquals((Object)this.projectTitle, (Object)projectName.getName());
        Assert.assertTrue((boolean)this.tmi.getCreatedDate().equals(this.dateCreated));
        Assert.assertTrue((boolean)this.tmi.getModifiedDate().equals(this.dateModified));
        Assert.assertTrue((boolean)this.tmi.getIssuedDate().equals(this.dateIssued));
        Assert.assertTrue((boolean)this.tmi.getValidDate().equals(this.dateValid));
        Assert.assertTrue((boolean)this.tmi.getAvailableDate().equals(this.dateAvailable));
        Assert.assertTrue((boolean)this.tmi.getMetadataCreatedDate().equals(this.dateMetadataCreated));
        Assert.assertTrue((boolean)this.tmi.getMetadataModifiedDate().equals(this.dateMetadataModified));
        Assert.assertTrue((boolean)this.tmi.getTemporalCoverage().equals(this.temporalCoverage));
        Assert.assertTrue((this.tmi.getDataSizeInBytes() == this.dataSizeInBytes ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.tmi.getDataFormat().equals((Object)this.dataFormat));
        Assert.assertTrue((boolean)this.tmi.getDataType().equals((Object)this.dataType));
        Assert.assertTrue((boolean)this.tmi.getCollectionType().equals(this.collectionType));
    }

    @Test
    public void testDocumentation() {
        Assert.assertFalse((boolean)this.tmi.isBuilt());
        List docBldrList = this.tmi.getDocumentationBuilders();
        Assert.assertTrue((boolean)docBldrList.isEmpty());
        this.docBldr1 = this.tmi.addDocumentation(null, this.doc1Title, this.doc1Ref);
        this.docBldr2 = this.tmi.addDocumentation(null, this.doc2Content);
        docBldrList = this.tmi.getDocumentationBuilders();
        Assert.assertTrue((docBldrList.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((docBldrList.get(0) == this.docBldr1 ? 1 : 0) != 0);
        Assert.assertTrue((docBldrList.get(1) == this.docBldr2 ? 1 : 0) != 0);
        this.tmi.removeDocumentation(this.docBldr1);
        docBldrList = this.tmi.getDocumentationBuilders();
        Assert.assertTrue((docBldrList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((docBldrList.get(0) == this.docBldr2 ? 1 : 0) != 0);
        this.checkBuilderDocumentationIllegalStateGet();
        this.buildBuilder();
        Assert.assertTrue((boolean)this.tmb.isBuilt());
        Assert.assertTrue((boolean)this.docBldr2.isBuilt());
        List docList = this.tm.getDocumentation();
        Assert.assertTrue((docList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((docList.get(0) == this.docBldr2 ? 1 : 0) != 0);
        this.checkBuiltDocumentationIllegalStateGet();
    }

    private void buildBuilder() {
        BuilderIssues issues = this.tmb.getIssues();
        if (!issues.isValid()) {
            StringBuilder stringBuilder = new StringBuilder("Not isBuildable(): ").append(issues.toString());
            Assert.fail((String)stringBuilder.toString());
        }
        try {
            this.tm = this.tmb.build();
        }
        catch (BuilderException e) {
            Assert.fail((String)("Build failed: " + e.getMessage()));
        }
        Assert.assertTrue((boolean)this.tmb.isBuilt());
    }

    private void checkBuilderDocumentationIllegalStateGet() {
        try {
            this.tmi.getDocumentation();
        }
        catch (IllegalStateException ise) {
            return;
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected non-IllegalStateException: " + e.getMessage()));
        }
        Assert.fail((String)"Did not throw expected IllegalStateException.");
    }

    private void checkBuiltDocumentationIllegalStateGet() {
        try {
            this.tmi.getDocumentationBuilders();
        }
        catch (IllegalStateException ise) {
            return;
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected non-IllegalStateException: " + e.getMessage()));
        }
        Assert.fail((String)"Did not throw expected IllegalStateException.");
    }
}

