/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import thredds.catalog2.CatalogRef;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.CatalogRefBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.simpleImpl.CatalogImpl;

public class TestCatalogRefImpl
extends TestCase {
    private CatalogImpl parentCatalog;
    private String parentCatName;
    private URI parentCatDocBaseUri;
    private String parentCatVer;
    private DatasetNodeBuilder parentDataset;
    private String parentDsName;
    private CatalogRefBuilder catRefBldr;
    private CatalogRef catRef;
    private String catRefName;
    private URI catRefUri;
    private URI catRefUri2;

    public TestCatalogRefImpl(String name) {
        super(name);
    }

    protected void setUp() {
        this.parentCatName = "parent catalog";
        try {
            this.parentCatDocBaseUri = new URI("http://server/thredds/aCat.xml");
            this.catRefUri = new URI("http://server/thredds/cat2.xml");
            this.catRefUri2 = new URI("http://server/thredds/cat3.xml");
        }
        catch (URISyntaxException e) {
            TestCatalogRefImpl.fail((String)("Bad URI syntax: " + e.getMessage()));
            return;
        }
        this.parentCatVer = "version";
        this.parentCatalog = new CatalogImpl(this.parentCatName, this.parentCatDocBaseUri, this.parentCatVer, null, null);
        this.parentDsName = "parent dataset";
        this.parentDataset = this.parentCatalog.addDataset(this.parentDsName);
        this.catRefName = "catRef name";
        this.catRefBldr = this.parentDataset.addCatalogRef(this.catRefName, this.catRefUri);
    }

    public void testGetSet() {
        TestCatalogRefImpl.assertFalse((boolean)this.catRefBldr.isBuilt());
        TestCatalogRefImpl.assertTrue((boolean)this.catRefBldr.getName().equals(this.catRefName));
        TestCatalogRefImpl.assertTrue((boolean)this.catRefBldr.getReference().equals(this.catRefUri));
        this.catRefBldr.setReference(this.catRefUri2);
        TestCatalogRefImpl.assertTrue((boolean)this.catRefBldr.getReference().equals(this.catRefUri2));
    }

    public void testBuild() {
        BuilderIssues issues = this.catRefBldr.getIssues();
        if (!issues.isValid()) {
            StringBuilder stringBuilder = new StringBuilder("Invalid CatRef: ").append(issues.toString());
            TestCatalogRefImpl.fail((String)stringBuilder.toString());
        }
        try {
            this.catRef = this.catRefBldr.build();
        }
        catch (BuilderException e) {
            TestCatalogRefImpl.fail((String)("Build failed: " + e.getMessage()));
        }
        TestCatalogRefImpl.assertTrue((boolean)this.catRefBldr.isBuilt());
        TestCatalogRefImpl.assertTrue((boolean)this.catRef.getName().equals(this.catRefName));
        TestCatalogRefImpl.assertTrue((boolean)this.catRef.getReference().equals(this.catRefUri));
        try {
            this.catRefBldr.setReference(this.catRefUri2);
        }
        catch (IllegalStateException ise) {
            return;
        }
        catch (Exception e) {
            TestCatalogRefImpl.fail((String)("Unexpected non-IllegalStateException thrown: " + e.getMessage()));
        }
        TestCatalogRefImpl.fail((String)"Did not throw expected IllegalStateException.");
    }
}

