/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import thredds.catalog.ServiceType;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.CatalogRefBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.simpleImpl.CatalogImpl;
import thredds.catalog2.simpleImpl.ServiceImpl;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public class TestCatalogImpl {
    private CatalogImpl catImpl;
    private String catName;
    private URI catDocBaseUri;
    private String catVersion;
    private DateType catExpires;
    private DateType catLastModified;
    private DateType catExpires2;
    private DateType catLastModified2;
    private URI docBaseUri;
    private ServiceType type;
    private URI baseUri;

    @Before
    public void setupBasicCatalog() throws URISyntaxException, ParseException {
        this.catName = "Catalog Name";
        this.catDocBaseUri = new URI("http://server/thredds/cat.xml");
        this.catVersion = "1.0.2";
        this.catLastModified = new DateType(false, new Date(System.currentTimeMillis()));
        this.catExpires = new DateType(this.catLastModified).add(new TimeDuration("P5D"));
        this.catLastModified2 = this.catLastModified.add(new TimeDuration("P1D"));
        this.catExpires2 = this.catLastModified2.add(new TimeDuration("P5D"));
        this.catImpl = new CatalogImpl(this.catName, this.catDocBaseUri, this.catVersion, this.catExpires, this.catLastModified);
        try {
            this.baseUri = new URI("http://server/thredds/dodsC/");
            this.docBaseUri = new URI("http://server/thredds/aCat.xml");
        }
        catch (URISyntaxException e) {
            Assert.fail((String)("Bad URI syntax: " + e.getMessage()));
        }
        this.type = ServiceType.OPENDAP;
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkForExceptionOnConstructorWithNullDocBaseUri() {
        new CatalogImpl(this.catName, null, this.catVersion, this.catExpires, this.catLastModified);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkForExceptionWhenNullSetDocBaseUri() {
        this.catImpl.setDocBaseUri(null);
    }

    @Test
    public void checkConstructorWithOtherNulls() {
        new CatalogImpl(null, this.catDocBaseUri, this.catVersion, this.catExpires, this.catLastModified);
        new CatalogImpl(this.catName, this.catDocBaseUri, null, this.catExpires, this.catLastModified);
        new CatalogImpl(this.catName, this.catDocBaseUri, this.catVersion, null, this.catLastModified);
        new CatalogImpl(this.catName, this.catDocBaseUri, this.catVersion, this.catExpires, null);
    }

    @Test
    public void checkOtherSettersWithNull() {
        this.catImpl.setName(null);
        this.catImpl.setVersion(null);
        this.catImpl.setExpires(null);
        this.catImpl.setLastModified(null);
    }

    @Test
    public void checkCatalogAsExpected() {
        this.assertBasicCatalogAsExpected();
    }

    private void assertBasicCatalogAsExpected() {
        Assert.assertEquals((Object)this.catName, (Object)this.catImpl.getName());
        Assert.assertEquals((Object)this.catDocBaseUri, (Object)this.catImpl.getDocBaseUri());
        Assert.assertEquals((Object)this.catVersion, (Object)this.catImpl.getVersion());
        Assert.assertEquals((Object)this.catExpires, (Object)this.catImpl.getExpires());
        Assert.assertEquals((Object)this.catLastModified, (Object)this.catImpl.getLastModified());
    }

    @Test
    public void checkChangedCatalogAsExpected() throws URISyntaxException {
        this.catImpl.setName("name");
        Assert.assertEquals((Object)"name", (Object)this.catImpl.getName());
        URI uri = new URI("http://server/thredds/bad/");
        this.catImpl.setDocBaseUri(uri);
        Assert.assertEquals((Object)uri, (Object)this.catImpl.getDocBaseUri());
        this.catImpl.setVersion("ver");
        Assert.assertEquals((Object)"ver", (Object)this.catImpl.getVersion());
        this.catImpl.setExpires(this.catExpires2);
        Assert.assertEquals((Object)this.catExpires2, (Object)this.catImpl.getExpires());
        this.catImpl.setLastModified(this.catLastModified2);
        Assert.assertEquals((Object)this.catLastModified2, (Object)this.catImpl.getLastModified());
    }

    @Test
    public void checkCatalogAddGetRemoveProperties() {
        this.catImpl.addProperty("color", "red");
        this.catImpl.addProperty("taste", "sweet");
        this.assertBasicCatalogAsExpected();
        Assert.assertEquals((Object)"red", (Object)this.catImpl.getPropertyValue("color"));
        Assert.assertEquals((Object)"sweet", (Object)this.catImpl.getPropertyValue("taste"));
        Assert.assertTrue((boolean)this.catImpl.removeProperty("color"));
        Assert.assertNull((Object)this.catImpl.getPropertyValue("color"));
    }

    @Test
    public void checkCatalogAddGetRemoveServices() throws URISyntaxException {
        ServiceBuilder odapService = this.catImpl.addService("odap", ServiceType.OPENDAP, new URI("http://server/thredds/dodsC/"));
        ServiceBuilder wcsService = this.catImpl.addService("wcs", ServiceType.WCS, new URI("http://server/thredds/wcs/"));
        this.assertBasicCatalogAsExpected();
        Assert.assertEquals((Object)odapService, (Object)this.catImpl.getServiceBuilderByName("odap"));
        Assert.assertEquals((Object)wcsService, (Object)this.catImpl.getServiceBuilderByName("wcs"));
        List services = this.catImpl.getServiceBuilders();
        Assert.assertFalse((boolean)services.isEmpty());
        Assert.assertEquals((long)2L, (long)services.size());
        Assert.assertEquals((Object)odapService, services.get(0));
        Assert.assertEquals((Object)wcsService, services.get(1));
        Assert.assertTrue((boolean)this.catImpl.removeService(odapService));
        Assert.assertNull((Object)this.catImpl.getServiceBuilderByName("odap"));
    }

    @Test
    public void checkCatalogAddGetRemoveCatalogRefsAndDatasets() throws URISyntaxException {
        CatalogRefBuilder cat2 = this.catImpl.addCatalogRef("cat2", new URI("http://server/thredds/cat2.xml"));
        CatalogRefBuilder cat3 = this.catImpl.addCatalogRef("cat3", new URI("http://server/thredds/cat3.xml"));
        cat2.setId("cat2");
        cat3.setId("cat3");
        DatasetBuilder ds1 = this.catImpl.addDataset("data1");
        DatasetBuilder ds2 = this.catImpl.addDataset("data2");
        ds1.setId("dataId1");
        ds2.setId("dataId2");
        this.assertBasicCatalogAsExpected();
        Assert.assertEquals((Object)cat2, (Object)this.catImpl.getDatasetNodeBuilderById("cat2"));
        Assert.assertEquals((Object)cat3, (Object)this.catImpl.getDatasetNodeBuilderById("cat3"));
        Assert.assertEquals((Object)ds1, (Object)this.catImpl.getDatasetNodeBuilderById("dataId1"));
        Assert.assertEquals((Object)ds2, (Object)this.catImpl.getDatasetNodeBuilderById("dataId2"));
        List dsNodes = this.catImpl.getDatasetNodeBuilders();
        Assert.assertFalse((boolean)dsNodes.isEmpty());
        Assert.assertEquals((long)4L, (long)dsNodes.size());
        Assert.assertEquals((Object)cat2, dsNodes.get(0));
        Assert.assertEquals((Object)cat3, dsNodes.get(1));
        Assert.assertEquals((Object)ds1, dsNodes.get(2));
        Assert.assertEquals((Object)ds2, dsNodes.get(3));
        Assert.assertTrue((boolean)this.catImpl.removeDataset((DatasetNodeBuilder)cat2));
        Assert.assertTrue((boolean)this.catImpl.removeDataset((DatasetNodeBuilder)ds1));
        Assert.assertNull((Object)this.catImpl.getDatasetNodeBuilderById("cat2"));
        Assert.assertNull((Object)this.catImpl.getDatasetNodeBuilderById("dataId1"));
    }

    @Test
    public void checkBuildIssuesForMultipleServices() throws URISyntaxException {
        this.catImpl.addService("odap", ServiceType.OPENDAP, new URI("http://server/thredds/dodsC/"));
        this.catImpl.addService("wcs", ServiceType.WCS, new URI("http://server/thredds/wcs/"));
        this.catImpl.addService("wms", ServiceType.WMS, new URI("http://server/thredds/wms/"));
        BuilderIssues issues = this.catImpl.getIssues();
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isValid());
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isEmpty());
    }

    @Test
    public void checkBuildIssuesForDuplicateServiceName() throws URISyntaxException {
        this.catImpl.addService("odap", ServiceType.OPENDAP, new URI("http://server/thredds/dodsC/"));
        this.catImpl.addService("odap", ServiceType.OPENDAP, new URI("http://server/thredds/dodsC/"));
        BuilderIssues issues = this.catImpl.getIssues();
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isValid());
        Assert.assertFalse((String)issues.toString(), (boolean)issues.isEmpty());
    }

    @Test
    public void checkBuildIssuesCompoundService() throws URISyntaxException {
        ServiceImpl compoundService = (ServiceImpl)this.catImpl.addService("all", ServiceType.COMPOUND, new URI(""));
        compoundService.addService("odap", ServiceType.OPENDAP, new URI("http://server/thredds/dodsC/"));
        compoundService.addService("wcs", ServiceType.WCS, new URI("http://server/thredds/wcs/"));
        compoundService.addService("wms", ServiceType.WMS, new URI("http://server/thredds/wms/"));
        BuilderIssues issues = this.catImpl.getIssues();
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isValid());
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isEmpty());
    }

    @Test
    public void checkBuildIssuesCompoundServiceWithDuplicate() throws URISyntaxException {
        ServiceImpl compoundService = (ServiceImpl)this.catImpl.addService("all", ServiceType.COMPOUND, new URI(""));
        compoundService.addService("odap", ServiceType.OPENDAP, new URI("http://server/thredds/dodsC/"));
        compoundService.addService("wcs", ServiceType.WCS, new URI("http://server/thredds/wcs/"));
        compoundService.addService("wms", ServiceType.WMS, new URI("http://server/thredds/wms/"));
        compoundService.addService("odap", ServiceType.WMS, new URI("http://server/thredds/wms/"));
        BuilderIssues issues = this.catImpl.getIssues();
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isValid());
        Assert.assertFalse((String)issues.toString(), (boolean)issues.isEmpty());
    }

    @Test
    public void checkBuildIssuesForDuplicateServiceNameInDifferentContainer() throws URISyntaxException {
        ServiceImpl compoundService = (ServiceImpl)this.catImpl.addService("all", ServiceType.COMPOUND, new URI(""));
        compoundService.addService("odap", ServiceType.OPENDAP, new URI("http://server/thredds/dodsC/"));
        compoundService.addService("wcs", ServiceType.WCS, new URI("http://server/thredds/wcs/"));
        compoundService.addService("wms", ServiceType.WMS, new URI("http://server/thredds/wms/"));
        compoundService.addService("odap", ServiceType.WMS, new URI("http://server/thredds/wms/"));
        this.catImpl.addService("odap", ServiceType.OPENDAP, new URI("http://server/thredds/dodsC/"));
        BuilderIssues issues = this.catImpl.getIssues();
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isValid());
        Assert.assertFalse((String)issues.toString(), (boolean)issues.isEmpty());
    }
}

