/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog.ServiceType;
import thredds.catalog2.simpleImpl.GlobalServiceContainer;
import thredds.catalog2.simpleImpl.ServiceImpl;

public class GlobalServiceContainerTest {
    @Test
    public void addAllServicesWithUniqueNames() throws URISyntaxException {
        GlobalServiceContainer globalServiceContainer = new GlobalServiceContainer();
        Assert.assertTrue((boolean)globalServiceContainer.isEmpty());
        ServiceImpl odapService = new ServiceImpl("odap", ServiceType.OPENDAP, new URI("http://server/thredds/dodsC/"), null);
        ServiceImpl wmsService = new ServiceImpl("wms", ServiceType.WMS, new URI("http://server/thredds/wms/"), null);
        ServiceImpl wcsService = new ServiceImpl("wcs", ServiceType.WCS, new URI("http://server/thredds/wcs/"), null);
        globalServiceContainer.addService(odapService);
        globalServiceContainer.addService(wmsService);
        globalServiceContainer.addService(wcsService);
        Assert.assertFalse((boolean)globalServiceContainer.isEmpty());
        Assert.assertEquals((long)3L, (long)globalServiceContainer.numberOfServicesWithGloballyUniqueNames());
        Assert.assertEquals((long)0L, (long)globalServiceContainer.numberOfServicesWithDuplicateNames());
        Assert.assertTrue((boolean)globalServiceContainer.isServiceNameInUseGlobally("odap"));
        Assert.assertTrue((boolean)globalServiceContainer.isServiceNameInUseGlobally("wms"));
        Assert.assertTrue((boolean)globalServiceContainer.isServiceNameInUseGlobally("wcs"));
        Assert.assertEquals((Object)odapService, (Object)globalServiceContainer.getServiceByGloballyUniqueName("odap"));
        Assert.assertEquals((Object)wmsService, (Object)globalServiceContainer.getServiceByGloballyUniqueName("wms"));
        Assert.assertEquals((Object)wcsService, (Object)globalServiceContainer.getServiceByGloballyUniqueName("wcs"));
    }

    @Test
    public void addServiceWithDuplicateName() throws URISyntaxException {
        GlobalServiceContainer globalServiceContainer = new GlobalServiceContainer();
        ServiceImpl odapService = new ServiceImpl("odap", ServiceType.OPENDAP, new URI("http://server/thredds/dodsC/"), null);
        ServiceImpl wmsService = new ServiceImpl("wms", ServiceType.WMS, new URI("http://server/thredds/wms/"), null);
        ServiceImpl wcsService = new ServiceImpl("wms", ServiceType.WCS, new URI("http://server/thredds/wcs/"), null);
        globalServiceContainer.addService(odapService);
        globalServiceContainer.addService(wmsService);
        globalServiceContainer.addService(wcsService);
        Assert.assertFalse((boolean)globalServiceContainer.isEmpty());
        Assert.assertEquals((long)2L, (long)globalServiceContainer.numberOfServicesWithGloballyUniqueNames());
        Assert.assertEquals((long)1L, (long)globalServiceContainer.numberOfServicesWithDuplicateNames());
        Assert.assertTrue((boolean)globalServiceContainer.isServiceNameInUseGlobally("odap"));
        Assert.assertTrue((boolean)globalServiceContainer.isServiceNameInUseGlobally("wms"));
        Assert.assertFalse((boolean)globalServiceContainer.isServiceNameInUseGlobally("wcs"));
        Assert.assertEquals((Object)odapService, (Object)globalServiceContainer.getServiceByGloballyUniqueName("odap"));
        Assert.assertEquals((Object)wmsService, (Object)globalServiceContainer.getServiceByGloballyUniqueName("wms"));
        Assert.assertNull((Object)globalServiceContainer.getServiceByGloballyUniqueName("wcs"));
        Assert.assertTrue((boolean)globalServiceContainer.removeService(wmsService));
        Assert.assertEquals((Object)wcsService, (Object)globalServiceContainer.getServiceByGloballyUniqueName("wms"));
        Assert.assertEquals((long)2L, (long)globalServiceContainer.numberOfServicesWithGloballyUniqueNames());
        Assert.assertEquals((long)0L, (long)globalServiceContainer.numberOfServicesWithDuplicateNames());
        Assert.assertTrue((boolean)globalServiceContainer.removeService(odapService));
        Assert.assertFalse((boolean)globalServiceContainer.isServiceNameInUseGlobally("odap"));
        Assert.assertNull((Object)globalServiceContainer.getServiceByGloballyUniqueName("odap"));
        Assert.assertEquals((long)1L, (long)globalServiceContainer.numberOfServicesWithGloballyUniqueNames());
        Assert.assertEquals((long)0L, (long)globalServiceContainer.numberOfServicesWithDuplicateNames());
    }
}

