/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.parser.jdom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.XMLEntityResolver;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import thredds.crawlabledataset.CrawlableDatasetFilter;

public class TestDatasetScanFilter
extends TestCase {
    public TestDatasetScanFilter(String name) {
        super(name);
    }

    public void testFilterReadWriteMatch() {
        Document inDoc;
        StringBuffer inFilterAsString = new StringBuffer().append("<filter xmlns=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\">\n").append("  <include wildcard=\"*.nc\" atomic=\"true\" collection=\"false\" />\n").append("  <exclude wildcard=\"*.nc1\" atomic=\"true\" collection=\"false\" />\n").append("  <include regExp=\"data\" atomic=\"false\" collection=\"true\" />\n").append("  <exclude regExp=\"CVS\" atomic=\"false\" collection=\"true\" />\n").append("</filter>");
        XMLEntityResolver resolver = new XMLEntityResolver(false);
        SAXBuilder builder = resolver.getSAXBuilder();
        try {
            inDoc = builder.build((Reader)new StringReader(inFilterAsString.toString()));
        }
        catch (IOException e) {
            TestDatasetScanFilter.fail((String)("I/O error reading XML document: " + e.getMessage()));
            return;
        }
        catch (JDOMException e) {
            TestDatasetScanFilter.fail((String)("Problem parsing XML document: " + e.getMessage()));
            return;
        }
        Element inFilterElem = inDoc.getRootElement();
        InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory((boolean)false);
        InvCatalogFactory10 factory = (InvCatalogFactory10)fac.getCatalogConverter("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
        CrawlableDatasetFilter inFilter = factory.readDatasetScanFilter(inFilterElem);
        Element outFilterElem = factory.writeDatasetScanFilter(inFilter);
        ByteArrayOutputStream inBaos = new ByteArrayOutputStream();
        ByteArrayOutputStream outBaos = new ByteArrayOutputStream();
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        try {
            fmt.output(inFilterElem, (OutputStream)inBaos);
            fmt.output(outFilterElem, (OutputStream)outBaos);
        }
        catch (IOException e) {
            TestDatasetScanFilter.fail((String)("Failed to write JDOM Elements to byte array: " + e.getMessage()));
        }
        String inFilterResultString = inBaos.toString();
        String outFilterResultString = outBaos.toString();
        TestDatasetScanFilter.assertTrue((String)("Read then write results not as expected.\nInput:\n" + inFilterResultString + "\nOutput:\n" + outFilterResultString), (boolean)inFilterResultString.equals(outFilterResultString));
    }
}

