/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import junit.framework.TestCase;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.TestCatalogAll;
import thredds.catalog.ThreddsMetadata;

public class TestWrite
extends TestCase {
    static boolean debugCompare = true;
    static boolean debugCompareList = true;

    public TestWrite(String name) {
        super(name);
    }

    public void testWrite() {
        this.testWrite("test1.xml");
    }

    public void testWrite(String filename) {
        String fileOutName;
        InvCatalogImpl cat;
        block4: {
            cat = TestCatalogAll.open(filename, true);
            fileOutName = TestCatalogAll.dataDir + filename + ".tmp";
            System.out.println(" output filename= " + fileOutName);
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileOutName));
                cat.writeXML((OutputStream)out);
                ((OutputStream)out).close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        String urlR = "file:/" + fileOutName;
        InvCatalogImpl catR = TestCatalogAll.openAbsolute(urlR, true);
        if (!cat.equals((Object)catR)) {
            System.out.println("cat = " + cat.hashCode() + " catR= " + catR.hashCode() + " not equals");
            this.compare(cat, catR);
        }
        this.compare(cat, catR);
        assert (cat.equals((Object)catR));
    }

    public void compare(InvCatalogImpl cat, InvCatalogImpl catR) {
        List datasets = cat.getDatasets();
        List datasetsR = catR.getDatasets();
        for (int i = 0; i < datasets.size(); ++i) {
            InvDatasetImpl dd = (InvDatasetImpl)datasets.get(i);
            this.compareDatasets(dd, (InvDatasetImpl)datasetsR.get(i));
        }
    }

    public void compareDatasets(InvDatasetImpl d, InvDatasetImpl dR) {
        if (debugCompare) {
            System.out.println(" compare datasets (" + d + ") and (" + dR + ")");
        }
        this.compareList(d.getMetadata(), dR.getMetadata());
        List datasets = d.getDatasets();
        List datasetsR = dR.getDatasets();
        for (int i = 0; i < datasets.size(); ++i) {
            InvDatasetImpl dd = (InvDatasetImpl)datasets.get(i);
            InvDatasetImpl ddR = (InvDatasetImpl)datasetsR.get(i);
            this.compareDatasets(dd, ddR);
        }
        assert (d.equals((Object)dR)) : "**(" + d.getID() + ") not equal (" + dR.getID() + ")";
    }

    public void compareList(List d, List dR) {
        int index;
        for (Object item : d) {
            index = dR.indexOf(item);
            if (index < 0) {
                System.out.println("   cant find " + item.getClass().getName() + " " + item + " in output ");
                continue;
            }
            if (!debugCompareList) continue;
            System.out.println("   item ok = (" + item + ")");
        }
        for (Object item : dR) {
            index = d.indexOf(item);
            if (index < 0) {
                System.out.println("   cant find " + item.getClass().getName() + " " + item + " in input ");
                continue;
            }
            if (!debugCompareList) continue;
            System.out.println("   itemR ok = (" + item + ")");
        }
    }

    public void compareListVariables(List d, List dR) {
        int index;
        for (ThreddsMetadata.Variables item : d) {
            index = dR.indexOf(item);
            if (index < 0) {
                System.out.println("   cant find " + item.getClass().getName() + " " + item + " in output ");
                continue;
            }
            if (!debugCompareList) continue;
            ThreddsMetadata.Variables item2 = (ThreddsMetadata.Variables)dR.get(index);
            System.out.println("   Variables ok = (" + item + ") == (" + item2 + ")");
        }
        for (ThreddsMetadata.Variables item : dR) {
            index = d.indexOf(item);
            if (index >= 0) continue;
            System.out.println("   cant find " + item.getClass().getName() + " " + item + " in input ");
        }
    }

    public void check(String url) {
        InvCatalogImpl cat = TestCatalogAll.open(url, true);
        String urlR = url + ".out.xml";
        InvCatalogImpl catR = TestCatalogAll.open(urlR, true);
        boolean e = cat.equals((Object)catR);
        System.out.println("cat = " + cat.hashCode() + " catR= " + catR.hashCode() + " equals = " + e);
        assert (cat.equals((Object)catR));
    }

    public static void main(String[] args) {
        TestWrite t = new TestWrite("dummy");
        t.testWrite("testCatgenOrg.xml");
    }
}

