/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.OutputStream;
import java.util.Date;
import junit.framework.TestCase;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.TestCatalogAll;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.units.TimeUnit;

public class TestTimeCoverage
extends TestCase {
    private static boolean showValidation = false;
    String urlString = "TestTimeCoverage.xml";

    public TestTimeCoverage(String name) {
        super(name);
    }

    public void testXTC() throws Exception {
        InvCatalogImpl cat = TestCatalogAll.open(this.urlString, true);
        StringBuilder buff = new StringBuilder();
        boolean isValid = cat.check(buff, false);
        System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
        System.out.println(" validation output=\n" + buff);
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)false);
        catFactory.writeXML(cat, (OutputStream)System.out);
        InvDataset ds = cat.findDatasetByID("test1");
        DateRange tc = ds.getTimeCoverage();
        assert (null != tc);
        System.out.println(" tc = " + tc);
        assert (tc.getEnd().isPresent());
        assert (tc.getResolution() == null);
        assert (tc.getDuration().equals((Object)new TimeDuration("14 days")));
        ds = cat.findDatasetByID("test2");
        tc = ds.getTimeCoverage();
        assert (null != tc);
        System.out.println(" tc = " + tc);
        Date got = tc.getStart().getDate();
        Date want = new DateFormatter().getISODate("1999-11-16T12:00:00");
        assert (got.equals(want));
        assert (tc.getResolution() == null);
        TimeDuration gott = tc.getDuration();
        TimeDuration wantt = new TimeDuration("P3M");
        assert (gott.equals((Object)wantt));
        ds = cat.findDatasetByID("test3");
        tc = ds.getTimeCoverage();
        assert (null != tc);
        System.out.println(" tc = " + tc);
        assert (tc.getResolution() == null);
        assert (tc.getDuration().equals((Object)new TimeDuration("2 days")));
        ds = cat.findDatasetByID("test4");
        tc = ds.getTimeCoverage();
        assert (null != tc);
        System.out.println(" tc = " + tc);
        TimeDuration r = tc.getResolution();
        assert (r != null);
        TimeDuration r2 = new TimeDuration("3 hour");
        assert (r.equals((Object)r2));
        TimeDuration d = tc.getDuration();
        TimeUnit tu = d.getTimeUnit();
        assert (tu.getUnitString().equals("days")) : tu.getUnitString();
    }
}

