/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import thredds.catalog.DatasetScanExpandSubdirsTest;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.TestAliasID;
import thredds.catalog.TestCatalogReference;
import thredds.catalog.TestInherit1;
import thredds.catalog.TestMetadata;
import thredds.catalog.TestRead;
import thredds.catalog.TestResolve1;
import thredds.catalog.TestSpatialCoverage;
import thredds.catalog.TestSubset;
import thredds.catalog.TestTimeCoverage;
import thredds.catalog.TestURL;
import thredds.catalog.TestVariables;
import thredds.catalog.parser.jdom.TestDatasetScanFilter;
import thredds.catalog.parser.jdom.TestReadMetadata;
import ucar.nc2.TestAll;

public class TestCatalogAll
extends TestCase {
    public static String tmpDir = TestAll.temporaryLocalDataDir;
    public static String dataDir = TestAll.cdmLocalTestDataDir + "thredds/catalog/";
    private static boolean showValidation = false;
    static boolean debug = true;
    static boolean showValidationMessages = true;

    public static String makeFilepath(String catalogName) {
        return TestCatalogAll.makeFilepath() + catalogName;
    }

    public static String makeFilepath() {
        return "file:" + dataDir;
    }

    public static InvCatalogImpl open(String catalogName, boolean validate) {
        catalogName = TestCatalogAll.makeFilepath(catalogName);
        System.out.println("\nTestAll open= " + catalogName);
        StringBuilder buff = new StringBuilder();
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)validate);
        try {
            InvCatalogImpl cat = catFactory.readXML(catalogName);
            boolean isValid = cat.check(buff, showValidation);
            if (!isValid) {
                System.out.println("Validate failed " + catalogName + " = \n<" + buff.toString() + ">");
            } else if (showValidationMessages) {
                System.out.println("Validate ok " + catalogName + " = \n<" + buff.toString() + ">");
            }
            return cat;
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCatalogAll.assertTrue((boolean)false);
            return null;
        }
    }

    public static InvCatalogImpl openAbsolute(String catalogName, boolean validate) {
        System.out.println("\nTestAll openAbsolute= " + catalogName);
        StringBuilder buff = new StringBuilder();
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)validate);
        try {
            InvCatalogImpl cat = catFactory.readXML(catalogName);
            boolean isValid = cat.check(buff, showValidation);
            if (!isValid) {
                System.out.println("Validate failed " + catalogName + " = \n<" + buff.toString() + ">");
            } else if (showValidationMessages) {
                System.out.println("Validate ok " + catalogName + " = \n<" + buff.toString() + ">");
            }
            return cat;
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCatalogAll.assertTrue((boolean)false);
            return null;
        }
    }

    public static Test suite() {
        String dd = System.getProperty("test.data.dir");
        if (dd != null) {
            dataDir = dd;
        }
        System.out.println("TestAllDqc data directory= " + dataDir);
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestSuite(TestURL.class));
        suite.addTest((Test)new TestSuite(TestRead.class));
        suite.addTest((Test)new TestSuite(TestAliasID.class));
        suite.addTest((Test)new TestSuite(TestInherit1.class));
        suite.addTest((Test)new TestSuite(TestResolve1.class));
        suite.addTest((Test)new TestSuite(TestMetadata.class));
        suite.addTest((Test)new TestSuite(TestSubset.class));
        suite.addTest((Test)new TestSuite(TestCatalogReference.class));
        suite.addTest((Test)new TestSuite(TestVariables.class));
        suite.addTest((Test)new TestSuite(TestSpatialCoverage.class));
        suite.addTest((Test)new TestSuite(TestTimeCoverage.class));
        suite.addTest((Test)new JUnit4TestAdapter(DatasetScanExpandSubdirsTest.class));
        suite.addTestSuite(TestDatasetScanFilter.class);
        suite.addTestSuite(TestReadMetadata.class);
        return suite;
    }
}

