/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class Pres_temp_4D_wr {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int NLVL = 2;
        int NLAT = 6;
        int NLON = 12;
        int NREC = 2;
        float SAMPLE_PRESSURE = 900.0f;
        float SAMPLE_TEMP = 9.0f;
        float START_LAT = 25.0f;
        float START_LON = -125.0f;
        String filename = "pres_temp_4D.nc";
        NetcdfFileWriteable dataFile = null;
        try {
            int i;
            dataFile = NetcdfFileWriteable.createNew((String)filename, (boolean)false);
            Dimension lvlDim = dataFile.addDimension("level", 2);
            Dimension latDim = dataFile.addDimension("latitude", 6);
            Dimension lonDim = dataFile.addDimension("longitude", 12);
            Dimension timeDim = dataFile.addUnlimitedDimension("time");
            ArrayList<Dimension> dims = null;
            dataFile.addVariable("latitude", DataType.FLOAT, new Dimension[]{latDim});
            dataFile.addVariable("longitude", DataType.FLOAT, new Dimension[]{lonDim});
            dataFile.addVariableAttribute("latitude", "units", "degrees_north");
            dataFile.addVariableAttribute("longitude", "units", "degrees_east");
            dims = new ArrayList<Dimension>();
            dims.add(timeDim);
            dims.add(lvlDim);
            dims.add(latDim);
            dims.add(lonDim);
            dataFile.addVariable("pressure", DataType.FLOAT, dims);
            dataFile.addVariable("temperature", DataType.FLOAT, dims);
            dataFile.addVariableAttribute("pressure", "units", "hPa");
            dataFile.addVariableAttribute("temperature", "units", "celsius");
            ArrayFloat.D1 lats = new ArrayFloat.D1(latDim.getLength());
            ArrayFloat.D1 lons = new ArrayFloat.D1(lonDim.getLength());
            for (i = 0; i < latDim.getLength(); ++i) {
                lats.set(i, 25.0f + 5.0f * (float)i);
            }
            for (int j = 0; j < lonDim.getLength(); ++j) {
                lons.set(j, -125.0f + 5.0f * (float)j);
            }
            ArrayFloat.D4 dataTemp = new ArrayFloat.D4(2, lvlDim.getLength(), latDim.getLength(), lonDim.getLength());
            ArrayFloat.D4 dataPres = new ArrayFloat.D4(2, lvlDim.getLength(), latDim.getLength(), lonDim.getLength());
            for (int record = 0; record < 2; ++record) {
                i = 0;
                for (int lvl = 0; lvl < 2; ++lvl) {
                    for (int lat = 0; lat < 6; ++lat) {
                        for (int lon = 0; lon < 12; ++lon) {
                            dataPres.set(record, lvl, lat, lon, 900.0f + (float)i);
                            dataTemp.set(record, lvl, lat, lon, 9.0f + (float)i++);
                        }
                    }
                }
            }
            dataFile.create();
            int[] origin = new int[4];
            dataFile.write("latitude", (Array)lats);
            dataFile.write("longitude", (Array)lons);
            dataFile.write("pressure", origin, (Array)dataPres);
            dataFile.write("temperature", origin, (Array)dataTemp);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace(System.err);
        }
        finally {
            if (dataFile != null) {
                try {
                    dataFile.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        System.out.println("*** SUCCESS writing example file " + filename);
    }
}

