/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.IOException;
import ucar.ma2.ArrayFloat;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class Pres_temp_4D_rd {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int NLVL = 2;
        int NLAT = 6;
        int NLON = 12;
        float SAMPLE_PRESSURE = 900.0f;
        float SAMPLE_TEMP = 9.0f;
        float START_LAT = 25.0f;
        float START_LON = -125.0f;
        String filename = "pres_temp_4D.nc";
        NetcdfFile dataFile = null;
        try {
            dataFile = NetcdfFile.open((String)filename, null);
            Variable latVar = dataFile.findVariable("latitude");
            if (latVar == null) {
                System.out.println("Cant find Variable latitude");
                return;
            }
            Variable lonVar = dataFile.findVariable("longitude");
            if (lonVar == null) {
                System.out.println("Cant find Variable longitude");
                return;
            }
            ArrayFloat.D1 latArray = (ArrayFloat.D1)latVar.read();
            ArrayFloat.D1 lonArray = (ArrayFloat.D1)lonVar.read();
            for (int lat = 0; lat < 6; ++lat) {
                if ((double)latArray.get(lat) == 25.0 + 5.0 * (double)lat) continue;
                System.err.println("ERROR incorrect value in variable latitude");
            }
            for (int lon = 0; lon < 12; ++lon) {
                if ((double)lonArray.get(lon) == -125.0 + 5.0 * (double)lon) continue;
                System.err.println("ERROR incorrect value in variable longtitude");
            }
            Variable presVar = dataFile.findVariable("pressure");
            if (presVar == null) {
                System.out.println("Cant find Variable pressure");
                return;
            }
            Variable tempVar = dataFile.findVariable("temperature");
            if (lonVar == null) {
                System.out.println("Cant find Variable temperature");
                return;
            }
            int[] shape = presVar.getShape();
            int recLen = shape[0];
            int[] origin = new int[4];
            shape[0] = 1;
            for (int rec = 0; rec < recLen; ++rec) {
                origin[0] = rec;
                ArrayFloat.D3 presArray = (ArrayFloat.D3)presVar.read(origin, shape).reduce();
                ArrayFloat.D3 tempArray = (ArrayFloat.D3)tempVar.read(origin, shape).reduce();
                int count = 0;
                for (int lvl = 0; lvl < 2; ++lvl) {
                    for (int lat = 0; lat < 6; ++lat) {
                        for (int lon = 0; lon < 12; ++lon) {
                            if (presArray.get(lvl, lat, lon) != 900.0f + (float)count || tempArray.get(lvl, lat, lon) != 9.0f + (float)count) {
                                System.err.println("ERROR incorrect value in variable pressure or temperature");
                            }
                            ++count;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (dataFile != null) {
                try {
                    dataFile.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        System.out.println("*** SUCCESS reading example file " + filename);
    }
}

