/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.wms;

import gov.nasa.worldwind.wms.BoundingBox;
import gov.nasa.worldwind.wms.Capabilities;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CapabilitiesV111
extends Capabilities {
    public CapabilitiesV111(Document document, XPath xPath) {
        super(document, xPath);
    }

    @Override
    public BoundingBox getLayerGeographicBoundingBox(Element element) {
        Element element2 = this.getElement(element, "ancestor-or-self::wms:Layer/wms:LatLonBoundingBox");
        return element2 == null ? null : BoundingBox.createFromStrings("CRS:84", this.getText(element2, "@wms:minx"), this.getText(element2, "@wms:maxx"), this.getText(element2, "@wms:miny"), this.getText(element2, "@wms:maxy"), null, null);
    }

    @Override
    public BoundingBox[] getLayerBoundingBoxes(Element element) {
        Element[] elementArray = this.getElements(element, "ancestor-or-self::wms:Layer/wms:BoundingBox");
        if (elementArray == null) {
            return null;
        }
        ArrayList<BoundingBox> arrayList = new ArrayList<BoundingBox>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Element element2 : elementArray) {
            BoundingBox boundingBox;
            if (element2 == null || (boundingBox = BoundingBox.createFromStrings(this.getBoundingBoxSRS(element2), this.getBoundingBoxMinx(element2), this.getBoundingBoxMaxx(element2), this.getBoundingBoxMiny(element2), this.getBoundingBoxMaxy(element2), this.getBoundingBoxResx(element2), this.getBoundingBoxResy(element2))) == null || boundingBox.getCrs() == null || arrayList2.contains(boundingBox.getCrs())) continue;
            arrayList2.add(boundingBox.getCrs());
            arrayList.add(boundingBox);
        }
        return arrayList.size() > 0 ? arrayList.toArray(new BoundingBox[arrayList.size()]) : null;
    }

    @Override
    public String getLayerMaxScaleDenominator(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/wms:ScaleHint/@wms:max");
    }

    @Override
    public String getLayerMinScaleDenominator(Element element) {
        return this.getText(element, "ancestor-or-self::wms:Layer/wms:ScaleHint/@wms:min");
    }
}

