/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.TileKey;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;

public class Tile
implements Comparable<Tile>,
Cacheable {
    private final Sector sector;
    private final Level level;
    private final int row;
    private final int column;
    private final String cacheName;
    private final TileKey tileKey;
    private double priority = Double.MAX_VALUE;
    private String path;

    public Tile(Sector sector, Level level, int n, int n2) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (level == null) {
            String string = Logging.getMessage("nullValue.LevelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.level = level;
        this.row = n;
        this.column = n2;
        this.cacheName = null;
        this.tileKey = new TileKey(this);
        this.path = null;
    }

    public Tile(Sector sector, Level level, int n, int n2, String string) {
        if (sector == null) {
            String string2 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (level == null) {
            String string3 = Logging.getMessage("nullValue.LevelIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.sector = sector;
        this.level = level;
        this.row = n;
        this.column = n2;
        this.cacheName = string;
        this.tileKey = new TileKey(this);
        this.path = null;
    }

    public Tile(Sector sector, Level level) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (level == null) {
            String string = Logging.getMessage("nullValue.LevelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.level = level;
        this.row = Tile.computeRow(sector.getDeltaLat(), sector.getMinLatitude(), Angle.NEG90);
        this.column = Tile.computeColumn(sector.getDeltaLon(), sector.getMinLongitude(), Angle.NEG180);
        this.cacheName = null;
        this.tileKey = new TileKey(this);
        this.path = null;
    }

    public Tile(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Random random = new Random();
        this.sector = sector;
        this.level = null;
        this.row = random.nextInt();
        this.column = random.nextInt();
        this.cacheName = null;
        this.tileKey = new TileKey(this);
        this.path = null;
    }

    @Override
    public long getSizeInBytes() {
        long l = 0L;
        if (this.sector != null) {
            l += this.sector.getSizeInBytes();
        }
        if (this.path != null) {
            l += (long)this.getPath().length();
        }
        return l += 32L;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.level.getPath() + "/" + this.row + "/" + this.row + "_" + this.column;
            if (!this.level.isEmpty()) {
                this.path = this.path + this.level.getFormatSuffix();
            }
        }
        return this.path;
    }

    public String getPathBase() {
        String string = this.getPath();
        return string.contains(".") ? string.substring(0, string.lastIndexOf(".")) : string;
    }

    public final Sector getSector() {
        return this.sector;
    }

    public Level getLevel() {
        return this.level;
    }

    public final int getLevelNumber() {
        return this.level != null ? this.level.getLevelNumber() : 0;
    }

    public final String getLevelName() {
        return this.level != null ? this.level.getLevelName() : "";
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public final String getCacheName() {
        if (this.cacheName != null) {
            return this.cacheName;
        }
        return this.level != null ? this.level.getCacheName() : null;
    }

    public final String getFormatSuffix() {
        return this.level != null ? this.level.getFormatSuffix() : null;
    }

    public final TileKey getTileKey() {
        return this.tileKey;
    }

    public URL getResourceURL() throws MalformedURLException {
        return this.level != null ? this.level.getTileResourceURL(this, null) : null;
    }

    public URL getResourceURL(String string) throws MalformedURLException {
        return this.level != null ? this.level.getTileResourceURL(this, string) : null;
    }

    public String getLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLevelNumber());
        stringBuilder.append("(");
        stringBuilder.append(this.getLevelName());
        stringBuilder.append(")");
        stringBuilder.append(", ").append(this.getRow());
        stringBuilder.append(", ").append(this.getColumn());
        return stringBuilder.toString();
    }

    public int getWidth() {
        return this.getLevel().getTileWidth();
    }

    public int getHeight() {
        return this.getLevel().getTileHeight();
    }

    @Override
    public int compareTo(Tile tile) {
        if (tile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (tile.getLevelNumber() == this.getLevelNumber() && tile.row == this.row && tile.column == this.column) {
            return 0;
        }
        if (this.getLevelNumber() < tile.getLevelNumber()) {
            return -1;
        }
        if (this.getLevelNumber() > tile.getLevelNumber()) {
            return 1;
        }
        if (this.row < tile.row) {
            return -1;
        }
        if (this.row > tile.row) {
            return 1;
        }
        if (this.column < tile.column) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Tile tile = (Tile)object;
        return !(this.tileKey == null ? tile.tileKey != null : !this.tileKey.equals(tile.tileKey));
    }

    public int hashCode() {
        return this.tileKey != null ? this.tileKey.hashCode() : 0;
    }

    public String toString() {
        return this.getPath();
    }

    public static int computeRow(Angle angle, Angle angle2, Angle angle3) {
        if (angle == null || angle2 == null || angle3 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees <= 0.0) {
            String string = Logging.getMessage("generic.DeltaAngleOutOfRange", angle);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2.degrees < -90.0 || angle2.degrees > 90.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange", angle2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = (int)((angle2.degrees - angle3.degrees) / angle.degrees);
        if (angle2.degrees - angle3.degrees == 180.0) {
            --n;
        }
        return n;
    }

    public static int computeColumn(Angle angle, Angle angle2, Angle angle3) {
        if (angle == null || angle2 == null || angle3 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees <= 0.0) {
            String string = Logging.getMessage("generic.DeltaAngleOutOfRange", angle);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2.degrees < -180.0 || angle2.degrees > 180.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange", angle2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle2.degrees - angle3.degrees;
        if (d < 0.0) {
            d = 360.0 + d;
        }
        int n = (int)(d / angle.degrees);
        if (angle2.degrees - angle3.degrees == 360.0) {
            --n;
        }
        return n;
    }

    public static Angle computeRowLatitude(int n, Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.RowIndexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees <= 0.0) {
            String string = Logging.getMessage("generic.DeltaAngleOutOfRange", angle);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle2.degrees + (double)n * angle.degrees;
        return Angle.fromDegrees(d);
    }

    public static Angle computeColumnLongitude(int n, Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.ColumnIndexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees <= 0.0) {
            String string = Logging.getMessage("generic.DeltaAngleOutOfRange", angle);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle2.degrees + (double)n * angle.degrees;
        return Angle.fromDegrees(d);
    }

    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double d) {
        this.priority = d;
    }
}

