/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology;

import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.symbology.TacticalGraphicAttributes;
import gov.nasa.worldwind.util.Logging;
import java.awt.Font;

public class BasicTacticalGraphicAttributes
implements TacticalGraphicAttributes {
    protected Double scale;
    protected Material interiorMaterial;
    protected Material outlineMaterial;
    protected Double interiorOpacity;
    protected Double outlineOpacity;
    protected double outlineWidth;
    protected Font font;
    protected Material textMaterial;

    public BasicTacticalGraphicAttributes() {
    }

    public BasicTacticalGraphicAttributes(TacticalGraphicAttributes tacticalGraphicAttributes) {
        if (tacticalGraphicAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.scale = tacticalGraphicAttributes.getScale();
        this.font = tacticalGraphicAttributes.getTextModifierFont();
        this.textMaterial = tacticalGraphicAttributes.getTextModifierMaterial();
        this.interiorMaterial = tacticalGraphicAttributes.getInteriorMaterial();
        this.outlineMaterial = tacticalGraphicAttributes.getOutlineMaterial();
        this.interiorOpacity = tacticalGraphicAttributes.getInteriorOpacity();
        this.outlineOpacity = tacticalGraphicAttributes.getOutlineOpacity();
        this.outlineWidth = tacticalGraphicAttributes.getOutlineWidth();
    }

    @Override
    public TacticalGraphicAttributes copy() {
        return new BasicTacticalGraphicAttributes(this);
    }

    @Override
    public void copy(TacticalGraphicAttributes tacticalGraphicAttributes) {
        if (tacticalGraphicAttributes != null) {
            this.scale = tacticalGraphicAttributes.getScale();
            this.font = tacticalGraphicAttributes.getTextModifierFont();
            this.textMaterial = tacticalGraphicAttributes.getTextModifierMaterial();
            this.interiorMaterial = tacticalGraphicAttributes.getInteriorMaterial();
            this.outlineMaterial = tacticalGraphicAttributes.getOutlineMaterial();
            this.interiorOpacity = tacticalGraphicAttributes.getInteriorOpacity();
            this.outlineOpacity = tacticalGraphicAttributes.getOutlineOpacity();
            this.outlineWidth = tacticalGraphicAttributes.getOutlineWidth();
        }
    }

    @Override
    public Double getScale() {
        return this.scale;
    }

    @Override
    public void setScale(Double d) {
        if (d != null && d < 0.0) {
            String string = Logging.getMessage("generic.ScaleOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.scale = d;
    }

    @Override
    public Font getTextModifierFont() {
        return this.font;
    }

    @Override
    public void setTextModifierFont(Font font) {
        this.font = font;
    }

    @Override
    public Material getTextModifierMaterial() {
        return this.textMaterial;
    }

    @Override
    public void setTextModifierMaterial(Material material) {
        this.textMaterial = material;
    }

    @Override
    public Material getInteriorMaterial() {
        return this.interiorMaterial;
    }

    @Override
    public void setInteriorMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorMaterial = material;
    }

    @Override
    public Material getOutlineMaterial() {
        return this.outlineMaterial;
    }

    @Override
    public void setOutlineMaterial(Material material) {
        this.outlineMaterial = material;
    }

    @Override
    public Double getInteriorOpacity() {
        return this.interiorOpacity;
    }

    @Override
    public void setInteriorOpacity(Double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorOpacity = d;
    }

    @Override
    public Double getOutlineOpacity() {
        return this.outlineOpacity;
    }

    @Override
    public void setOutlineOpacity(Double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineOpacity = d;
    }

    @Override
    public Double getOutlineWidth() {
        return this.outlineWidth;
    }

    @Override
    public void setOutlineWidth(Double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.WidthIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineWidth = d;
    }
}

