/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.retrieve;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.RasterServer;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class LocalRasterServerRetriever
extends WWObjectImpl
implements Retriever {
    protected RetrievalPostProcessor postProcessor;
    protected RasterServer server = null;
    protected volatile String state = "gov.nasa.worldwind.RetrieverStatusNotStarted";
    protected volatile int contentLength = 0;
    protected AtomicInteger contentLengthRead = new AtomicInteger(0);
    protected ByteBuffer byteBuffer;
    protected int staleRequestLimit = -1;
    protected long submitTime;
    protected long beginTime;
    protected long endTime;

    public LocalRasterServerRetriever(AVList aVList, RasterServer rasterServer, RetrievalPostProcessor retrievalPostProcessor) {
        if (null != aVList) {
            this.setValues(aVList);
        }
        this.server = rasterServer;
        this.postProcessor = retrievalPostProcessor;
    }

    public RasterServer getServer() {
        return this.server;
    }

    public void setServer(RasterServer rasterServer) {
        this.server = rasterServer;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.byteBuffer;
    }

    @Override
    public int getContentLength() {
        return this.contentLength;
    }

    @Override
    public int getContentLengthRead() {
        return this.contentLengthRead.get();
    }

    @Override
    public String getName() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        return WWUtil.isEmpty(object) ? null : (String)object;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getContentType() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.ImageFormat");
        return WWUtil.isEmpty(object) ? null : (String)object;
    }

    @Override
    public long getExpirationTime() {
        return 0L;
    }

    @Override
    public long getSubmitTime() {
        return this.submitTime;
    }

    @Override
    public void setSubmitTime(long l) {
        this.submitTime = l;
    }

    @Override
    public long getBeginTime() {
        return this.beginTime;
    }

    @Override
    public void setBeginTime(long l) {
        this.beginTime = l;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(long l) {
        this.endTime = l;
    }

    @Override
    public int getConnectTimeout() {
        return 0;
    }

    @Override
    public int getReadTimeout() {
        return 0;
    }

    @Override
    public void setReadTimeout(int n) {
    }

    @Override
    public void setConnectTimeout(int n) {
    }

    @Override
    public int getStaleRequestLimit() {
        return this.staleRequestLimit;
    }

    @Override
    public void setStaleRequestLimit(int n) {
        this.staleRequestLimit = n;
    }

    @Override
    public Retriever call() throws Exception {
        try {
            this.setState("gov.nasa.worldwind.RetrieverStatusStarted");
            if (null == this.server) {
                this.setState("gov.nasa.worldwind.RetrieverStatusError");
                String string = Logging.getMessage("nullValue.RasterServerIsNull");
                Logging.logger().severe(string);
                throw new WWRuntimeException(string);
            }
            this.byteBuffer = this.server.getRasterAsByteBuffer(this.copy());
            if (null != this.byteBuffer) {
                this.setState("gov.nasa.worldwind.RetrieverStatusSuccessful");
                this.contentLength = this.byteBuffer.capacity();
                this.contentLengthRead.set(this.contentLength);
            } else {
                this.setState("gov.nasa.worldwind.RetrieverStatusError");
            }
            if (this.postProcessor != null) {
                this.byteBuffer = this.postProcessor.run(this);
            }
        }
        catch (Exception exception) {
            this.setState("gov.nasa.worldwind.RetrieverStatusError");
            Logging.logger().log(Level.SEVERE, Logging.getMessage("Retriever.ErrorPostProcessing", this.getName()), exception);
            throw exception;
        }
        return this;
    }

    protected void setState(String string) {
        String string2 = this.state;
        this.state = string;
        this.firePropertyChange("gov.nasa.worldwind.avkey.RetrieverState", string2, this.state);
    }
}

