/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.AirspaceRenderer;
import gov.nasa.worldwind.render.airspaces.Box;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TrackAirspace
extends AbstractAirspace {
    protected List<Box> legs = new ArrayList<Box>();
    protected boolean enableInnerCaps = true;
    protected Angle smallAngleThreshold = Angle.fromDegrees(22.5);

    public TrackAirspace(Collection<Box> collection) {
        this.addLegs(collection);
    }

    public TrackAirspace(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
    }

    public TrackAirspace() {
    }

    public List<Box> getLegs() {
        return Collections.unmodifiableList(this.legs);
    }

    public void setLegs(Collection<Box> collection) {
        this.legs.clear();
        this.addLegs(collection);
    }

    protected void addLegs(Iterable<Box> iterable) {
        if (iterable != null) {
            for (Box box : iterable) {
                if (box == null) continue;
                this.addLeg(box);
            }
            this.setLegsOutOfDate();
        }
    }

    public Box addLeg(LatLon latLon, LatLon latLon2, double d, double d2, double d3, double d4) {
        if (latLon == null) {
            String string = "nullValue.StartIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon2 == null) {
            String string = "nullValue.EndIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        boolean[] blArray = this.isTerrainConforming();
        Box box = new Box();
        box.setAltitudes(d, d2);
        box.setTerrainConforming(blArray[0], blArray[1]);
        box.setLocations(latLon, latLon2);
        box.setWidths(d3, d4);
        this.addLeg(box);
        return box;
    }

    protected void addLeg(Box box) {
        if (box == null) {
            String string = "nullValue.LegIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        box.setForceCullFace(true);
        this.legs.add(box);
        this.setExtentOutOfDate();
        this.setLegsOutOfDate();
    }

    public void removeAllLegs() {
        this.legs.clear();
    }

    public boolean isEnableInnerCaps() {
        return this.enableInnerCaps;
    }

    public void setEnableInnerCaps(boolean bl) {
        this.enableInnerCaps = bl;
        this.setLegsOutOfDate();
    }

    public Angle getSmallAngleThreshold() {
        return this.smallAngleThreshold;
    }

    public void setSmallAngleThreshold(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.smallAngleThreshold = angle;
    }

    @Override
    public void setAltitudes(double d, double d2) {
        super.setAltitudes(d, d2);
        for (Box box : this.legs) {
            box.setAltitudes(d, d2);
        }
        this.setLegsOutOfDate();
    }

    @Override
    public void setTerrainConforming(boolean bl, boolean bl2) {
        super.setTerrainConforming(bl, bl2);
        for (Box box : this.legs) {
            box.setTerrainConforming(bl, bl2);
        }
        this.setLegsOutOfDate();
    }

    @Override
    public boolean isAirspaceVisible(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!super.isAirspaceVisible(drawContext)) {
            return false;
        }
        boolean bl = false;
        for (Box box : this.legs) {
            if (!box.isAirspaceVisible(drawContext)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public Position getReferencePosition() {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(2 * this.legs.size());
        for (Box box : this.legs) {
            LatLon[] latLonArray = box.getLocations();
            arrayList.add(latLonArray[0]);
            arrayList.add(latLonArray[1]);
        }
        return this.computeReferencePosition(arrayList, this.getAltitudes());
    }

    @Override
    protected Extent computeExtent(DrawContext drawContext) {
        if (this.isLegsOutOfDate(drawContext)) {
            this.doUpdateLegs(drawContext);
        }
        return super.computeExtent(drawContext);
    }

    @Override
    protected Extent computeExtent(Globe globe, double d) {
        List<Box> list = this.getLegs();
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 0) {
            return list.get(0).computeExtent(globe, d);
        }
        ArrayList<gov.nasa.worldwind.geom.Box> arrayList = new ArrayList<gov.nasa.worldwind.geom.Box>();
        for (Box box : list) {
            arrayList.add(box.computeExtent(globe, d));
        }
        return gov.nasa.worldwind.geom.Box.union(arrayList);
    }

    @Override
    protected List<Vec4> computeMinimalGeometry(Globe globe, double d) {
        return null;
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Box box : this.legs) {
            box.doMoveTo(position, position2);
        }
        this.setExtentOutOfDate();
        this.setLegsOutOfDate();
    }

    protected boolean isLegsOutOfDate(DrawContext drawContext) {
        for (Box box : this.legs) {
            if (box.isVerticesValid(drawContext.getGlobe())) continue;
            return true;
        }
        return false;
    }

    protected void setLegsOutOfDate() {
        for (Box box : this.legs) {
            box.clearVertices();
        }
    }

    protected void doUpdateLegs(DrawContext drawContext) {
        Object object;
        Globe globe = drawContext.getGlobe();
        double d = drawContext.getVerticalExaggeration();
        for (Box box : this.legs) {
            if (box == null) continue;
            box.setEnableCaps(true);
            object = Box.computeStandardVertices(globe, d, box);
            if (object == null || ((Vec4[])object).length != 8) continue;
            box.setVertices(globe, (Vec4[])object);
        }
        for (int i = 0; i < this.legs.size() - 1; ++i) {
            Box box;
            box = this.legs.get(i);
            object = this.legs.get(i + 1);
            if (box == null || object == null || !this.mustJoinLegs(box, (Box)object)) continue;
            this.joinLegs(globe, d, box, (Box)object);
        }
    }

    protected boolean mustJoinLegs(Box box, Box box2) {
        LatLon[] latLonArray = box.getLocations();
        LatLon[] latLonArray2 = box2.getLocations();
        double[] dArray = box.getAltitudes();
        double[] dArray2 = box2.getAltitudes();
        boolean[] blArray = box.isTerrainConforming();
        boolean[] blArray2 = box2.isTerrainConforming();
        if (!latLonArray[1].equals(latLonArray2[0])) {
            return false;
        }
        if (dArray[0] != dArray2[0] || dArray[1] != dArray2[1]) {
            return false;
        }
        return blArray[0] == blArray2[0] && blArray[1] == blArray2[1];
    }

    protected void joinLegs(Globe globe, double d, Box box, Box box2) {
        Vec4[] vec4Array = box.getVertices(globe);
        Vec4[] vec4Array2 = box2.getVertices(globe);
        Plane plane = this.computeBisectingPlane(globe, box, box2);
        if (plane.intersect(vec4Array[0], vec4Array[1]) != null || plane.intersect(vec4Array2[4], vec4Array2[5]) != null) {
            return;
        }
        if (this.isSmallAngle(globe, box, box2)) {
            Plane[] planeArray = Box.computeStandardPlanes(globe, d, box);
            Plane[] planeArray2 = Box.computeStandardPlanes(globe, d, box2);
            Line line = Line.fromSegment(vec4Array2[4], vec4Array2[0]);
            Line line2 = Line.fromSegment(vec4Array2[5], vec4Array2[1]);
            Line line3 = Line.fromSegment(vec4Array2[6], vec4Array2[2]);
            Line line4 = Line.fromSegment(vec4Array2[7], vec4Array2[3]);
            if (this.isRightTurn(globe, box, box2)) {
                Line line5 = Line.fromSegment(vec4Array[1], vec4Array[5]);
                Line line6 = Line.fromSegment(vec4Array[3], vec4Array[7]);
                vec4Array[5] = planeArray2[2].intersect(line5);
                vec4Array[7] = planeArray2[2].intersect(line6);
                vec4Array2[0] = planeArray[3].intersect(line);
                vec4Array2[1] = planeArray[3].intersect(line2);
                vec4Array2[2] = planeArray[3].intersect(line3);
                vec4Array2[3] = planeArray[3].intersect(line4);
            } else {
                Line line7 = Line.fromSegment(vec4Array[0], vec4Array[4]);
                Line line8 = Line.fromSegment(vec4Array[2], vec4Array[6]);
                vec4Array[4] = planeArray2[3].intersect(line7);
                vec4Array[6] = planeArray2[3].intersect(line8);
                vec4Array2[0] = planeArray[2].intersect(line);
                vec4Array2[1] = planeArray[2].intersect(line2);
                vec4Array2[2] = planeArray[2].intersect(line3);
                vec4Array2[3] = planeArray[2].intersect(line4);
            }
            box.setEnableEndCap(true);
            box2.setEnableStartCap(this.isEnableInnerCaps());
            box.setVertices(globe, vec4Array);
            box2.setVertices(globe, vec4Array2);
        } else {
            Line line = Line.fromSegment(vec4Array[0], vec4Array[4]);
            Line line9 = Line.fromSegment(vec4Array[1], vec4Array[5]);
            Line line10 = Line.fromSegment(vec4Array[2], vec4Array[6]);
            Line line11 = Line.fromSegment(vec4Array[3], vec4Array[7]);
            vec4Array[4] = plane.intersect(line);
            vec4Array[5] = plane.intersect(line9);
            vec4Array[6] = plane.intersect(line10);
            vec4Array[7] = plane.intersect(line11);
            line = Line.fromSegment(vec4Array2[4], vec4Array2[0]);
            line9 = Line.fromSegment(vec4Array2[5], vec4Array2[1]);
            line10 = Line.fromSegment(vec4Array2[6], vec4Array2[2]);
            line11 = Line.fromSegment(vec4Array2[7], vec4Array2[3]);
            vec4Array2[0] = plane.intersect(line);
            vec4Array2[1] = plane.intersect(line9);
            vec4Array2[2] = plane.intersect(line10);
            vec4Array2[3] = plane.intersect(line11);
            box.setEnableEndCap(this.isEnableInnerCaps());
            box2.setEnableStartCap(this.isEnableInnerCaps());
            box.setVertices(globe, vec4Array);
            box2.setVertices(globe, vec4Array2);
        }
    }

    protected Plane computeBisectingPlane(Globe globe, Box box, Box box2) {
        Vec4 vec4;
        Vec4 vec42;
        LatLon[] latLonArray = box.getLocations();
        LatLon[] latLonArray2 = box2.getLocations();
        double[] dArray = box.getAltitudes();
        double[] dArray2 = box2.getAltitudes();
        Vec4 vec43 = globe.computePointFromPosition(latLonArray[0], dArray[0]);
        Vec4 vec44 = globe.computePointFromPosition(latLonArray[1], dArray[0]);
        Vec4 vec45 = globe.computePointFromPosition(latLonArray2[1], dArray2[0]);
        Vec4 vec46 = vec43.subtract3(vec44).normalize3();
        Vec4 vec47 = vec46.add3(vec42 = vec45.subtract3(vec44).normalize3());
        if (vec47.getLength3() < 1.0E-7) {
            vec4 = vec46.normalize3();
        } else {
            Vec4 vec48 = globe.computeSurfaceNormalAtPoint(vec44);
            vec4 = vec48.cross3(vec47).normalize3();
        }
        double d = -vec44.dot3(vec4);
        return new Plane(vec4.getX(), vec4.getY(), vec4.getZ(), d);
    }

    protected boolean isSmallAngle(Globe globe, Box box, Box box2) {
        Vec4 vec4;
        LatLon[] latLonArray = box.getLocations();
        LatLon[] latLonArray2 = box2.getLocations();
        double[] dArray = box.getAltitudes();
        double[] dArray2 = box2.getAltitudes();
        Vec4 vec42 = globe.computePointFromPosition(latLonArray[0], dArray[0]);
        Vec4 vec43 = globe.computePointFromPosition(latLonArray[1], dArray[0]);
        Vec4 vec44 = globe.computePointFromPosition(latLonArray2[1], dArray2[0]);
        Vec4 vec45 = vec42.subtract3(vec43);
        Angle angle = vec45.angleBetween3(vec4 = vec44.subtract3(vec43));
        return angle.compareTo(this.getSmallAngleThreshold()) <= 0;
    }

    protected boolean isRightTurn(Globe globe, Box box, Box box2) {
        Vec4 vec4;
        Vec4 vec42;
        LatLon[] latLonArray = box.getLocations();
        LatLon[] latLonArray2 = box2.getLocations();
        double[] dArray = box.getAltitudes();
        double[] dArray2 = box2.getAltitudes();
        Vec4 vec43 = globe.computePointFromPosition(latLonArray[0], dArray[0]);
        Vec4 vec44 = globe.computePointFromPosition(latLonArray[1], dArray[0]);
        Vec4 vec45 = globe.computePointFromPosition(latLonArray2[1], dArray2[0]);
        Vec4 vec46 = vec43.subtract3(vec44);
        Vec4 vec47 = vec46.cross3(vec42 = vec45.subtract3(vec44));
        return vec47.dot3(vec4 = globe.computeSurfaceNormalAtLocation(latLonArray[1].getLatitude(), latLonArray[1].getLongitude())) >= 0.0;
    }

    @Override
    public void makeOrderedRenderable(DrawContext drawContext, AirspaceRenderer airspaceRenderer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (airspaceRenderer == null) {
            String string = Logging.getMessage("nullValue.RendererIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.isLegsOutOfDate(drawContext)) {
            this.doUpdateLegs(drawContext);
        }
        for (Box box : this.getLegs()) {
            if (!box.isVisible() || !box.isAirspaceVisible(drawContext)) continue;
            box.setAttributes(this.getAttributes());
            OrderedRenderable orderedRenderable = airspaceRenderer.createOrderedRenderable(drawContext, box, box.computeEyeDistance(drawContext), this);
            drawContext.addOrderedRenderable(orderedRenderable);
        }
    }

    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.isLegsOutOfDate(drawContext)) {
            this.doUpdateLegs(drawContext);
        }
        for (Box box : this.getLegs()) {
            if (!box.isVisible() || !box.isAirspaceVisible(drawContext)) continue;
            box.renderGeometry(drawContext, string);
        }
    }

    @Override
    protected void doRenderExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Box box : this.legs) {
            box.renderExtent(drawContext);
        }
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsBoolean(stateObject, "enableInnerCaps", this.isEnableInnerCaps());
        RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "legs");
        for (Box box : this.legs) {
            RestorableSupport.StateObject stateObject3 = restorableSupport.addStateObject(stateObject2, "leg");
            box.doGetRestorableState(restorableSupport, stateObject3);
        }
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject stateObject2;
        super.doRestoreState(restorableSupport, stateObject);
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "enableInnerCaps");
        if (bl != null) {
            this.setEnableInnerCaps(bl);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "legs")) == null) {
            return;
        }
        RestorableSupport.StateObject[] stateObjectArray = restorableSupport.getAllStateObjects(stateObject2, "leg");
        if (stateObjectArray == null || stateObjectArray.length == 0) {
            return;
        }
        ArrayList<Box> arrayList = new ArrayList<Box>(stateObjectArray.length);
        for (RestorableSupport.StateObject stateObject3 : stateObjectArray) {
            if (stateObject3 == null) continue;
            Box box = new Box();
            box.doRestoreState(restorableSupport, stateObject3);
            arrayList.add(box);
        }
        this.setLegs(arrayList);
    }
}

