/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.AirspaceRenderer;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;

public abstract class AbstractAirspace
extends AVListImpl
implements Airspace,
Movable {
    protected static final String ARC_SLICES = "ArcSlices";
    protected static final String DISABLE_TERRAIN_CONFORMANCE = "DisableTerrainConformance";
    protected static final String EXPIRY_TIME = "ExpiryTime";
    protected static final String GEOMETRY_CACHE_NAME = "Airspace Geometry";
    protected static final String GEOMETRY_CACHE_KEY = Geometry.class.getName();
    protected static final String GLOBE_KEY = "GlobeKey";
    protected static final String LENGTH_SLICES = "LengthSlices";
    protected static final String LOOPS = "Loops";
    protected static final String PILLARS = "Pillars";
    protected static final String SLICES = "Slices";
    protected static final String SPLIT_THRESHOLD = "SplitThreshold";
    protected static final String STACKS = "Stacks";
    protected static final String SUBDIVISIONS = "Subdivisions";
    protected static final String VERTICAL_EXAGGERATION = "VerticalExaggeration";
    private static final long DEFAULT_GEOMETRY_CACHE_SIZE = 0x1000000L;
    private boolean visible = true;
    private AirspaceAttributes attributes;
    private double lowerAltitude = 0.0;
    private double upperAltitude = 1.0;
    private boolean lowerTerrainConforming = false;
    private boolean upperTerrainConforming = false;
    private String lowerAltitudeDatum = "gov.nasa.worldwind.avkey.AboveMeanSeaLevel";
    private String upperAltitudeDatum = "gov.nasa.worldwind.avkey.AboveMeanSeaLevel";
    private LatLon groundReference;
    private boolean enableLevelOfDetail = true;
    private Collection<DetailLevel> detailLevels = new TreeSet<DetailLevel>();
    private AirspaceRenderer renderer = new AirspaceRenderer();
    private GeometryBuilder geometryBuilder = new GeometryBuilder();
    private long expiryTime = -1L;
    private long minExpiryTime = 2000L;
    private long maxExpiryTime = 6000L;
    private static Random rand = new Random();
    private Map<LatLon, Double> elevationMap = new HashMap<LatLon, Double>();
    protected HashMap<Globe, AirspaceInfo> airspaceInfo = new HashMap(2);

    public AbstractAirspace(AirspaceAttributes airspaceAttributes) {
        if (airspaceAttributes == null) {
            String string = "nullValue.AirspaceAttributesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = airspaceAttributes;
        if (!WorldWind.getMemoryCacheSet().containsCache(GEOMETRY_CACHE_KEY)) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.AirspaceGeometryCacheSize", 0x1000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName(GEOMETRY_CACHE_NAME);
            WorldWind.getMemoryCacheSet().addCache(GEOMETRY_CACHE_KEY, basicMemoryCache);
        }
    }

    protected abstract Extent computeExtent(Globe var1, double var2);

    protected abstract List<Vec4> computeMinimalGeometry(Globe var1, double var2);

    public AbstractAirspace() {
        this(new BasicAirspaceAttributes());
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public AirspaceAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(AirspaceAttributes airspaceAttributes) {
        if (airspaceAttributes == null) {
            String string = "nullValue.AirspaceAttributesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = airspaceAttributes;
    }

    @Override
    public double[] getAltitudes() {
        double[] dArray = new double[]{this.lowerAltitude, this.upperAltitude};
        return dArray;
    }

    protected double[] getAltitudes(double d) {
        double[] dArray = this.getAltitudes();
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        return dArray;
    }

    @Override
    public void setAltitudes(double d, double d2) {
        this.lowerAltitude = d;
        this.upperAltitude = d2;
        this.setExtentOutOfDate();
    }

    @Override
    public void setAltitude(double d) {
        this.setAltitudes(d, d);
    }

    @Override
    public boolean[] isTerrainConforming() {
        boolean[] blArray = new boolean[]{this.lowerTerrainConforming, this.upperTerrainConforming};
        return blArray;
    }

    @Override
    public void setTerrainConforming(boolean bl, boolean bl2) {
        this.lowerTerrainConforming = bl;
        this.upperTerrainConforming = bl2;
        this.lowerAltitudeDatum = this.lowerTerrainConforming ? "gov.nasa.worldwind.avkey.AboveGroundLevel" : "gov.nasa.worldwind.avkey.AboveMeanSeaLevel";
        this.upperAltitudeDatum = this.upperTerrainConforming ? "gov.nasa.worldwind.avkey.AboveGroundLevel" : "gov.nasa.worldwind.avkey.AboveMeanSeaLevel";
        this.setExtentOutOfDate();
    }

    @Override
    public String[] getAltitudeDatum() {
        return new String[]{this.lowerAltitudeDatum, this.upperAltitudeDatum};
    }

    @Override
    public void setAltitudeDatum(String string, String string2) {
        if (string == null || string2 == null) {
            String string3 = Logging.getMessage("nullValue.AltitudeDatumIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.lowerAltitudeDatum = string;
        this.upperAltitudeDatum = string2;
        if (string.equals("gov.nasa.worldwind.avkey.AboveGroundLevel") || string.equals("gov.nasa.worldwind.avkey.AboveGroundReference")) {
            this.lowerTerrainConforming = true;
        }
        if (string2.equals("gov.nasa.worldwind.avkey.AboveGroundLevel") || string2.equals("gov.nasa.worldwind.avkey.AboveGroundReference")) {
            this.upperTerrainConforming = true;
        }
        this.setExtentOutOfDate();
    }

    @Override
    public LatLon getGroundReference() {
        return this.groundReference;
    }

    @Override
    public void setGroundReference(LatLon latLon) {
        this.groundReference = latLon;
    }

    protected void adjustForGroundReference(DrawContext drawContext, boolean[] blArray, double[] dArray, LatLon latLon) {
        if (latLon == null) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            if (!this.getAltitudeDatum()[i].equals("gov.nasa.worldwind.avkey.AboveGroundReference")) continue;
            int n = i;
            dArray[n] = dArray[n] + this.computeElevationAt(drawContext, latLon.getLatitude(), latLon.getLongitude());
            blArray[i] = false;
        }
    }

    public boolean isAirspaceCollapsed() {
        return this.lowerAltitude == this.upperAltitude && this.lowerTerrainConforming == this.upperTerrainConforming;
    }

    @Override
    public void setTerrainConforming(boolean bl) {
        this.setTerrainConforming(bl, bl);
    }

    @Override
    public boolean isEnableLevelOfDetail() {
        return this.enableLevelOfDetail;
    }

    @Override
    public void setEnableLevelOfDetail(boolean bl) {
        this.enableLevelOfDetail = bl;
    }

    @Override
    public Iterable<DetailLevel> getDetailLevels() {
        return this.detailLevels;
    }

    @Override
    public void setDetailLevels(Collection<DetailLevel> collection) {
        this.detailLevels.clear();
        this.addDetailLevels(collection);
    }

    protected void addDetailLevels(Collection<DetailLevel> collection) {
        if (collection != null) {
            for (DetailLevel detailLevel : collection) {
                if (detailLevel == null) continue;
                this.detailLevels.add(detailLevel);
            }
        }
    }

    @Override
    public boolean isAirspaceVisible(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getView() == null) {
            String string = "nullValue.DrawingContextViewIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Extent extent = this.getExtent(drawContext);
        if (extent == null) {
            return false;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(extent);
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(extent);
    }

    @Override
    public Extent getExtent(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeExtent(globe, d);
    }

    @Override
    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.getAirspaceInfo((DrawContext)drawContext).extent;
    }

    protected AirspaceInfo getAirspaceInfo(DrawContext drawContext) {
        AirspaceInfo airspaceInfo = this.airspaceInfo.get(drawContext.getGlobe());
        if (airspaceInfo == null || !airspaceInfo.isValid(drawContext)) {
            airspaceInfo = new AirspaceInfo(drawContext, this.computeExtent(drawContext), this.computeMinimalGeometry(drawContext));
            this.airspaceInfo.put(drawContext.getGlobe(), airspaceInfo);
        }
        return airspaceInfo;
    }

    protected Extent computeExtent(DrawContext drawContext) {
        return this.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
    }

    protected List<Vec4> computeMinimalGeometry(DrawContext drawContext) {
        return this.computeMinimalGeometry(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
    }

    protected void setExtentOutOfDate() {
        this.airspaceInfo.clear();
    }

    public AirspaceRenderer getRenderer() {
        return this.renderer;
    }

    protected void setRenderer(AirspaceRenderer airspaceRenderer) {
        if (airspaceRenderer == null) {
            String string = "nullValue.AirspaceRendererIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.renderer = airspaceRenderer;
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if (!this.isAirspaceVisible(drawContext)) {
            return;
        }
        this.doRender(drawContext);
    }

    @Override
    public void makeOrderedRenderable(DrawContext drawContext, AirspaceRenderer airspaceRenderer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (airspaceRenderer == null) {
            String string = Logging.getMessage("nullValue.RendererIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        OrderedRenderable orderedRenderable = airspaceRenderer.createOrderedRenderable(drawContext, this, this.computeEyeDistance(drawContext), this);
        drawContext.addOrderedRenderable(orderedRenderable);
    }

    @Override
    public void renderGeometry(DrawContext drawContext, String string) {
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.doRenderGeometry(drawContext, string);
    }

    @Override
    public void renderExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.doRenderExtent(drawContext);
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        Position position3 = position;
        this.doMoveTo(position2, position3);
    }

    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getAltitudes();
        double d = position2.getElevation() - position.getElevation();
        this.setAltitudes(dArray[0] + d, dArray[1] + d);
    }

    protected Position computeReferencePosition(List<? extends LatLon> list, double[] dArray) {
        if (list == null) {
            String string = "nullValue.LocationsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = "nullValue.AltitudesIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = list.size();
        if (n == 0) {
            return null;
        }
        LatLon latLon = n < 3 ? list.get(0) : list.get(n / 2);
        return new Position(latLon, dArray[0]);
    }

    protected double computeEyeDistance(DrawContext drawContext) {
        AirspaceInfo airspaceInfo = this.getAirspaceInfo(drawContext);
        if (airspaceInfo == null || airspaceInfo.minimalGeometry == null || airspaceInfo.minimalGeometry.isEmpty()) {
            return 0.0;
        }
        double d = Double.MAX_VALUE;
        Vec4 vec4 = drawContext.getView().getEyePoint();
        for (Vec4 vec42 : airspaceInfo.minimalGeometry) {
            double d2 = vec42.distanceToSquared3(vec4);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return Math.sqrt(d);
    }

    protected abstract void doRenderGeometry(DrawContext var1, String var2);

    protected GeometryBuilder getGeometryBuilder() {
        return this.geometryBuilder;
    }

    protected void setGeometryBuilder(GeometryBuilder geometryBuilder) {
        if (geometryBuilder == null) {
            String string = "nullValue.GeometryBuilderIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.geometryBuilder = geometryBuilder;
    }

    protected void doRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AirspaceRenderer airspaceRenderer = this.getRenderer();
        airspaceRenderer.renderOrdered(drawContext, Arrays.asList(this));
    }

    protected void doRenderExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Extent extent = this.getExtent(drawContext);
        if (extent != null && extent instanceof Renderable) {
            ((Renderable)((Object)extent)).render(drawContext);
        }
    }

    protected DetailLevel computeDetailLevel(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterable<DetailLevel> iterable = this.getDetailLevels();
        if (iterable == null) {
            return null;
        }
        Iterator<DetailLevel> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        DetailLevel detailLevel = iterator.next();
        while (iterator.hasNext() && !detailLevel.meetsCriteria(drawContext, this)) {
            detailLevel = iterator.next();
        }
        return detailLevel;
    }

    protected MemoryCache getGeometryCache() {
        return WorldWind.getMemoryCache(GEOMETRY_CACHE_KEY);
    }

    protected boolean isExpired(DrawContext drawContext, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = "nullValue.AirspaceGeometryIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object = geometry.getValue(EXPIRY_TIME);
        if (object != null && object instanceof Long && drawContext.getFrameTimeStamp() > (Long)object) {
            return true;
        }
        object = geometry.getValue(GLOBE_KEY);
        return object != null && !drawContext.getGlobe().getStateKey(drawContext).equals(object);
    }

    protected void updateExpiryCriteria(DrawContext drawContext, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = this.getExpiryTime();
        geometry.setValue(EXPIRY_TIME, l >= 0L ? Long.valueOf(l) : null);
        geometry.setValue(GLOBE_KEY, drawContext.getGlobe().getStateKey(drawContext));
    }

    protected long getExpiryTime() {
        return this.expiryTime;
    }

    protected void setExpiryTime(long l) {
        this.expiryTime = l;
    }

    protected long[] getExpiryRange() {
        long[] lArray = new long[]{this.minExpiryTime, this.maxExpiryTime};
        return lArray;
    }

    protected void setExpiryRange(long l, long l2) {
        this.minExpiryTime = l;
        this.maxExpiryTime = l2;
    }

    protected long nextExpiryTime(DrawContext drawContext, boolean[] blArray) {
        long l;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (blArray[0] || blArray[1]) {
            long l2 = AbstractAirspace.nextLong(this.minExpiryTime, this.maxExpiryTime);
            l = drawContext.getFrameTimeStamp() + l2;
        } else {
            l = -1L;
        }
        return l;
    }

    private static long nextLong(long l, long l2) {
        long l3 = l2 - l + 1L;
        long l4 = rand.nextLong() % l3;
        return l + (l4 < 0L ? -l4 : l4);
    }

    protected void clearElevationMap() {
        this.elevationMap.clear();
    }

    public Vec4 computePointFromPosition(DrawContext drawContext, Angle angle, Angle angle2, double d, boolean bl) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = d;
        if (bl) {
            d2 += this.computeElevationAt(drawContext, angle, angle2);
        }
        return drawContext.getGlobe().computePointFromPosition(angle, angle2, d2);
    }

    protected double computeElevationAt(DrawContext drawContext, Angle angle, Angle angle2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = new LatLon(angle, angle2);
        Double d = this.elevationMap.get(latLon);
        if (d == null) {
            Globe globe = drawContext.getGlobe();
            d = 0.0;
            Vec4 vec4 = drawContext.getPointOnTerrain(angle, angle2);
            if (vec4 != null) {
                Position position = globe.computePositionFromPoint(vec4);
                d = d + position.getElevation();
            } else {
                d = d + drawContext.getVerticalExaggeration() * globe.getElevation(angle, angle2);
            }
            this.elevationMap.put(latLon, d);
        }
        return d;
    }

    protected void makeExtremePoints(Globe globe, double d, Iterable<? extends LatLon> iterable, List<Vec4> list) {
        Object object;
        Object object2;
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = "nullValue.LocationsIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getAltitudes();
        boolean[] blArray = this.isTerrainConforming();
        if (blArray[0] || blArray[1]) {
            object2 = new double[2];
            if (LatLon.locationsCrossDateLine(iterable)) {
                object = Sector.splitBoundingSectors(iterable);
                double[] dArray2 = globe.getMinAndMaxElevations(object[0]);
                double[] dArray3 = globe.getMinAndMaxElevations((Sector)object[1]);
                object2[0] = Math.min(dArray2[0], dArray3[0]);
                object2[1] = Math.max(dArray2[1], dArray3[1]);
            } else {
                object = Sector.boundingSector(iterable);
                object2 = globe.getMinAndMaxElevations((Sector)object);
            }
            if (blArray[0]) {
                dArray[0] = dArray[0] + object2[0];
            }
            if (blArray[1]) {
                dArray[1] = dArray[1] + object2[1];
            }
        }
        object2 = iterable.iterator();
        while (object2.hasNext()) {
            object = (LatLon)object2.next();
            list.add(globe.computePointFromPosition(((LatLon)object).getLatitude(), ((LatLon)object).getLongitude(), d * dArray[0]));
            list.add(globe.computePointFromPosition(((LatLon)object).getLatitude(), ((LatLon)object).getLongitude(), d * dArray[1]));
        }
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        this.doMyGetRestorableState(restorableSupport, stateObject);
    }

    private void doMyGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsBoolean(stateObject, "visible", this.isVisible());
        restorableSupport.addStateValueAsDouble(stateObject, "lowerAltitude", this.getAltitudes()[0]);
        restorableSupport.addStateValueAsDouble(stateObject, "upperAltitude", this.getAltitudes()[1]);
        restorableSupport.addStateValueAsBoolean(stateObject, "lowerTerrainConforming", this.isTerrainConforming()[0]);
        restorableSupport.addStateValueAsBoolean(stateObject, "upperTerrainConforming", this.isTerrainConforming()[1]);
        restorableSupport.addStateValueAsString(stateObject, "lowerAltitudeDatum", this.getAltitudeDatum()[0]);
        restorableSupport.addStateValueAsString(stateObject, "upperAltitudeDatum", this.getAltitudeDatum()[1]);
        if (this.getGroundReference() != null) {
            restorableSupport.addStateValueAsLatLon(stateObject, "groundReference", this.getGroundReference());
        }
        this.attributes.getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "attributes"));
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        this.doMyRestoreState(restorableSupport, stateObject);
    }

    private void doMyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject stateObject2;
        String string;
        Boolean bl;
        Double d;
        Double d2;
        Boolean bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "visible");
        if (bl2 != null) {
            this.setVisible(bl2);
        }
        if ((d2 = restorableSupport.getStateValueAsDouble(stateObject, "lowerAltitude")) == null) {
            d2 = this.getAltitudes()[0];
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "upperAltitude")) == null) {
            d = this.getAltitudes()[1];
        }
        this.setAltitudes(d2, d);
        Boolean bl3 = restorableSupport.getStateValueAsBoolean(stateObject, "lowerTerrainConforming");
        if (bl3 == null) {
            bl3 = this.isTerrainConforming()[0];
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "upperTerrainConforming")) == null) {
            bl = this.isTerrainConforming()[1];
        }
        this.setTerrainConforming(bl3, bl);
        String string2 = restorableSupport.getStateValueAsString(stateObject, "lowerAltitudeDatum");
        if (string2 == null) {
            string2 = this.getAltitudeDatum()[0];
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "upperAltitudeDatum")) == null) {
            string = this.getAltitudeDatum()[1];
        }
        this.setAltitudeDatum(string2, string);
        LatLon latLon = restorableSupport.getStateValueAsLatLon(stateObject, "groundReference");
        if (latLon != null) {
            this.setGroundReference(latLon);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "attributes")) != null) {
            this.getAttributes().restoreState(restorableSupport, stateObject2);
        }
    }

    protected static class AirspaceInfo {
        protected Extent extent;
        protected List<Vec4> minimalGeometry;
        protected double verticalExaggeration;
        protected Object globeStateKey;

        public AirspaceInfo(DrawContext drawContext, Extent extent, List<Vec4> list) {
            this.extent = extent;
            this.minimalGeometry = list;
            this.verticalExaggeration = drawContext.getVerticalExaggeration();
            this.globeStateKey = drawContext.getGlobe().getStateKey(drawContext);
        }

        protected boolean isValid(DrawContext drawContext) {
            return this.verticalExaggeration == drawContext.getVerticalExaggeration() && this.globeStateKey != null && this.globeStateKey.equals(drawContext.getGlobe().getStateKey(drawContext));
        }
    }
}

