/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SurfaceQuad
extends AbstractSurfaceShape
implements Exportable {
    protected LatLon center = LatLon.ZERO;
    protected double width;
    protected double height;
    protected Angle heading = Angle.ZERO;

    public SurfaceQuad() {
    }

    public SurfaceQuad(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    public SurfaceQuad(LatLon latLon, double d, double d2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.WidthIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("Geom.HeightIsNegative", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.width = d;
        this.height = d2;
    }

    public SurfaceQuad(LatLon latLon, double d, double d2, Angle angle) {
        this(latLon, d, d2);
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = angle;
    }

    public SurfaceQuad(ShapeAttributes shapeAttributes, LatLon latLon, double d, double d2) {
        super(shapeAttributes);
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.WidthIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("Geom.HeightIsNegative", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.width = d;
        this.height = d2;
    }

    public SurfaceQuad(ShapeAttributes shapeAttributes, LatLon latLon, double d, double d2, Angle angle) {
        this(shapeAttributes, latLon, d, d2);
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = angle;
    }

    public LatLon getCenter() {
        return this.center;
    }

    public void setCenter(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.onShapeChanged();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.WidthIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = d;
        this.onShapeChanged();
    }

    public void setHeight(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.HeightIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.height = d;
        this.onShapeChanged();
    }

    public void setSize(double d, double d2) {
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.WidthIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("Geom.HeightIsNegative", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = d;
        this.height = d2;
        this.onShapeChanged();
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = angle;
        this.onShapeChanged();
    }

    @Override
    public Object getStateKey(DrawContext drawContext) {
        return new AbstractSurfaceShape.SurfaceShapeStateKey(this.getUniqueId(), this.lastModifiedTime, this.getActiveAttributes().copy(), drawContext.getGlobe().getStateKey(drawContext));
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.center, 0.0);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        Angle angle = LatLon.greatCircleAzimuth(position, this.center);
        Angle angle2 = LatLon.greatCircleDistance(position, this.center);
        this.setCenter(LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2));
    }

    @Override
    public Iterable<? extends LatLon> getLocations(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.width == 0.0 && this.height == 0.0) {
            return null;
        }
        double d = this.width / 2.0;
        double d2 = this.height / 2.0;
        double d3 = globe.getRadiusAt(this.center.getLatitude(), this.center.getLongitude());
        double d4 = Math.sqrt(d * d + d2 * d2);
        double d5 = d4 / d3;
        double[] dArray = new double[]{Math.atan2(-d2, -d), Math.atan2(-d2, d), Math.atan2(d2, d), Math.atan2(d2, -d), Math.atan2(-d2, -d)};
        LatLon[] latLonArray = new LatLon[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d6 = 1.5707963267948966 - (dArray[i] - this.heading.radians);
            latLonArray[i] = LatLon.greatCircleEndPosition(this.center, d6, d5);
        }
        return Arrays.asList(latLonArray);
    }

    @Override
    protected List<List<LatLon>> createGeometry(Globe globe, SurfaceTileDrawContext surfaceTileDrawContext) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterable<? extends LatLon> iterable = this.getLocations(globe);
        if (iterable == null) {
            return null;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        double d = this.computeEdgeIntervalsPerDegree(surfaceTileDrawContext);
        this.generateIntermediateLocations(iterable, d, false, arrayList);
        ArrayList<List<LatLon>> arrayList2 = new ArrayList<List<LatLon>>();
        arrayList2.add(arrayList);
        return arrayList2;
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsLatLon(stateObject, "center", this.getCenter());
        restorableSupport.addStateValueAsDouble(stateObject, "width", this.getWidth());
        restorableSupport.addStateValueAsDouble(stateObject, "height", this.getHeight());
        restorableSupport.addStateValueAsDouble(stateObject, "headingDegrees", this.getHeading().degrees);
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        super.doRestoreState(restorableSupport, stateObject);
        LatLon latLon = restorableSupport.getStateValueAsLatLon(stateObject, "center");
        if (latLon != null) {
            this.setCenter(latLon);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "width")) != null) {
            this.setWidth(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "height")) != null) {
            this.setHeight(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "headingDegrees")) != null) {
            this.setHeading(Angle.fromDegrees(d));
        }
    }

    @Override
    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        super.legacyRestoreState(restorableSupport, stateObject);
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "halfWidth");
        Double d3 = restorableSupport.getStateValueAsDouble(stateObject, "halfHeight");
        if (d2 != null && d3 != null) {
            this.setSize(2.0 * d2, 2.0 * d3);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "orientationDegrees")) != null) {
            this.setHeading(Angle.fromDegrees(d));
        }
    }

    @Override
    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
        String string;
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string2 = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string2);
            throw new IllegalArgumentException(string2);
        }
        xMLStreamWriter.writeStartElement("Placemark");
        String string3 = (String)this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        if (string3 != null) {
            xMLStreamWriter.writeStartElement("name");
            xMLStreamWriter.writeCharacters(string3);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("visibility");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isVisible()));
        xMLStreamWriter.writeEndElement();
        String string4 = (String)this.getValue("gov.nasa.worldwind.avkey.Server.ShortDescription");
        if (string4 != null) {
            xMLStreamWriter.writeStartElement("Snippet");
            xMLStreamWriter.writeCharacters(string4);
            xMLStreamWriter.writeEndElement();
        }
        if ((string = (String)this.getValue("gov.nasa.worldwind.avkey.BalloonText")) != null) {
            xMLStreamWriter.writeStartElement("description");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
        }
        ShapeAttributes shapeAttributes = this.getAttributes();
        ShapeAttributes shapeAttributes2 = this.getHighlightAttributes();
        if (shapeAttributes != null || shapeAttributes2 != null) {
            xMLStreamWriter.writeStartElement("StyleMap");
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "normal", shapeAttributes);
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "highlight", shapeAttributes2);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("Polygon");
        xMLStreamWriter.writeStartElement("extrude");
        xMLStreamWriter.writeCharacters("0");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters("clampToGround");
        xMLStreamWriter.writeEndElement();
        String string5 = Configuration.getStringValue("gov.nasa.worldwind.avkey.GlobeClassName", "gov.nasa.worldwind.globes.Earth");
        Globe globe = (Globe)WorldWind.createComponent(string5);
        Iterable<? extends LatLon> iterable = this.getLocations(globe);
        if (iterable != null) {
            xMLStreamWriter.writeStartElement("outerBoundaryIs");
            KMLExportUtil.exportBoundaryAsLinearRing(xMLStreamWriter, iterable, null);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }
}

