/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenCredit;
import gov.nasa.worldwind.render.ScreenImage;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.Rectangle;

public class ScreenCreditImage
extends ScreenImage
implements ScreenCredit {
    private String name;
    private String link;
    private Rectangle viewport;

    public ScreenCreditImage(String string, Object object) {
        if (object == null) {
            String string2 = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.name = string;
        this.setImageSource(object);
    }

    @Override
    public void setViewport(Rectangle rectangle) {
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.ViewportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.viewport = rectangle;
        this.setScreenLocation(new Point(rectangle.x, rectangle.y));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Rectangle getViewport() {
        return this.viewport;
    }

    @Override
    public void setLink(String string) {
        this.link = string;
    }

    @Override
    public String getLink() {
        return this.link;
    }

    @Override
    public int getImageWidth(DrawContext drawContext) {
        return (int)this.getViewport().getWidth();
    }

    @Override
    public int getImageHeight(DrawContext drawContext) {
        return (int)this.getViewport().getHeight();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScreenCreditImage screenCreditImage = (ScreenCreditImage)object;
        return !(this.name != null ? !this.name.equals(screenCreditImage.name) : screenCreditImage.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

