/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.render.AbstractAnnotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.media.opengl.GL;

public class ScreenAnnotation
extends AbstractAnnotation {
    private Point screenPoint;

    public ScreenAnnotation(String string, Point point) {
        this.init(string, point, null, null);
    }

    public ScreenAnnotation(String string, Point point, Font font) {
        this.init(string, point, font, null);
    }

    public ScreenAnnotation(String string, Point point, Font font, Color color) {
        this.init(string, point, font, color);
    }

    public ScreenAnnotation(String string, Point point, AnnotationAttributes annotationAttributes) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (point == null) {
            String string3 = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (annotationAttributes == null) {
            String string4 = Logging.getMessage("nullValue.AnnotationAttributesIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.setText(string);
        this.screenPoint = point;
        this.getAttributes().setDefaults(annotationAttributes);
        this.getAttributes().setLeader("gov.nasa.worldwind.avkey.ShapeNone");
        this.getAttributes().setDrawOffset(new Point(0, 0));
    }

    private void init(String string, Point point, Font font, Color color) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (point == null) {
            String string3 = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.setText(string);
        this.screenPoint = point;
        this.getAttributes().setFont(font);
        this.getAttributes().setTextColor(color);
        this.getAttributes().setLeader("gov.nasa.worldwind.avkey.ShapeNone");
        this.getAttributes().setDrawOffset(new Point(0, 0));
    }

    public Point getScreenPoint() {
        return this.screenPoint;
    }

    protected Point getScreenPoint(DrawContext drawContext) {
        return this.screenPoint;
    }

    public void setScreenPoint(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.screenPoint = point;
    }

    @Override
    protected Rectangle computeBounds(DrawContext drawContext) {
        Dimension dimension = this.getPreferredSize(drawContext);
        double d = this.computeScale(drawContext);
        Point point = this.getAttributes().getDrawOffset();
        double d2 = (double)point.x * d;
        double d3 = (double)point.y * d;
        double d4 = (double)dimension.width * d;
        double d5 = (double)dimension.height * d;
        Point point2 = this.getScreenPoint(drawContext);
        double d6 = (double)point2.x - d4 / 2.0 + d2;
        double d7 = (double)point2.y + d3;
        Rectangle rectangle = new Rectangle((int)d6, (int)d7, (int)d4, (int)d5);
        return this.computeBoundingRectangle(rectangle, point2.x, point2.y);
    }

    protected Point computeSize(DrawContext drawContext) {
        double d = this.computeScale(drawContext);
        Dimension dimension = this.getPreferredSize(drawContext);
        return new Point((int)((double)dimension.width * d), (int)((double)dimension.height * d));
    }

    protected double[] computeOffset(DrawContext drawContext) {
        double d = this.computeScale(drawContext);
        Point point = this.getAttributes().getDrawOffset();
        return new double[]{(double)point.x * d, (double)point.y * d};
    }

    @Override
    protected void doRenderNow(DrawContext drawContext) {
        if (drawContext.isPickingMode() && this.getPickSupport() == null) {
            return;
        }
        GL gL = drawContext.getGL();
        gL.glDepthFunc(519);
        Dimension dimension = this.getPreferredSize(drawContext);
        Point point = this.getScreenPoint(drawContext);
        this.drawTopLevelAnnotation(drawContext, point.x, point.y, dimension.width, dimension.height, 1.0, 1.0, null);
    }

    @Override
    public String getRestorableState() {
        RestorableSupport.StateObject stateObject;
        RestorableSupport restorableSupport = null;
        String string = super.getRestorableState();
        if (string != null) {
            try {
                restorableSupport = RestorableSupport.parse(string);
            }
            catch (Exception exception) {
                String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
                Logging.logger().severe(string2);
            }
        }
        if (restorableSupport == null) {
            restorableSupport = RestorableSupport.newRestorableSupport();
        }
        if (restorableSupport == null) {
            return null;
        }
        if (this.screenPoint != null && (stateObject = restorableSupport.addStateObject("screenPoint")) != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "x", this.screenPoint.getX());
            restorableSupport.addStateValueAsDouble(stateObject, "y", this.screenPoint.getY());
        }
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            super.restoreState(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        RestorableSupport.StateObject stateObject = restorableSupport.getStateObject("screenPoint");
        if (stateObject != null) {
            Double d = restorableSupport.getStateValueAsDouble(stateObject, "x");
            Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "y");
            if (d != null && d2 != null) {
                this.setScreenPoint(new Point(d.intValue(), d2.intValue()));
            }
        }
    }
}

