/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.io;

import gov.nasa.worldwind.ogc.kml.io.KMLDoc;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class KMZInputStream
implements KMLDoc {
    protected ZipInputStream zipStream;
    protected ZipEntry currentEntry;
    protected Map<String, File> files;
    protected File tempDir;

    public KMZInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.zipStream = new ZipInputStream(inputStream);
        this.files = new HashMap<String, File>();
        this.moveToNextEntry();
    }

    protected void moveToNextEntry() throws IOException {
        ZipEntry zipEntry = this.zipStream.getNextEntry();
        if (zipEntry == null && this.currentEntry != null) {
            this.zipStream.close();
        }
        this.currentEntry = zipEntry;
    }

    @Override
    public synchronized InputStream getKMLStream() throws IOException {
        while (this.currentEntry != null) {
            if (this.currentEntry.getName().toLowerCase().endsWith(".kml")) {
                String string = this.currentEntry.getName();
                this.copyCurrentEntryToTempDir();
                File file = this.files.get(string);
                return file != null ? new FileInputStream(file) : null;
            }
            this.copyCurrentEntryToTempDir();
        }
        return null;
    }

    @Override
    public synchronized InputStream getSupportFileStream(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = this.files.get(string);
        if (file != null) {
            return new FileInputStream(file);
        }
        if (this.currentEntry == null) {
            return null;
        }
        this.copyCurrentEntryToTempDir();
        return this.getSupportFileStream(string);
    }

    @Override
    public synchronized String getSupportFilePath(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = this.files.get(string);
        if (file != null) {
            return file.getPath();
        }
        if (this.currentEntry == null) {
            return null;
        }
        this.copyCurrentEntryToTempDir();
        return this.getSupportFilePath(string);
    }

    protected void copyCurrentEntryToTempDir() throws IOException {
        if (this.currentEntry == null) {
            return;
        }
        if (this.currentEntry.isDirectory()) {
            this.moveToNextEntry();
            return;
        }
        if (this.tempDir == null) {
            this.tempDir = WWIO.makeTempDir();
        }
        if (this.tempDir == null) {
            String string = Logging.getMessage("generic.UnableToCreateTempDir", this.tempDir);
            Logging.logger().warning(string);
            return;
        }
        String string = this.tempDir + File.separator + this.currentEntry.getName();
        WWIO.makeParentDirs(string);
        File file = new File(string);
        file.deleteOnExit();
        WWIO.saveBuffer(WWIO.readStreamToBuffer(this.zipStream), file);
        this.files.put(this.currentEntry.getName(), file);
        this.moveToNextEntry();
    }
}

