/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class KMLExportUtil {
    public static String kmlAltitudeMode(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "clampToGround";
                break;
            }
            case 2: {
                string = "relativeToGround";
                break;
            }
            case 0: 
            case 3: {
                string = "absolute";
                break;
            }
            default: {
                String string2 = Logging.getMessage("generic.InvalidAltitudeMode", n);
                Logging.logger().warning(string2);
                throw new IllegalArgumentException(string2);
            }
        }
        return string;
    }

    public static void exportAttributesAsKML(XMLStreamWriter xMLStreamWriter, String string, ShapeAttributes shapeAttributes) throws XMLStreamException, IOException {
        if (shapeAttributes != null) {
            xMLStreamWriter.writeStartElement("Pair");
            xMLStreamWriter.writeStartElement("key");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
            shapeAttributes.export("application/vnd.google-earth.kml+xml", xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
    }

    public static void exportOffset(XMLStreamWriter xMLStreamWriter, Offset offset, String string) throws XMLStreamException {
        if (offset != null) {
            xMLStreamWriter.writeStartElement(string);
            xMLStreamWriter.writeAttribute("x", Double.toString(offset.getX()));
            xMLStreamWriter.writeAttribute("y", Double.toString(offset.getY()));
            xMLStreamWriter.writeAttribute("xunits", KMLUtil.wwUnitsToKMLUnits(offset.getXUnits()));
            xMLStreamWriter.writeAttribute("yunits", KMLUtil.wwUnitsToKMLUnits(offset.getYUnits()));
            xMLStreamWriter.writeEndElement();
        }
    }

    public static void exportDimension(XMLStreamWriter xMLStreamWriter, Size size, String string) throws XMLStreamException {
        if (size != null) {
            xMLStreamWriter.writeStartElement(string);
            KMLExportUtil.exportDimensionAttributes("x", xMLStreamWriter, size.getWidthMode(), size.getWidth(), size.getWidthUnits());
            KMLExportUtil.exportDimensionAttributes("y", xMLStreamWriter, size.getHeightMode(), size.getHeight(), size.getHeightUnits());
            xMLStreamWriter.writeEndElement();
        }
    }

    private static void exportDimensionAttributes(String string, XMLStreamWriter xMLStreamWriter, String string2, double d, String string3) throws XMLStreamException {
        if ("gov.nasa.worldwind.render.Size.NativeDimension".equals(string2)) {
            xMLStreamWriter.writeAttribute(string, "-1");
        } else if ("gov.nasa.worldwind.render.Size.MaintainAspectRatio".equals(string2)) {
            xMLStreamWriter.writeAttribute(string, "0");
        } else if ("gov.nasa.worldwind.render.Size.ExplicitDimension".equals(string2)) {
            xMLStreamWriter.writeAttribute(string, Double.toString(d));
            xMLStreamWriter.writeAttribute(string + "units", KMLUtil.wwUnitsToKMLUnits(string3));
        } else {
            Logging.logger().warning(Logging.getMessage("generic.UnknownSizeMode", string2));
        }
    }

    public static String stripHexPrefix(String string) {
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return string.substring(2);
        }
        return string;
    }

    public static void exportBoundaryAsLinearRing(XMLStreamWriter xMLStreamWriter, Iterable<? extends LatLon> iterable, Double d) throws XMLStreamException {
        String string = null;
        if (d != null) {
            string = Double.toString(d);
        }
        xMLStreamWriter.writeStartElement("LinearRing");
        xMLStreamWriter.writeStartElement("coordinates");
        for (LatLon latLon : iterable) {
            xMLStreamWriter.writeCharacters(Double.toString(latLon.getLongitude().getDegrees()));
            xMLStreamWriter.writeCharacters(",");
            xMLStreamWriter.writeCharacters(Double.toString(latLon.getLatitude().getDegrees()));
            if (string != null) {
                xMLStreamWriter.writeCharacters(",");
                xMLStreamWriter.writeCharacters(string);
            }
            xMLStreamWriter.writeCharacters(" ");
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    public static String kmlBoolean(boolean bl) {
        return bl ? "1" : "0";
    }
}

