/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada.io;

import gov.nasa.worldwind.ogc.collada.io.ColladaDoc;
import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class ColladaInputStream
implements ColladaDoc {
    protected InputStream inputStream;
    protected URI uri;

    public ColladaInputStream(InputStream inputStream, URI uRI) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.inputStream = inputStream;
        this.uri = uRI;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    @Override
    public String getSupportFilePath(String string) {
        URI uRI;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.uri != null && (uRI = this.uri.resolve(string)) != null) {
            return uRI.toString();
        }
        return null;
    }
}

