/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.Rectangle;

public class PickPointFrustum
extends Frustum {
    private final Rectangle screenRect;

    public PickPointFrustum(Frustum frustum, Rectangle rectangle) {
        super(frustum.getLeft(), frustum.getRight(), frustum.getBottom(), frustum.getTop(), frustum.getNear(), frustum.getFar());
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.screenRect = rectangle;
    }

    public final boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        return this.screenRect.intersects(rectangle);
    }

    public final boolean contains(double d, double d2) {
        return this.screenRect.contains(d, d2);
    }

    public final boolean contains(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        return this.screenRect.contains(point);
    }

    @Override
    public PickPointFrustum transformBy(Matrix matrix) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        return new PickPointFrustum(super.transformBy(matrix), this.screenRect);
    }

    public Rectangle getScreenRect() {
        return this.screenRect;
    }
}

