/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.formats.tiff.TiffIFDEntry;
import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;

class TIFFReader {
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private static final int DOUBLE_SIZEOF = 8;
    private static final int FLOAT_SIZEOF = 4;
    private static final int INTEGER_SIZEOF = 4;
    private static final int SHORT_SIZEOF = 2;
    private FileChannel theChannel;
    private ByteOrder tiffFileOrder;

    public TIFFReader(FileChannel fileChannel, ByteOrder byteOrder) {
        this.theChannel = fileChannel;
        this.tiffFileOrder = byteOrder;
    }

    public TIFFReader(FileChannel fileChannel) {
        this(fileChannel, ByteOrder.BIG_ENDIAN);
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.tiffFileOrder = byteOrder;
    }

    public ByteOrder getByteOrder() {
        return this.tiffFileOrder;
    }

    public byte[] readLZWCompressed(int n, int n2, long l, int n3, boolean bl, long[] lArray, long[] lArray2) throws IOException {
        this.theChannel.position(l);
        byte[] byArray = new byte[n * n2 * n3];
        int n4 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            int n5;
            long l2;
            long l3;
            if (i > 0 && (l3 = lArray[i] - lArray[i - 1] - lArray2[i - 1]) > 0L) {
                this.theChannel.position(this.theChannel.position() + l3);
            }
            byte[] byArray2 = new byte[(int)lArray2[i]];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            int n6 = 0;
            int n7 = byArray2.length;
            while (n7 > 0 && (l2 = (long)this.theChannel.read(byteBuffer)) != -1L) {
                n6 = (int)((long)n6 + l2);
                n7 = (int)((long)n7 - l2);
            }
            byArray2 = this.lzwUncompress(byArray2, n * n3);
            if (bl) {
                for (int j = 0; j < byArray2.length; ++j) {
                    if (j / n3 % n == 0) continue;
                    int n8 = j;
                    byArray2[n8] = (byte)(byArray2[n8] + byArray2[j - n3]);
                }
            }
            int n9 = 0;
            int n10 = byArray2.length;
            if ((n5 = n4 + (n10 -= n10 % n)) > n * n2 * n3) {
                n5 = n * n2 * n3;
            }
            for (int j = n4; j < n5; ++j) {
                byArray[j] = byArray2[n9++];
            }
            n4 += n10;
        }
        return byArray;
    }

    public byte[] lzwUncompress(byte[] byArray, int n) {
        int n2;
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        byte[][] byArray2 = new byte[4096][1];
        int n3 = 9;
        int n4 = 258;
        int n5 = -1;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        CodeReader codeReader = new CodeReader(byArray);
        while ((n2 = codeReader.getCode(n3)) != 257 && n2 != -1) {
            int n6;
            if (n2 == 256) {
                for (n6 = 0; n6 < 256; ++n6) {
                    byArray2[n6][0] = (byte)n6;
                }
                n4 = 258;
                n3 = 9;
                n2 = codeReader.getCode(n3);
                if (n2 == 257 || n2 == -1) break;
                byteBuffer.put(byArray2[n2]);
                n5 = n2;
                continue;
            }
            if (n2 < n4) {
                byteBuffer.put(byArray2[n2]);
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(byArray2[n5].length + 1);
                byteBuffer2.put(byArray2[n5]);
                byteBuffer2.put(byArray2[n2][0]);
                byArray2[n4] = byteBuffer2.array();
                n5 = n2;
                ++n4;
            } else {
                n6 = byArray2[n5].length + 1;
                ByteBuffer byteBuffer3 = ByteBuffer.allocate(n6);
                byteBuffer3.put(byArray2[n5]);
                byteBuffer3.put(byArray2[n5][0]);
                byte[] byArray3 = byteBuffer3.array();
                byteBuffer.put(byArray3);
                byArray2[n4] = byArray3;
                n5 = n2;
                ++n4;
            }
            if (n4 == 511) {
                n3 = 10;
            }
            if (n4 == 1023) {
                n3 = 11;
            }
            if (n4 != 2047) continue;
            n3 = 12;
        }
        return byteBuffer.array();
    }

    public byte[][] readPixelInterleaved8(int n, int n2, int n3, long[] lArray, long[] lArray2) throws IOException {
        byte[][] byArray = new byte[1][n * n2 * n3];
        int n4 = 0;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray[0]);
        for (int i = 0; i < lArray.length; ++i) {
            this.theChannel.position(lArray[i]);
            int n5 = (int)lArray2[i];
            if (n4 + n5 >= byArray[0].length) {
                n5 = byArray[0].length - n4;
            }
            byteBuffer.limit(n4 + n5);
            this.theChannel.read(byteBuffer);
            n4 = (int)((long)n4 + lArray2[i]);
        }
        return byArray;
    }

    public byte[][] readPlanar8(int n, int n2, int n3, long[] lArray, long[] lArray2, long l) throws IOException {
        byte[][] byArray = new byte[n3][n * n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray[n4]);
        for (int i = 0; i < lArray.length; ++i) {
            this.theChannel.position(lArray[i]);
            int n7 = (int)lArray2[i];
            if (n5 + n7 >= byArray[n4].length) {
                n7 = byArray[n4].length - n5;
            }
            byteBuffer.limit(n5 + n7);
            this.theChannel.read(byteBuffer);
            n5 = (int)((long)n5 + lArray2[i]);
            n6 = (int)((long)n6 + l);
            if (n6 < n2 || n4 >= byArray.length - 1) continue;
            byteBuffer = ByteBuffer.wrap(byArray[++n4]);
            n6 = 0;
            n5 = 0;
        }
        return byArray;
    }

    public short[] read16bitPixelInterleavedImage(int n, int n2, int n3, int n4, long[] lArray, long[] lArray2, long l) throws IOException {
        short[] sArray = new short[n2 * n3];
        boolean bl = false;
        Buffer buffer = null;
        int n5 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            this.theChannel.position(lArray[i]);
            int n6 = (int)lArray2[i];
            if (null == buffer || buffer.capacity() < n6) {
                buffer = ByteBuffer.allocateDirect(n6);
                ((ByteBuffer)buffer).order(this.getByteOrder());
            }
            ((ByteBuffer)buffer).clear().rewind();
            ((ByteBuffer)buffer).limit(n6);
            this.theChannel.read((ByteBuffer)buffer);
            ((ByteBuffer)buffer).flip();
            ShortBuffer shortBuffer = ((ByteBuffer)buffer).asShortBuffer();
            int n7 = 0;
            while (shortBuffer.hasRemaining()) {
                if (n == n7++ % n4) {
                    sArray[n5] = (short)(0xFFFF & shortBuffer.get());
                    ++n5;
                    continue;
                }
                shortBuffer.get();
            }
        }
        return sArray;
    }

    public short[][] readPlanar16(int n, int n2, int n3, long[] lArray, long[] lArray2, long l) throws IOException {
        short[][] sArray = new short[n3][n * n2];
        int n4 = 0;
        int n5 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 * 2);
        byteBuffer.order(this.getByteOrder());
        for (int i = 0; i < lArray.length; ++i) {
            this.theChannel.position(lArray[i]);
            int n6 = (int)lArray2[i];
            if (byteBuffer.position() + n6 > sArray[n4].length * 2) {
                n6 = sArray[n4].length * 2 - byteBuffer.position();
            }
            byteBuffer.limit(byteBuffer.position() + n6);
            this.theChannel.read(byteBuffer);
            n5 = (int)((long)n5 + l);
            if (n5 < n2) continue;
            byteBuffer.flip();
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get(sArray[n4]);
            byteBuffer.clear();
            ++n4;
            n5 = 0;
        }
        return sArray;
    }

    public float[][] readPlanarFloat32(int n, int n2, int n3, long[] lArray, long[] lArray2, long l) throws IOException {
        float[][] fArray = new float[n3][n * n2];
        int n4 = 0;
        int n5 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 * 4);
        byteBuffer.order(this.getByteOrder());
        for (int i = 0; i < lArray.length; ++i) {
            this.theChannel.position(lArray[i]);
            int n6 = (int)lArray2[i];
            if (byteBuffer.position() + n6 >= fArray[n4].length * 4) {
                n6 = fArray[n4].length * 4 - byteBuffer.position();
            }
            byteBuffer.limit(byteBuffer.position() + n6);
            this.theChannel.read(byteBuffer);
            n5 = (int)((long)n5 + l);
            if (n5 < n2) continue;
            byteBuffer.flip();
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            floatBuffer.get(fArray[n4]);
            byteBuffer.clear();
            ++n4;
            n5 = 0;
        }
        return fArray;
    }

    public byte[][] readColorMap(TiffIFDEntry tiffIFDEntry) throws IOException {
        if (null == tiffIFDEntry) {
            String string = Logging.getMessage("GeotiffReader.MissingColormap");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        int n = (int)tiffIFDEntry.count / 3;
        byte[][] byArray = new byte[3][n * 2];
        this.theChannel.position(tiffIFDEntry.asLong());
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray[0]);
        this.theChannel.read(byteBuffer);
        byteBuffer = ByteBuffer.wrap(byArray[1]);
        this.theChannel.read(byteBuffer);
        byteBuffer = ByteBuffer.wrap(byArray[2]);
        this.theChannel.read(byteBuffer);
        byte[][] byArray2 = new byte[3][n];
        for (int i = 0; i < 3; ++i) {
            byteBuffer = ByteBuffer.wrap(byArray[i]);
            byteBuffer.order(this.getByteOrder());
            for (int j = 0; j < n; ++j) {
                byArray2[i][j] = (byte)(0xFF & byteBuffer.getShort());
            }
        }
        return byArray2;
    }

    public static int getUnsignedShort(ByteBuffer byteBuffer) {
        return 0xFFFF & byteBuffer.getShort();
    }

    public static long getUnsignedInt(ByteBuffer byteBuffer) {
        return 0xFFFFFFFFL & (long)byteBuffer.getInt();
    }

    public byte[] readBytes(TiffIFDEntry tiffIFDEntry) throws IOException {
        byte[] byArray = new byte[(int)tiffIFDEntry.count];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.theChannel.position(tiffIFDEntry.asOffset());
        this.theChannel.read(byteBuffer);
        return byArray;
    }

    public String readString(TiffIFDEntry tiffIFDEntry) {
        try {
            if (null != tiffIFDEntry && tiffIFDEntry.type == 2) {
                return new String(this.readBytes(tiffIFDEntry));
            }
        }
        catch (Exception exception) {
            Logging.logger().severe(exception.getMessage());
        }
        return null;
    }

    private class CodeReader {
        private int currentByte;
        private int currentBit;
        private byte[] byteBuffer;
        private int bufferLength;
        private int[] backMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127};
        private int[] frontMask = new int[]{0, 128, 192, 224, 240, 248, 252, 254};
        private boolean atEof;

        public CodeReader(byte[] byArray) {
            this.byteBuffer = byArray;
            this.currentByte = 0;
            this.currentBit = 0;
            this.bufferLength = byArray.length;
        }

        public int getCode(int n) {
            if (n < 0) {
                return 0;
            }
            if (this.atEof) {
                return -1;
            }
            int n2 = 0;
            while (n != 0 && !this.atEof) {
                int n3;
                if (n >= 8 - this.currentBit) {
                    if (this.currentBit == 0) {
                        n2 <<= 8;
                        n3 = this.byteBuffer[this.currentByte];
                        n2 += n3 < 0 ? 256 + n3 : n3;
                        n -= 8;
                        ++this.currentByte;
                    } else {
                        n2 <<= 8 - this.currentBit;
                        n2 += this.byteBuffer[this.currentByte] & this.backMask[8 - this.currentBit];
                        n -= 8 - this.currentBit;
                        this.currentBit = 0;
                        ++this.currentByte;
                    }
                } else {
                    n2 <<= n;
                    n3 = this.byteBuffer[this.currentByte];
                    n3 = n3 < 0 ? 256 + n3 : n3;
                    n2 += (n3 & 255 - this.frontMask[this.currentBit]) >> 8 - (this.currentBit + n);
                    this.currentBit += n;
                    n = 0;
                }
                if (this.currentByte != this.bufferLength) continue;
                this.atEof = true;
                return n2;
            }
            return n2;
        }
    }
}

