/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.exception.WWUnrecognizedException;
import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ShapefileUtils {
    public static Shapefile openZippedShapefile(File file) {
        Object object;
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        InputStream inputStream3 = null;
        InputStream inputStream4 = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            object = zipFile.entries();
            while (object.hasMoreElements()) {
                ZipEntry zipEntry = object.nextElement();
                if (zipEntry == null) continue;
                if (zipEntry.getName().toLowerCase().endsWith(".shp")) {
                    inputStream = zipFile.getInputStream(zipEntry);
                    continue;
                }
                if (zipEntry.getName().toLowerCase().endsWith(".shx")) {
                    inputStream2 = zipFile.getInputStream(zipEntry);
                    continue;
                }
                if (zipEntry.getName().toLowerCase().endsWith(".dbf")) {
                    inputStream3 = zipFile.getInputStream(zipEntry);
                    continue;
                }
                if (!zipEntry.getName().toLowerCase().endsWith(".prj")) continue;
                inputStream4 = zipFile.getInputStream(zipEntry);
            }
        }
        catch (Exception exception) {
            throw new WWRuntimeException(Logging.getMessage("generic.ExceptionAttemptingToReadFrom", file.getPath()), exception);
        }
        if (inputStream == null) {
            object = Logging.getMessage("SHP.UnrecognizedShapefile", file.getPath());
            Logging.logger().severe((String)object);
            throw new WWUnrecognizedException((String)object);
        }
        return new Shapefile(inputStream, inputStream2, inputStream3, inputStream4);
    }

    public static int[] readIntArray(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = byteBuffer.getInt();
        }
        return nArray;
    }

    public static double[] readDoubleArray(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = byteBuffer.getDouble();
        }
        return dArray;
    }

    public static Double extractHeightAttribute(ShapefileRecord shapefileRecord) {
        if (shapefileRecord.getAttributes() == null) {
            return null;
        }
        for (Map.Entry<String, Object> entry : shapefileRecord.getAttributes().getEntries()) {
            String string = entry.getKey().trim().toLowerCase();
            if (!string.equals("height") && !string.equals("hgt")) continue;
            Object object = entry.getValue();
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            if (!(object instanceof String)) continue;
            return WWUtil.convertStringToDouble(object.toString());
        }
        return null;
    }
}

