/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NITFSRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NITFSSegmentType;
import gov.nasa.worldwind.formats.rpf.RPFFile;
import gov.nasa.worldwind.formats.rpf.RPFFileComponents;
import gov.nasa.worldwind.formats.rpf.RPFFrameFileIndexSection;
import gov.nasa.worldwind.formats.rpf.RPFHeaderSection;
import gov.nasa.worldwind.formats.rpf.RPFUserDefinedHeaderSegment;
import java.io.File;
import java.io.IOException;

public class RPFTOCFile
extends RPFFile {
    private RPFFileComponents rpfFileComponents;

    public RPFHeaderSection getHeaderSection() {
        return null != this.rpfFileComponents ? this.rpfFileComponents.getRPFHeaderSection() : null;
    }

    public RPFFrameFileIndexSection getFrameFileIndexSection() {
        return null != this.rpfFileComponents ? this.rpfFileComponents.getRPFFrameFileIndexSection() : null;
    }

    public RPFFileComponents getRPFFileComponents() {
        return this.rpfFileComponents;
    }

    protected RPFTOCFile(File file) throws IOException, NITFSRuntimeException {
        super(file);
        RPFUserDefinedHeaderSegment rPFUserDefinedHeaderSegment = (RPFUserDefinedHeaderSegment)this.getNITFSSegment(NITFSSegmentType.USER_DEFINED_HEADER_SEGMENT);
        if (null == rPFUserDefinedHeaderSegment) {
            throw new NITFSRuntimeException("NITFSReader.UserDefinedHeaderSegmentWasNotFound");
        }
        this.rpfFileComponents = rPFUserDefinedHeaderSegment.getRPFFileComponents();
        if (null == this.rpfFileComponents) {
            throw new NITFSRuntimeException("NITFSReader.RPFFileComponents.Were.Not.Found.In.UserDefinedHeaderSegment");
        }
    }

    public static RPFTOCFile load(File file) throws IOException {
        return new RPFTOCFile(file);
    }
}

