/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.AbstractDataStoreProducer;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.dds.DDSCompressor;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.w3c.dom.Document;

public class WWDotNetLayerSetConverter
extends AbstractDataStoreProducer {
    protected static final String DEFAULT_IMAGE_FORMAT = "image/png";
    protected static final String DEFAULT_TEXTURE_FORMAT = "image/dds";

    @Override
    public String getDataSourceDescription() {
        return Logging.getMessage("WWDotNetLayerSetConverter.Description");
    }

    @Override
    public void removeProductionState() {
        List<AbstractDataStoreProducer.SourceInfo> list = this.getDataSourceList();
        AVList aVList = this.getStoreParameters();
        for (AbstractDataStoreProducer.SourceInfo sourceInfo : list) {
            this.removeLayerSet(sourceInfo.source, aVList);
        }
    }

    @Override
    protected void doStartProduction(AVList aVList) throws Exception {
        this.getProductionResultsList().clear();
        List<AbstractDataStoreProducer.SourceInfo> list = this.getDataSourceList();
        ProductionState productionState = new ProductionState();
        this.initProductionParameters(aVList, productionState);
        this.setProgressParameters(list, productionState);
        if (this.isStopped()) {
            return;
        }
        for (AbstractDataStoreProducer.SourceInfo sourceInfo : list) {
            if (this.isStopped()) {
                return;
            }
            ++productionState.curSource;
            this.convertLayerSet(sourceInfo.source, productionState);
        }
    }

    protected void initProductionParameters(AVList aVList, ProductionState productionState) {
        String string;
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") != null && (string = WWIO.makeMimeTypeForSuffix(aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey").toString())) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", string);
            aVList.setValue("gov.nasa.worldwind.avkey.AvailableImageFormats", new String[]{string});
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", DEFAULT_IMAGE_FORMAT);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.AvailableImageFormats") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.AvailableImageFormats", new String[]{aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat").toString()});
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", WWIO.makeSuffixForMimeType(aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat").toString()));
        }
        productionState.productionParams = aVList;
    }

    @Override
    protected String validateProductionParameters(AVList aVList) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        if (object == null || !(object instanceof String) || ((String)object).length() < 1) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.fileStoreLocation"));
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey")) != null && !(object instanceof String)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.fileStoreFolder"));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return Logging.getMessage("DataStoreProducer.InvalidDataStoreParamters", stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String validateDataSource(Object object, AVList aVList) {
        File file = this.getSourceConfigFile(object);
        if (file == null) {
            return Logging.getMessage("WWDotNetLayerSetConverter.NoSourceLocation");
        }
        XMLEventReader xMLEventReader = null;
        try {
            xMLEventReader = WWXML.openEventReader(file);
            if (xMLEventReader == null) {
                String string = Logging.getMessage("WWDotNetLayerSetConverter.CannotReadLayerSetConfigFile", file);
                return string;
            }
            StartElement startElement = WWXML.nextStartElementEvent(xMLEventReader);
            if (startElement == null || !DataConfigurationUtils.isWWDotNetLayerSetConfigEvent(startElement)) {
                String string = Logging.getMessage("WWDotNetLayerSetConverter.FileNotLayerSet", file);
                return string;
            }
        }
        catch (Exception exception) {
            Logging.logger().fine(Logging.getMessage("generic.ExceptionAttemptingToParseXml", file));
            String string = Logging.getMessage("WWDotNetLayerSetConverter.CannotReadLayerSetConfigFile", file);
            return string;
        }
        finally {
            WWXML.closeEventReader(xMLEventReader, file.getPath());
        }
        return null;
    }

    protected Document readLayerSetDocument(Object object) {
        Document document = null;
        try {
            document = WWXML.openDocument(object);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToParseXml", object);
            Logging.logger().fine(string);
        }
        if (document == null) {
            String string = Logging.getMessage("WWDotNetLayerSetConverter.CannotReadLayerSetConfigFile", object);
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        if (!DataConfigurationUtils.isWWDotNetLayerSetConfigDocument(document.getDocumentElement())) {
            String string = Logging.getMessage("WWDotNetLayerSetConverter.FileNotLayerSet", object);
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        return document;
    }

    protected void convertLayerSet(Object object, ProductionState productionState) throws Exception {
        Object object2;
        File file = this.getSourceConfigFile(object);
        if (file == null) {
            String string = Logging.getMessage("WWDotNetLayerSetConverter.NoSourceLocation");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            String string = Logging.getMessage("WWDotNetLayerSetConverter.FileWithoutParent", file);
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        File file3 = this.getDestConfigFile(productionState.productionParams);
        if (file3 == null) {
            String string = Logging.getMessage("WWDotNetLayerSetConverter.NoInstallLocation", file);
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        File file4 = file3.getParentFile();
        if (file4 == null) {
            String string = Logging.getMessage("WWDotNetLayerSetConverter.FileWithoutParent", file3);
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        if (WWIO.isAncestorOf(file2, file4) || WWIO.isAncestorOf(file4, file2)) {
            String string = Logging.getMessage("WWDotNetLayerSetConverter.CannotInstallToSelf", file2, file4);
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        if (this.isStopped()) {
            return;
        }
        Document document = this.readLayerSetDocument(file);
        try {
            object2 = productionState.productionParams.getStringValue("gov.nasa.worldwind.avkey.ImageFormat");
            productionState.numSourceFiles[productionState.curSource] = this.countWWDotNetFiles(file2);
            this.copyWWDotNetDiretory(file2, file4, (String)object2, productionState);
        }
        catch (Exception exception) {
            WWIO.deleteDirectory(file4);
            String string = Logging.getMessage("WWDotNetLayerSetConverter.CannotInstallLayerSet", file);
            Logging.logger().log(Level.SEVERE, string, exception);
            throw new WWRuntimeException(string);
        }
        if (this.isStopped()) {
            return;
        }
        try {
            object2 = this.createDestConfigDoc(document, productionState.productionParams);
            WWXML.saveDocumentToFile((Document)object2, file3.getAbsolutePath());
        }
        catch (Exception exception) {
            WWIO.deleteDirectory(file4);
            file3.delete();
            String string = Logging.getMessage("WWDotNetLayerSetConverter.CannotWriteLayerConfigFile", file3);
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        if (this.isStopped()) {
            return;
        }
        this.getProductionResultsList().add(object2);
    }

    protected File getSourceConfigFile(Object object) {
        if (object instanceof File) {
            return (File)object;
        }
        if (object instanceof String && !WWUtil.isEmpty(object)) {
            return new File((String)object);
        }
        return null;
    }

    protected File getDestConfigFile(AVList aVList) {
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        if (string != null) {
            string = WWIO.stripTrailingSeparator(string);
        }
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        String string2 = DataConfigurationUtils.getDataConfigFilename(aVList, ".xml");
        if (string2 != null) {
            string2 = WWIO.stripLeadingSeparator(string2);
        }
        if (WWUtil.isEmpty(string2)) {
            return null;
        }
        return new File(string + File.separator + string2);
    }

    protected Document createDestConfigDoc(Document document, AVList aVList) {
        AVListImpl aVListImpl = new AVListImpl();
        DataConfigurationUtils.getWWDotNetLayerSetConfigParams(document.getDocumentElement(), aVListImpl);
        if (aVList.getValue("gov.nasa.worldwind.avkey.DisplayName") != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DisplayName", aVList.getValue("gov.nasa.worldwind.avkey.DisplayName"));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey") != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey"));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat") != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ImageFormat", aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat"));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.AvailableImageFormats") != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.AvailableImageFormats", aVList.getValue("gov.nasa.worldwind.avkey.AvailableImageFormats"));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey"));
        }
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TextureFormat", DEFAULT_TEXTURE_FORMAT);
        return BasicTiledImageLayer.createTiledImageLayerConfigDocument(aVListImpl);
    }

    private void copyWWDotNetDiretory(File file, File file2, String string, ProductionState productionState) throws IOException {
        if (this.isStopped()) {
            return;
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file2.exists()) {
            String string2 = Logging.getMessage("generic.CannotCreateFile", file2);
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File object : fileArray) {
            if (object == null || object.isHidden()) continue;
            if (object.isDirectory()) {
                arrayList2.add(object);
                continue;
            }
            arrayList.add(object);
        }
        for (File file3 : arrayList) {
            if (this.isStopped()) break;
            if (!WWDotNetLayerSetConverter.isWWDotNetFile(file3)) continue;
            File file4 = WWDotNetLayerSetConverter.makeWWJavaFile(file2, file3.getName(), string);
            this.installWWDotNetFile(file3, file4, productionState);
            if (file4.exists()) continue;
            String string2 = Logging.getMessage("generic.CannotCreateFile", file4);
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        for (File file5 : arrayList2) {
            if (this.isStopped()) break;
            if (!WWDotNetLayerSetConverter.isWWDotNetDirectory(file5)) continue;
            File file6 = WWDotNetLayerSetConverter.makeWWJavaDirectory(file2, file5.getName());
            this.copyWWDotNetDiretory(file5, file6, string, productionState);
        }
    }

    private void installWWDotNetFile(File file, File file2, ProductionState productionState) throws IOException {
        String string;
        if (file2.exists() && file.lastModified() >= file2.lastModified() && file.length() == file2.length()) {
            return;
        }
        String string2 = WWIO.getSuffix(file.getName());
        if (string2.equalsIgnoreCase(string = WWIO.getSuffix(file2.getName()))) {
            WWIO.copyFile(file, file2);
        } else if (string.equalsIgnoreCase("dds")) {
            ByteBuffer byteBuffer = DDSCompressor.compressImageFile(file);
            WWIO.saveBuffer(byteBuffer, file2);
        } else {
            BufferedImage bufferedImage = ImageIO.read(file);
            ImageIO.write((RenderedImage)bufferedImage, string, file2);
        }
        this.updateProgress(productionState);
    }

    private static File makeWWJavaDirectory(File file, String string) {
        return new File(file, WWIO.stripLeadingZeros(string));
    }

    private static File makeWWJavaFile(File file, String string, String string2) {
        String[] stringArray = string.split("[._]");
        if (stringArray == null || stringArray.length < 3 || stringArray[0].length() < 1 || stringArray[1].length() < 1) {
            return new File(file, string);
        }
        if (string2 != null) {
            stringArray[2] = WWIO.makeSuffixForMimeType(string2);
        } else if (stringArray[2].length() > 1) {
            stringArray[2] = "." + stringArray[2];
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(WWIO.stripLeadingZeros(stringArray[0])).append("_").append(WWIO.stripLeadingZeros(stringArray[1]));
        stringBuilder.append(stringArray[2]);
        return new File(file, stringBuilder.toString());
    }

    private static boolean isWWDotNetDirectory(File file) {
        String string = "\\d+";
        return file.getName().matches(string);
    }

    private static boolean isWWDotNetFile(File file) {
        String string = "\\d+[_]\\d+[.]\\w+";
        return file.getName().matches(string);
    }

    private int countWWDotNetFiles(File file) {
        int n = 0;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return n;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file2 : fileArray) {
            if (file2 == null || file2.isHidden()) continue;
            if (file2.isDirectory()) {
                arrayList2.add(file2);
                continue;
            }
            arrayList.add(file2);
        }
        for (File file3 : arrayList) {
            if (!WWDotNetLayerSetConverter.isWWDotNetFile(file3)) continue;
            ++n;
        }
        for (File file4 : arrayList2) {
            if (!WWDotNetLayerSetConverter.isWWDotNetDirectory(file4)) continue;
            n += this.countWWDotNetFiles(file4);
        }
        return n;
    }

    protected void setProgressParameters(Iterable<?> iterable, ProductionState productionState) {
        int n = 0;
        for (Object obj : iterable) {
            ++n;
        }
        productionState.numSources = n;
        productionState.curSource = -1;
        productionState.numSourceFiles = new int[n];
        productionState.numInstalledFiles = new int[n];
    }

    private void updateProgress(ProductionState productionState) {
        double d = this.computeProgress(productionState);
        int n = productionState.curSource;
        productionState.numInstalledFiles[n] = productionState.numInstalledFiles[n] + 1;
        double d2 = this.computeProgress(productionState);
        this.firePropertyChange("gov.nasa.worldwind.avkey.Progress", d, d2);
    }

    private double computeProgress(ProductionState productionState) {
        double d = 0.0;
        for (int i = 0; i <= productionState.curSource; ++i) {
            d += (double)productionState.numInstalledFiles[i] / (double)productionState.numSourceFiles[i] * (1.0 / (double)productionState.numSources);
        }
        return d;
    }

    protected void removeLayerSet(Object object, AVList aVList) {
        File file = this.getSourceConfigFile(object);
        if (file == null) {
            String string = Logging.getMessage("WWDotNetLayerSetConverter.NoSourceLocation");
            Logging.logger().warning(string);
            return;
        }
        File file2 = this.getDestConfigFile(aVList);
        if (file2 == null) {
            String string = Logging.getMessage("WWDotNetLayerSetConverter.NoInstallLocation", file);
            Logging.logger().warning(string);
            return;
        }
        File file3 = file2.getParentFile();
        if (file3 == null) {
            String string = Logging.getMessage("WWDotNetLayerSetConverter.FileWithoutParent", file2);
            Logging.logger().warning(string);
            return;
        }
        try {
            WWIO.deleteDirectory(file3);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("WWDotNetLayerSetConverter.ExceptionRemovingProductionState", file);
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    protected static class ProductionState {
        AVList productionParams;
        int numSources;
        int curSource;
        int[] numSourceFiles;
        int[] numInstalledFiles;

        protected ProductionState() {
        }
    }
}

