/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.data.AbstractDataStoreProducer;
import gov.nasa.worldwind.data.BasicDataRasterReaderFactory;
import gov.nasa.worldwind.data.CachedDataRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.data.DataRasterWriter;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.w3c.dom.Document;

public abstract class TiledRasterProducer
extends AbstractDataStoreProducer {
    private static final long DEFAULT_TILED_RASTER_PRODUCER_CACHE_SIZE = 300000000L;
    private static final int DEFAULT_TILED_RASTER_PRODUCER_LARGE_DATASET_THRESHOLD = 3000;
    private static final int DEFAULT_WRITE_THREAD_POOL_SIZE = 2;
    private static final int DEFAULT_TILE_WIDTH_AND_HEIGHT = 512;
    private static final int DEFAULT_SINGLE_LEVEL_TILE_WIDTH_AND_HEIGHT = 512;
    private static final double DEFAULT_LEVEL_ZERO_TILE_DELTA = 36.0;
    private List<DataRaster> dataRasterList = new ArrayList<DataRaster>();
    private MemoryCache rasterCache;
    private final ExecutorService tileWriteService;
    private final Semaphore tileWriteSemaphore;
    private final Object fileLock = new Object();
    private int tile;
    private int tileCount;
    private DataRasterReaderFactory readerFactory;

    public TiledRasterProducer(MemoryCache memoryCache, int n) {
        if (memoryCache == null) {
            String string = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "writeThreadPoolSize < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.rasterCache = memoryCache;
        this.tileWriteService = this.createDefaultTileWriteService(n);
        this.tileWriteSemaphore = new Semaphore(n, true);
        try {
            this.readerFactory = (DataRasterReaderFactory)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.DataRasterReaderFactoryClassName");
        }
        catch (Exception exception) {
            this.readerFactory = new BasicDataRasterReaderFactory();
        }
    }

    public TiledRasterProducer() {
        this(TiledRasterProducer.createDefaultCache(), 2);
    }

    public Iterable<DataRaster> getDataRasters() {
        return this.dataRasterList;
    }

    protected DataRasterReaderFactory getReaderFactory() {
        return this.readerFactory;
    }

    @Override
    public String getDataSourceDescription() {
        DataRasterReader[] dataRasterReaderArray = this.getDataRasterReaders();
        if (dataRasterReaderArray == null || dataRasterReaderArray.length < 1) {
            return "";
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (DataRasterReader dataRasterReader : dataRasterReaderArray) {
            String string = dataRasterReader.getDescription();
            String[] stringArray = dataRasterReader.getSuffixes();
            if (stringArray != null && stringArray.length > 0) {
                treeSet.addAll(Arrays.asList(stringArray));
                continue;
            }
            treeSet2.add(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : treeSet) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("*.").append(string);
        }
        for (String string : treeSet2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public void removeProductionState() {
        File file = this.installLocationFor(this.getStoreParameters());
        if (file == null || !file.exists()) {
            String string = Logging.getMessage("TiledRasterProducer.NoInstallLocation", this.getStoreParameters().getValue("gov.nasa.worldwind.avkey.DatasetNameKey"));
            Logging.logger().warning(string);
            return;
        }
        try {
            WWIO.deleteDirectory(file);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("TiledRasterProducer.ExceptionRemovingProductionState", this.getStoreParameters().getValue("gov.nasa.worldwind.avkey.DatasetNameKey"));
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    protected abstract DataRaster createDataRaster(int var1, int var2, Sector var3, AVList var4);

    protected abstract DataRasterReader[] getDataRasterReaders();

    protected abstract DataRasterWriter[] getDataRasterWriters();

    protected MemoryCache getCache() {
        return this.rasterCache;
    }

    protected ExecutorService getTileWriteService() {
        return this.tileWriteService;
    }

    protected Semaphore getTileWriteSemaphore() {
        return this.tileWriteSemaphore;
    }

    @Override
    protected void doStartProduction(AVList aVList) throws Exception {
        this.productionParams = aVList.copy();
        this.initProductionParameters(this.productionParams);
        this.assembleDataRasters();
        this.initLevelSetParameters(this.productionParams);
        LevelSet levelSet = new LevelSet(this.productionParams);
        this.installLevelSet(levelSet, this.productionParams);
        this.waitForInstallTileTasks();
        this.getCache().clear();
        this.installConfigFile(this.productionParams);
    }

    @Override
    protected String validateProductionParameters(AVList aVList) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        if (object == null || !(object instanceof String) || ((String)object).length() < 1) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.fileStoreLocation"));
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey")) == null || !(object instanceof String) || ((String)object).length() == 0) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.fileStoreFolder"));
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey")) == null || !(object instanceof String) || ((String)object).length() < 1) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.datasetName"));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return Logging.getMessage("DataStoreProducer.InvalidDataStoreParamters", stringBuilder.toString());
    }

    protected File installLocationFor(AVList aVList) {
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        String string2 = aVList.getStringValue("gov.nasa.worldwind.avkey.DataCacheNameKey");
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = WWIO.appendPathPart(string, string2);
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        return new File(string3);
    }

    protected abstract void initProductionParameters(AVList var1);

    protected void initLevelSetParameters(AVList aVList) {
        LatLon latLon;
        LatLon latLon2;
        Integer n;
        Integer n2;
        Integer n3;
        int n4 = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.TiledRasterProducerLargeDatasetThreshold", 3000);
        boolean bl = this.isDataSetLarge(this.dataRasterList, n4);
        Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (sector == null) {
            sector = this.computeBoundingSector(this.dataRasterList);
            if (sector != null) {
                sector = sector.intersection(Sector.FULL_SPHERE);
            }
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
        if ((n3 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey")) == null) {
            n3 = bl ? 512 : 512;
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", n3);
        }
        if ((n2 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey")) == null) {
            n2 = bl ? 512 : 512;
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", n2);
        }
        LatLon latLon3 = this.computeRasterTileDelta(n3, n2, this.dataRasterList);
        LatLon latLon4 = this.computeDesiredTileDelta(sector);
        Integer n5 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.NumLevels");
        if (n5 == null) {
            n5 = bl ? this.computeNumLevels(latLon4, latLon3) : 1;
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", n5);
        }
        if ((n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels")) == null) {
            n = 0;
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", n);
        }
        if ((latLon2 = (LatLon)aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta")) == null) {
            double d = Math.pow(2.0, n5 - 1);
            latLon2 = LatLon.fromDegrees(d * latLon3.getLatitude().degrees, d * latLon3.getLongitude().degrees);
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", latLon2);
        }
        if ((latLon = (LatLon)aVList.getValue("gov.nasa.worldwind.avkey.TileOrigin")) == null) {
            latLon = new LatLon(sector.getMinLatitude(), sector.getMinLongitude());
            aVList.setValue("gov.nasa.worldwind.avkey.TileOrigin", latLon);
        }
        if (!this.isWithinLatLonLimits(sector, latLon2, latLon)) {
            String string = "TiledRasterProducer: native tiling is outside lat/lon limits. Falling back to default tiling.";
            Logging.logger().warning(string);
            latLon2 = LatLon.fromDegrees(36.0, 36.0);
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", latLon2);
            latLon = new LatLon(Angle.NEG90, Angle.NEG180);
            aVList.setValue("gov.nasa.worldwind.avkey.TileOrigin", latLon);
            n5 = this.computeNumLevels(latLon2, latLon3);
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", n5);
            int n6 = bl ? this.computeNumLevels(latLon4, latLon3) : 1;
            n = n5 > n6 ? n5 - n6 : 0;
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", n);
        }
    }

    protected boolean isDataSetLarge(Iterable<? extends DataRaster> iterable, int n) {
        Sector sector = this.computeBoundingSector(iterable);
        LatLon latLon = this.computeSmallestPixelSize(iterable);
        int n2 = (int)Math.ceil(sector.getDeltaLonDegrees() / latLon.getLongitude().degrees);
        int n3 = (int)Math.ceil(sector.getDeltaLatDegrees() / latLon.getLatitude().degrees);
        return n2 >= n || n3 >= n;
    }

    protected boolean isWithinLatLonLimits(Sector sector, LatLon latLon, LatLon latLon2) {
        double d = Math.floor((sector.getMinLatitude().degrees - latLon2.getLatitude().degrees) / latLon.getLatitude().degrees);
        d = latLon2.getLatitude().degrees + d * latLon.getLatitude().degrees;
        double d2 = Math.ceil((sector.getMaxLatitude().degrees - latLon2.getLatitude().degrees) / latLon.getLatitude().degrees);
        d2 = latLon2.getLatitude().degrees + d2 * latLon.getLatitude().degrees;
        double d3 = Math.floor((sector.getMinLongitude().degrees - latLon2.getLongitude().degrees) / latLon.getLongitude().degrees);
        d3 = latLon2.getLongitude().degrees + d3 * latLon.getLongitude().degrees;
        double d4 = Math.ceil((sector.getMaxLongitude().degrees - latLon2.getLongitude().degrees) / latLon.getLongitude().degrees);
        d4 = latLon2.getLongitude().degrees + d4 * latLon.getLongitude().degrees;
        return Sector.fromDegrees(d, d2, d3, d4).isWithinLatLonLimits();
    }

    protected Sector computeBoundingSector(Iterable<? extends DataRaster> iterable) {
        Sector sector = null;
        for (DataRaster dataRaster : iterable) {
            sector = sector != null ? dataRaster.getSector().union(sector) : dataRaster.getSector();
        }
        return sector;
    }

    protected LatLon computeRasterTileDelta(int n, int n2, Iterable<? extends DataRaster> iterable) {
        LatLon latLon = this.computeSmallestPixelSize(iterable);
        double d = (double)n2 * latLon.getLatitude().degrees;
        double d2 = (double)n * latLon.getLongitude().degrees;
        return LatLon.fromDegrees(d, d2);
    }

    protected LatLon computeDesiredTileDelta(Sector sector) {
        double d = Math.min(sector.getDeltaLatDegrees(), 36.0);
        double d2 = Math.min(sector.getDeltaLonDegrees(), 36.0);
        return LatLon.fromDegrees(d, d2);
    }

    protected LatLon computeRasterPixelSize(DataRaster dataRaster) {
        return LatLon.fromDegrees(dataRaster.getSector().getDeltaLatDegrees() / (double)dataRaster.getHeight(), dataRaster.getSector().getDeltaLonDegrees() / (double)dataRaster.getWidth());
    }

    protected LatLon computeSmallestPixelSize(Iterable<? extends DataRaster> iterable) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        for (DataRaster dataRaster : iterable) {
            LatLon latLon = this.computeRasterPixelSize(dataRaster);
            if (d > latLon.getLatitude().degrees) {
                d = latLon.getLatitude().degrees;
            }
            if (!(d2 > latLon.getLongitude().degrees)) continue;
            d2 = latLon.getLongitude().degrees;
        }
        return LatLon.fromDegrees(d, d2);
    }

    protected int computeNumLevels(LatLon latLon, LatLon latLon2) {
        double d;
        double d2 = WWMath.logBase2(latLon.getLatitude().getDegrees()) - WWMath.logBase2(latLon2.getLatitude().getDegrees());
        int n = (int)Math.ceil(Math.max(d2, d = WWMath.logBase2(latLon.getLongitude().getDegrees()) - WWMath.logBase2(latLon2.getLongitude().getDegrees())));
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    protected void assembleDataRasters() throws Exception {
        if (this.isStopped()) {
            return;
        }
        for (AbstractDataStoreProducer.SourceInfo sourceInfo : this.getDataSourceList()) {
            if (this.isStopped()) break;
            Thread.sleep(0L);
            this.assembleDataSource(sourceInfo.source, sourceInfo);
        }
    }

    protected void assembleDataSource(Object object, AVList aVList) throws Exception {
        if (object instanceof DataRaster) {
            this.dataRasterList.add((DataRaster)object);
        } else {
            DataRasterReader dataRasterReader = this.readerFactory.findReaderFor(object, aVList, this.getDataRasterReaders());
            this.dataRasterList.add(new CachedDataRaster(object, aVList, dataRasterReader, this.getCache()));
        }
    }

    protected static MemoryCache createDefaultCache() {
        long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.TiledRasterProducerCacheSize", 300000000L);
        return new BasicMemoryCache((long)(0.8 * (double)l), l);
    }

    protected void installLevelSet(LevelSet levelSet, AVList aVList) throws IOException {
        if (this.isStopped()) {
            return;
        }
        this.calculateTileCount(levelSet, aVList);
        this.startProgress();
        Sector sector = levelSet.getSector();
        gov.nasa.worldwind.util.Level level = levelSet.getFirstLevel();
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = levelSet.getTileOrigin().getLatitude();
        Angle angle4 = levelSet.getTileOrigin().getLongitude();
        int n = Tile.computeRow(angle, sector.getMinLatitude(), angle3);
        int n2 = Tile.computeColumn(angle2, sector.getMinLongitude(), angle4);
        int n3 = Tile.computeRow(angle, sector.getMaxLatitude(), angle3);
        int n4 = Tile.computeColumn(angle2, sector.getMaxLongitude(), angle4);
        Angle angle5 = Tile.computeRowLatitude(n, angle, angle3);
        block0: for (int i = n; i <= n3; ++i) {
            Angle angle6 = angle5.add(angle);
            Angle angle7 = Tile.computeColumnLongitude(n2, angle2, angle4);
            for (int j = n2; j <= n4; ++j) {
                Thread.yield();
                if (this.isStopped()) break block0;
                Angle angle8 = angle7.add(angle2);
                Tile tile = new Tile(new Sector(angle5, angle6, angle7, angle8), level, i, j);
                DataRaster dataRaster = this.createTileRaster(levelSet, tile, aVList);
                if (dataRaster != null) {
                    this.installTileRasterLater(levelSet, tile, dataRaster, aVList);
                }
                angle7 = angle8;
            }
            angle5 = angle6;
        }
    }

    protected DataRaster createTileRaster(LevelSet levelSet, Tile tile, AVList aVList) throws IOException {
        if (this.isStopped()) {
            return null;
        }
        DataRaster dataRaster = this.isFinalLevel(levelSet, tile.getLevelNumber(), aVList) ? this.drawDataSources(levelSet, tile, this.dataRasterList, aVList) : this.drawDescendants(levelSet, tile, aVList);
        this.updateProgress();
        return dataRaster;
    }

    protected DataRaster drawDataSources(LevelSet levelSet, Tile tile, Iterable<DataRaster> iterable, AVList aVList) throws IOException {
        DataRaster dataRaster = null;
        ArrayList<DataRaster> arrayList = new ArrayList<DataRaster>();
        for (DataRaster dataRaster2 : iterable) {
            if (!dataRaster2.getSector().intersects(tile.getSector()) || !dataRaster2.getSector().intersects(levelSet.getSector())) continue;
            arrayList.add(dataRaster2);
        }
        if (!arrayList.isEmpty() && !tile.getLevel().isEmpty()) {
            dataRaster = this.createDataRaster(tile.getLevel().getTileWidth(), tile.getLevel().getTileHeight(), tile.getSector(), aVList);
            for (DataRaster dataRaster2 : arrayList) {
                dataRaster2.drawOnTo(dataRaster);
            }
        }
        arrayList.clear();
        arrayList = null;
        return dataRaster;
    }

    protected DataRaster drawDescendants(LevelSet levelSet, Tile tile, AVList aVList) throws IOException {
        int n;
        DataRaster dataRaster = null;
        boolean bl = false;
        Tile[] tileArray = this.createSubTiles(tile, levelSet.getLevel(tile.getLevelNumber() + 1));
        DataRaster[] dataRasterArray = new DataRaster[tileArray.length];
        for (n = 0; n < tileArray.length; ++n) {
            DataRaster dataRaster2;
            if (!tileArray[n].getSector().intersects(levelSet.getSector()) || (dataRaster2 = this.createTileRaster(levelSet, tileArray[n], aVList)) == null) continue;
            dataRasterArray[n] = dataRaster2;
            bl = true;
        }
        if (this.isStopped()) {
            return null;
        }
        if (bl && !tile.getLevel().isEmpty()) {
            dataRaster = this.createDataRaster(tile.getLevel().getTileWidth(), tile.getLevel().getTileHeight(), tile.getSector(), aVList);
            for (n = 0; n < tileArray.length; ++n) {
                if (dataRasterArray[n] == null) continue;
                dataRasterArray[n].drawOnTo(dataRaster);
                this.installTileRasterLater(levelSet, tileArray[n], dataRasterArray[n], aVList);
            }
        }
        for (n = 0; n < tileArray.length; ++n) {
            tileArray[n] = null;
            dataRasterArray[n] = null;
        }
        tileArray = null;
        dataRasterArray = null;
        return dataRaster;
    }

    protected Tile[] createSubTiles(Tile tile, gov.nasa.worldwind.util.Level level) {
        Angle angle = tile.getSector().getMinLatitude();
        Angle angle2 = tile.getSector().getMaxLatitude();
        Angle angle3 = Angle.midAngle(angle, angle2);
        Angle angle4 = tile.getSector().getMinLongitude();
        Angle angle5 = tile.getSector().getMaxLongitude();
        Angle angle6 = Angle.midAngle(angle4, angle5);
        int n = tile.getRow();
        int n2 = tile.getColumn();
        Tile[] tileArray = new Tile[]{new Tile(new Sector(angle, angle3, angle4, angle6), level, 2 * n, 2 * n2), new Tile(new Sector(angle, angle3, angle6, angle5), level, 2 * n, 2 * n2 + 1), new Tile(new Sector(angle3, angle2, angle6, angle5), level, 2 * n + 1, 2 * n2 + 1), new Tile(new Sector(angle3, angle2, angle4, angle6), level, 2 * n + 1, 2 * n2)};
        return tileArray;
    }

    protected boolean isFinalLevel(LevelSet levelSet, int n, AVList aVList) {
        if (levelSet.isFinalLevel(n)) {
            return true;
        }
        int n2 = levelSet.getLastLevel().getLevelNumber();
        int n3 = this.extractMaxLevelLimit(aVList, n2);
        return n >= n3;
    }

    protected int extractMaxLevelLimit(AVList aVList, int n) {
        if (null != aVList && aVList.hasKey("gov.nasa.worldwind.avkey.TiledRasterProducer.LimitMaxLevel")) {
            Object object = aVList.getValue("gov.nasa.worldwind.avkey.TiledRasterProducer.LimitMaxLevel");
            if (object instanceof Integer) {
                int n2 = (Integer)object;
                return n2 <= n ? n2 : n;
            }
            if (object instanceof String) {
                String string = (String)object;
                if ("Auto".equalsIgnoreCase(string)) {
                    return (int)Math.floor(0.5 * (double)n);
                }
                if (string.endsWith("%")) {
                    try {
                        float f = Float.parseFloat(string.substring(0, string.length() - 1));
                        int n3 = (int)Math.floor((double)f * (double)n / 100.0);
                        return n3 <= n ? n3 : n;
                    }
                    catch (Throwable throwable) {
                        Logging.logger().finest(WWUtil.extractExceptionReason(throwable));
                    }
                } else {
                    try {
                        int n4 = Integer.parseInt(string);
                        return n4 <= n ? n4 : n;
                    }
                    catch (Throwable throwable) {
                        Logging.logger().finest(WWUtil.extractExceptionReason(throwable));
                    }
                }
            }
        }
        return n;
    }

    protected ExecutorService createDefaultTileWriteService(int n) {
        return new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue()){

            @Override
            protected void afterExecute(Runnable runnable, Throwable throwable) {
                super.afterExecute(runnable, throwable);
                TiledRasterProducer.this.installTileRasterComplete();
            }
        };
    }

    protected void installTileRasterLater(LevelSet levelSet, final Tile tile, final DataRaster dataRaster, final AVList aVList) {
        this.getTileWriteSemaphore().acquireUninterruptibly();
        this.getTileWriteService().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TiledRasterProducer.this.installTileRaster(tile, dataRaster, aVList);
                    if (dataRaster instanceof Disposable) {
                        dataRaster.dispose();
                    }
                }
                catch (Throwable throwable) {
                    String string = Logging.getMessage("generic.ExceptionWhileWriting", tile);
                    Logging.logger().log(Level.SEVERE, string, throwable);
                }
            }
        });
    }

    protected void installTileRasterComplete() {
        this.getTileWriteSemaphore().release();
    }

    protected void waitForInstallTileTasks() {
        try {
            ExecutorService executorService = this.getTileWriteService();
            executorService.shutdown();
            while (!executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                Thread.sleep(5L);
            }
        }
        catch (InterruptedException interruptedException) {
            String string = Logging.getMessage("generic.interrupted", this.getClass().getName(), "waitForInstallTileTasks()");
            Logging.logger().finest(string);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installTileRaster(Tile tile, DataRaster dataRaster, AVList aVList) throws IOException {
        Object object;
        DataRasterWriter[] dataRasterWriterArray;
        Object object2 = this.installLocationForTile(aVList, tile);
        if (!(object2 instanceof File)) {
            String string = object2.toString();
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File file = (File)object2;
        Object object3 = this.fileLock;
        synchronized (object3) {
            dataRasterWriterArray = file.getParentFile();
            if (!dataRasterWriterArray.exists() && !dataRasterWriterArray.mkdirs()) {
                object = Logging.getMessage("generic.CannotCreateFile", new Object[]{dataRasterWriterArray});
                Logging.logger().warning((String)object);
            }
        }
        object3 = aVList.getStringValue("gov.nasa.worldwind.avkey.FormatSuffixKey");
        dataRasterWriterArray = this.getDataRasterWriters();
        object = this.findWriterFor(dataRaster, (String)object3, file, dataRasterWriterArray);
        if (object instanceof DataRasterWriter) {
            try {
                ((DataRasterWriter)object).write(dataRaster, (String)object3, file);
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("generic.ExceptionWhileWriting", file);
                Logging.logger().log(Level.SEVERE, string, iOException);
            }
        }
    }

    protected Object installLocationForTile(AVList aVList, Tile tile) {
        String string = null;
        String string2 = aVList.getStringValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        if (string2 != null) {
            string = WWIO.appendPathPart(string, string2);
        }
        if ((string2 = tile.getPath()) != null) {
            string = WWIO.appendPathPart(string, string2);
        }
        if (string == null || string.length() < 1) {
            return Logging.getMessage("TiledRasterProducer.InvalidTile", tile);
        }
        return new File(string);
    }

    protected Object findWriterFor(DataRaster dataRaster, String string, File file, DataRasterWriter[] dataRasterWriterArray) {
        for (DataRasterWriter dataRasterWriter : dataRasterWriterArray) {
            if (!dataRasterWriter.canWrite(dataRaster, string, file)) continue;
            return dataRasterWriter;
        }
        return Logging.getMessage("DataRaster.CannotWrite", dataRaster, string, file);
    }

    protected abstract Document createConfigDoc(AVList var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installConfigFile(AVList aVList) throws Exception {
        String string;
        Object object;
        if (aVList == null) {
            String string2 = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.isStopped()) {
            return;
        }
        File file = this.getConfigFileInstallLocation(aVList);
        if (file == null) {
            String string3 = Logging.getMessage("TiledRasterProducer.NoConfigFileInstallLocation", aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey"));
            Logging.logger().severe(string3);
            throw new WWRuntimeException(string3);
        }
        Object object2 = this.fileLock;
        synchronized (object2) {
            object = file.getParentFile();
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                string = Logging.getMessage("generic.CannotCreateFile", object);
                Logging.logger().warning(string);
            }
        }
        object2 = this.createConfigDoc(aVList);
        if (object2 == null) {
            object = Logging.getMessage("TiledRasterProducer.CannotCreateConfigDoc", aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey"));
            Logging.logger().severe((String)object);
            throw new WWRuntimeException((String)object);
        }
        try {
            WWXML.saveDocumentToFile((Document)object2, file.getAbsolutePath());
        }
        catch (Exception exception) {
            string = Logging.getMessage("TiledRasterProducer.CannotWriteConfigFile", file);
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        this.getProductionResultsList().add(object2);
    }

    protected File getConfigFileInstallLocation(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        if (string != null) {
            string = WWIO.stripTrailingSeparator(string);
        }
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        String string2 = DataConfigurationUtils.getDataConfigFilename(aVList, ".xml");
        if (string2 != null) {
            string2 = WWIO.stripLeadingSeparator(string2);
        }
        if (WWUtil.isEmpty(string2)) {
            return null;
        }
        return new File(string + File.separator + string2);
    }

    protected void calculateTileCount(LevelSet levelSet, AVList aVList) {
        Sector sector = levelSet.getSector();
        this.tileCount = 0;
        for (gov.nasa.worldwind.util.Level level : levelSet.getLevels()) {
            Angle angle = level.getTileDelta().getLatitude();
            Angle angle2 = level.getTileDelta().getLongitude();
            Angle angle3 = levelSet.getTileOrigin().getLatitude();
            Angle angle4 = levelSet.getTileOrigin().getLongitude();
            int n = Tile.computeRow(angle, sector.getMinLatitude(), angle3);
            int n2 = Tile.computeColumn(angle2, sector.getMinLongitude(), angle4);
            int n3 = Tile.computeRow(angle, sector.getMaxLatitude(), angle3);
            int n4 = Tile.computeColumn(angle2, sector.getMaxLongitude(), angle4);
            this.tileCount += (n3 - n + 1) * (n4 - n2 + 1);
            if (!this.isFinalLevel(levelSet, level.getLevelNumber(), aVList)) continue;
            break;
        }
    }

    protected void startProgress() {
        this.tile = 0;
        this.firePropertyChange("gov.nasa.worldwind.avkey.Progress", null, 0.0);
    }

    protected void updateProgress() {
        double d = (double)this.tile / (double)this.tileCount;
        double d2 = (double)(++this.tile) / (double)this.tileCount;
        this.firePropertyChange("gov.nasa.worldwind.avkey.Progress", d, d2);
    }
}

