/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.AbstractDataRasterWriter;
import gov.nasa.worldwind.data.BufferWrapperRaster;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.formats.tiff.GeotiffWriter;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.IOException;

public class GeotiffRasterWriter
extends AbstractDataRasterWriter {
    protected static final String[] geotiffMimeTypes = new String[]{"image/tiff", "image/geotiff"};
    protected static final String[] geotiffSuffixes = new String[]{"tif", "tiff", "gtif"};

    public GeotiffRasterWriter() {
        super(geotiffMimeTypes, geotiffSuffixes);
    }

    @Override
    protected boolean doCanWrite(DataRaster dataRaster, String string, File file) {
        return dataRaster != null && (dataRaster instanceof BufferedImageRaster || dataRaster instanceof BufferWrapperRaster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(DataRaster dataRaster, String string, File file) throws IOException {
        if (null == file) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (null == dataRaster) {
            String string3 = Logging.getMessage("nullValue.RasterIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        GeotiffWriter geotiffWriter = null;
        try {
            geotiffWriter = new GeotiffWriter(file);
            geotiffWriter.write(dataRaster);
        }
        finally {
            if (null != geotiffWriter) {
                geotiffWriter.close();
            }
        }
    }
}

