/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.WorldWindowGLDrawable;
import gov.nasa.worldwind.WorldWindowImpl;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.cache.GpuResourceCache;
import gov.nasa.worldwind.event.InputHandler;
import gov.nasa.worldwind.event.NoOpInputHandler;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.event.RenderingExceptionListener;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.util.BasicGLCapabilitiesChooser;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PerformanceStatistic;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.awt.GLJPanel;

public class WorldWindowGLJPanel
extends GLJPanel
implements WorldWindow,
PropertyChangeListener {
    protected final WorldWindowGLDrawable wwd;

    public WorldWindowGLJPanel() {
        super(Configuration.getRequiredGLCapabilities(), new BasicGLCapabilitiesChooser());
        try {
            this.wwd = (WorldWindowGLDrawable)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.WorldWindowClassName");
            this.wwd.initDrawable(this);
            this.wwd.initGpuResourceCache(WorldWindowImpl.createGpuResourceCache());
            this.createView();
            this.createDefaultInputHandler();
            WorldWind.addPropertyChangeListener("gov.nasa.worldwind.ShutDown", this);
            this.wwd.endInitialization();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("Awt.WorldWindowGLSurface.UnabletoCreateWindow");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, exception);
        }
    }

    public WorldWindowGLJPanel(WorldWindow worldWindow) {
        super(Configuration.getRequiredGLCapabilities(), new BasicGLCapabilitiesChooser());
        if (worldWindow != null) {
            this.setSharedContext(worldWindow.getContext());
        }
        try {
            this.wwd = (WorldWindowGLDrawable)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.WorldWindowClassName");
            this.wwd.initDrawable(this);
            if (worldWindow != null) {
                this.wwd.initGpuResourceCache(worldWindow.getGpuResourceCache());
            } else {
                this.wwd.initGpuResourceCache(WorldWindowImpl.createGpuResourceCache());
            }
            this.createView();
            this.createDefaultInputHandler();
            WorldWind.addPropertyChangeListener("gov.nasa.worldwind.ShutDown", this);
            this.wwd.endInitialization();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("Awt.WorldWindowGLSurface.UnabletoCreateWindow");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, exception);
        }
    }

    public WorldWindowGLJPanel(WorldWindow worldWindow, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(gLCapabilities, gLCapabilitiesChooser);
        if (worldWindow != null) {
            this.setSharedContext(worldWindow.getContext());
        }
        try {
            this.wwd = (WorldWindowGLDrawable)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.WorldWindowClassName");
            this.wwd.initDrawable(this);
            if (worldWindow != null) {
                this.wwd.initGpuResourceCache(worldWindow.getGpuResourceCache());
            } else {
                this.wwd.initGpuResourceCache(WorldWindowImpl.createGpuResourceCache());
            }
            this.createView();
            this.createDefaultInputHandler();
            WorldWind.addPropertyChangeListener("gov.nasa.worldwind.ShutDown", this);
            this.wwd.endInitialization();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("Awt.WorldWindowGLSurface.UnabletoCreateWindow");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, exception);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.ShutDown") {
            this.shutdown();
        }
    }

    @Override
    public void shutdown() {
        WorldWind.removePropertyChangeListener("gov.nasa.worldwind.ShutDown", this);
        this.wwd.shutdown();
    }

    protected void createView() {
        this.setView((View)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ViewClassName"));
    }

    protected void createDefaultInputHandler() {
        this.setInputHandler((InputHandler)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.InputHandlerClassName"));
    }

    @Override
    public InputHandler getInputHandler() {
        return this.wwd.getInputHandler();
    }

    @Override
    public void setInputHandler(InputHandler inputHandler) {
        if (this.wwd.getInputHandler() != null) {
            this.wwd.getInputHandler().setEventSource(null);
        }
        this.wwd.setInputHandler(inputHandler != null ? inputHandler : new NoOpInputHandler());
        if (inputHandler != null) {
            inputHandler.setEventSource(this);
        }
    }

    @Override
    public SceneController getSceneController() {
        return this.wwd.getSceneController();
    }

    @Override
    public void setSceneController(SceneController sceneController) {
        this.wwd.setSceneController(sceneController);
    }

    @Override
    public GpuResourceCache getGpuResourceCache() {
        return this.wwd.getGpuResourceCache();
    }

    @Override
    public void redraw() {
        this.repaint();
    }

    @Override
    public void redrawNow() {
        this.wwd.redrawNow();
    }

    @Override
    public void setModel(Model model) {
        this.wwd.setModel(model);
    }

    @Override
    public Model getModel() {
        return this.wwd.getModel();
    }

    @Override
    public void setView(View view) {
        if (view != null) {
            this.wwd.setView(view);
        }
    }

    @Override
    public View getView() {
        return this.wwd.getView();
    }

    @Override
    public void setModelAndView(Model model, View view) {
        this.setModel(model);
        this.setView(view);
    }

    @Override
    public void addRenderingListener(RenderingListener renderingListener) {
        this.wwd.addRenderingListener(renderingListener);
    }

    @Override
    public void removeRenderingListener(RenderingListener renderingListener) {
        this.wwd.removeRenderingListener(renderingListener);
    }

    @Override
    public void addSelectListener(SelectListener selectListener) {
        this.wwd.getInputHandler().addSelectListener(selectListener);
        this.wwd.addSelectListener(selectListener);
    }

    @Override
    public void removeSelectListener(SelectListener selectListener) {
        this.wwd.getInputHandler().removeSelectListener(selectListener);
        this.wwd.removeSelectListener(selectListener);
    }

    @Override
    public void addPositionListener(PositionListener positionListener) {
        this.wwd.addPositionListener(positionListener);
    }

    @Override
    public void removePositionListener(PositionListener positionListener) {
        this.wwd.removePositionListener(positionListener);
    }

    @Override
    public void addRenderingExceptionListener(RenderingExceptionListener renderingExceptionListener) {
        this.wwd.addRenderingExceptionListener(renderingExceptionListener);
    }

    @Override
    public void removeRenderingExceptionListener(RenderingExceptionListener renderingExceptionListener) {
        this.wwd.removeRenderingExceptionListener(renderingExceptionListener);
    }

    @Override
    public Position getCurrentPosition() {
        return this.wwd.getCurrentPosition();
    }

    @Override
    public PickedObjectList getObjectsAtCurrentPosition() {
        return this.wwd.getSceneController() != null ? this.wwd.getSceneController().getPickedObjectList() : null;
    }

    @Override
    public PickedObjectList getObjectsInSelectionBox() {
        return this.wwd.getSceneController() != null ? this.wwd.getSceneController().getObjectsInPickRectangle() : null;
    }

    @Override
    public Object setValue(String string, Object object) {
        return this.wwd.setValue(string, object);
    }

    @Override
    public AVList setValues(AVList aVList) {
        return this.wwd.setValues(aVList);
    }

    @Override
    public Object getValue(String string) {
        return this.wwd.getValue(string);
    }

    @Override
    public Collection<Object> getValues() {
        return this.wwd.getValues();
    }

    @Override
    public Set<Map.Entry<String, Object>> getEntries() {
        return this.wwd.getEntries();
    }

    @Override
    public String getStringValue(String string) {
        return this.wwd.getStringValue(string);
    }

    @Override
    public boolean hasKey(String string) {
        return this.wwd.hasKey(string);
    }

    @Override
    public Object removeKey(String string) {
        return this.wwd.removeKey(string);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.wwd.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(string, propertyChangeListener);
        this.wwd.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.wwd.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.wwd.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.wwd.firePropertyChange(propertyChangeEvent);
    }

    @Override
    public AVList copy() {
        return this.wwd.copy();
    }

    @Override
    public AVList clearList() {
        return this.wwd.clearList();
    }

    @Override
    public void setPerFrameStatisticsKeys(Set<String> set) {
        this.wwd.setPerFrameStatisticsKeys(set);
    }

    @Override
    public Collection<PerformanceStatistic> getPerFrameStatistics() {
        return this.wwd.getPerFrameStatistics();
    }
}

