/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.animation;

import gov.nasa.worldwind.animation.DoubleAnimator;
import gov.nasa.worldwind.util.PropertyAccessor;

public class MoveToDoubleAnimator
extends DoubleAnimator {
    protected double minEpsilon = 0.001;
    protected double smoothing = 0.9;

    public MoveToDoubleAnimator(Double d, double d2, PropertyAccessor.DoubleAccessor doubleAccessor) {
        super(null, 0.0, d, doubleAccessor);
        this.interpolator = null;
        this.smoothing = d2;
    }

    public MoveToDoubleAnimator(Double d, double d2, double d3, PropertyAccessor.DoubleAccessor doubleAccessor) {
        super(null, 0.0, d, doubleAccessor);
        this.interpolator = null;
        this.smoothing = d2;
        this.minEpsilon = d3;
    }

    @Override
    public void next() {
        if (this.hasNext()) {
            this.set(1.0 - this.smoothing);
        }
    }

    @Override
    public Double nextDouble(double d) {
        double d2 = (1.0 - d) * this.propertyAccessor.getDouble() + d * this.end;
        if (Math.abs(d2 - this.propertyAccessor.getDouble()) < this.minEpsilon) {
            this.stop();
            return null;
        }
        return d2;
    }
}

