/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.handler;

import gov.nasa.worldwind.layers.Layer;
import jams.worldwind.handler.LayerListItemTransferable;
import jams.worldwind.ui.model.LayerListModel;
import jams.worldwind.ui.view.LayerListView;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerListItemTransferHandler
extends TransferHandler {
    private static final Logger logger = LoggerFactory.getLogger(LayerListView.class);
    LayerListModel model;

    public LayerListItemTransferHandler(LayerListModel m) {
        this.model = m;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.getComponent() instanceof JList && support.isDataFlavorSupported(LayerListItemTransferable.LAYER_LIST_ITEM_DATA_FLAVOR);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        boolean accept = false;
        if (this.canImport(support)) {
            try {
                Transferable t = support.getTransferable();
                Object value = t.getTransferData(LayerListItemTransferable.LAYER_LIST_ITEM_DATA_FLAVOR);
                if (value instanceof Layer) {
                    JList list = (JList)support.getComponent();
                    int indexOld = this.model.indexOf(value);
                    int indexNew = list.getDropLocation().getIndex();
                    boolean increment = indexNew >= indexOld;
                    Layer oldValue = (Layer)this.model.elementAt(indexOld);
                    if (increment) {
                        this.model.insertElementAt(oldValue, indexNew);
                        this.model.removeElementAt(indexOld);
                    } else {
                        this.model.removeElementAt(indexOld);
                        this.model.insertElementAt(oldValue, indexNew);
                    }
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                logger.info(ex.getMessage());
            }
        }
        return accept;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JList list;
        Object value;
        LayerListItemTransferable t = null;
        if (c instanceof JList && (value = (list = (JList)c).getSelectedValue()) instanceof Layer) {
            Layer li = (Layer)value;
            t = new LayerListItemTransferable(li);
        }
        return t;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        logger.info("Update WorldWind Layers");
        this.model.updateWorldWind();
    }
}

