/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.data;

import gnu.trove.map.hash.TObjectIntHashMap;
import jams.data.JAMSCalendar;
import jams.workspace.dsproc.DataMatrix;
import jams.workspace.stores.ShapeFileDataStore;
import java.io.Serializable;
import java.util.Arrays;

public class DataTransfer3D
implements Serializable {
    private final double[][][] data;
    private final TObjectIntHashMap<String> hruIdToIndex;
    private final TObjectIntHashMap<String> attributeToIndex;
    private final TObjectIntHashMap<JAMSCalendar> timeStepToIndex;
    private int[] idMap = null;
    private ShapeFileDataStore shapefileDataStore;

    public DataTransfer3D(DataMatrix[] m, String[] ids, String[] timesteps, String[] attribs) {
        int numAttribs = m.length;
        int numTimeSteps = m[0].getRowDimension();
        int numIds = m[0].getColumnDimension();
        this.hruIdToIndex = new TObjectIntHashMap(numIds);
        this.attributeToIndex = new TObjectIntHashMap(numAttribs);
        this.timeStepToIndex = new TObjectIntHashMap(numTimeSteps);
        this.data = new double[numIds][numAttribs][numTimeSteps];
        this.shapefileDataStore = null;
        for (int i = 0; i < numIds; ++i) {
            for (int j = 0; j < m.length; ++j) {
                double[] column = m[j].getCol(i);
                for (int k = 0; k < column.length; ++k) {
                    this.data[i][j][k] = column[k];
                }
            }
            this.hruIdToIndex.put(ids[i], i);
        }
        for (int j = 0; j < m.length; ++j) {
            this.attributeToIndex.put(attribs[j], j);
        }
        for (int k = 0; k < timesteps.length; ++k) {
            JAMSCalendar date = new JAMSCalendar();
            date.setValue(timesteps[k]);
            this.timeStepToIndex.put(date, k);
        }
    }

    public DataTransfer3D(String[] ids, String[] timesteps, String[] attribs) {
        int i;
        int numAttribs = attribs.length;
        int numTimeSteps = timesteps.length;
        int numIds = ids.length;
        this.hruIdToIndex = new TObjectIntHashMap(numIds);
        this.attributeToIndex = new TObjectIntHashMap(numAttribs);
        this.timeStepToIndex = new TObjectIntHashMap(numTimeSteps);
        this.data = new double[numIds][numAttribs][numTimeSteps];
        this.shapefileDataStore = null;
        for (i = 0; i < ids.length; ++i) {
            this.hruIdToIndex.put(ids[i], i);
        }
        for (i = 0; i < attribs.length; ++i) {
            this.attributeToIndex.put(attribs[i], i);
        }
        for (i = 0; i < timesteps.length; ++i) {
            JAMSCalendar calendar = new JAMSCalendar();
            calendar.setValue(timesteps[i]);
            this.timeStepToIndex.put(calendar, i);
        }
    }

    public ShapeFileDataStore getShapeFileDataStore() {
        return this.shapefileDataStore;
    }

    public void setShapeFileDataStore(ShapeFileDataStore dataStore) {
        this.shapefileDataStore = dataStore;
    }

    public String getKeyColumn() {
        return this.shapefileDataStore.getKeyColumn();
    }

    public double getValue(String id, String attrib, JAMSCalendar date) {
        if (this.hruIdToIndex.containsKey(id) && this.attributeToIndex.containsKey(attrib) && this.timeStepToIndex.containsKey(date)) {
            int i = this.hruIdToIndex.get(id);
            int j = this.attributeToIndex.get(attrib);
            int k = this.timeStepToIndex.get(date);
            return this.data[i][j][k];
        }
        return Double.NaN;
    }

    public double[] getValue(String attrib) {
        int numIds = this.data.length;
        int numTimeSteps = this.data[0][0].length;
        int aIndex = this.attributeToIndex.get(attrib);
        double[] result = new double[numIds * numTimeSteps];
        if (this.attributeToIndex.containsKey(attrib)) {
            for (int i = 0; i < numIds; ++i) {
                for (int j = 0; j < numTimeSteps; ++j) {
                    result[i * numTimeSteps + j] = this.data[i][aIndex][j];
                }
            }
            return result;
        }
        return null;
    }

    public String[] getSortedIds() {
        Object[] keys = this.hruIdToIndex.keys();
        Arrays.sort(keys);
        return (String[])Arrays.copyOf(keys, keys.length, String[].class);
    }

    public String[] getSortedAttributes() {
        Object[] keys = this.attributeToIndex.keys();
        Arrays.sort(keys);
        return (String[])Arrays.copyOf(keys, keys.length, String[].class);
    }

    public JAMSCalendar[] getSortedTimeSteps() {
        Object[] keys = this.timeStepToIndex.keys();
        Arrays.sort(keys);
        return (JAMSCalendar[])Arrays.copyOf(keys, keys.length, JAMSCalendar[].class);
    }
}

