/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryTypeConverterFactory
implements ConverterFactory {
    private static final Logger LOGGER = Logging.getLogger(GeometryTypeConverterFactory.class);
    static GeometryFactory gFac = new GeometryFactory();

    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (Geometry.class.isAssignableFrom(source) && Geometry.class.isAssignableFrom(target)) {
            return new Converter(){

                public <T> List<T> convertAll(GeometryCollection gc, Class<T> target) throws Exception {
                    ArrayList<Object> result = new ArrayList<Object>();
                    for (int count = 0; count < gc.getNumGeometries(); ++count) {
                        Object geo = this.convert((Object)gc.getGeometryN(count), (Class)target);
                        if (geo == null) continue;
                        result.add(geo);
                    }
                    return result;
                }

                public Object convert(Object source, Class target) throws Exception {
                    if (target.isAssignableFrom(source.getClass())) {
                        return source;
                    }
                    if (source instanceof Geometry) {
                        Geometry sourceGeometry = (Geometry)source;
                        if (MultiPoint.class.isAssignableFrom(target)) {
                            Point[] points = new Point[]{};
                            points = source instanceof Point ? new Point[]{(Point)source} : (source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, Point.class).toArray(points) : new Point[]{(Point)this.convert(source, Point.class)});
                            return gFac.createMultiPoint(points);
                        }
                        if (MultiLineString.class.isAssignableFrom(target)) {
                            LineString[] lineStrings = new LineString[]{};
                            lineStrings = source instanceof LineString ? new LineString[]{(LineString)source} : (source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, LineString.class).toArray(lineStrings) : new LineString[]{(LineString)this.convert(source, LineString.class)});
                            return gFac.createMultiLineString(lineStrings);
                        }
                        if (MultiPolygon.class.isAssignableFrom(target)) {
                            Polygon[] polygons = new Polygon[]{};
                            polygons = source instanceof Polygon ? new Polygon[]{(Polygon)source} : (source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, Polygon.class).toArray(polygons) : new Polygon[]{(Polygon)this.convert(source, Polygon.class)});
                            return gFac.createMultiPolygon(polygons);
                        }
                        if (GeometryCollection.class.isAssignableFrom(target)) {
                            return gFac.createGeometryCollection(new Geometry[]{(Geometry)source});
                        }
                        if (Point.class.isAssignableFrom(target)) {
                            if (source instanceof MultiPoint && sourceGeometry.getNumGeometries() == 1) {
                                return ((MultiPoint)source).getGeometryN(0);
                            }
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Converting Geometry " + source.toString() + " to Point. This could be unsafe");
                            }
                            return ((Geometry)source).getCentroid();
                        }
                        if (LineString.class.isAssignableFrom(target)) {
                            if (source instanceof MultiLineString && sourceGeometry.getNumGeometries() == 1) {
                                return ((MultiLineString)source).getGeometryN(0);
                            }
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Converting Geometry " + source.toString() + " to LineString. This could be unsafe");
                            }
                            return gFac.createLineString(this.getLineStringCoordinates(((Geometry)source).getCoordinates()));
                        }
                        if (Polygon.class.isAssignableFrom(target)) {
                            if (source instanceof MultiPolygon && sourceGeometry.getNumGeometries() == 1) {
                                return ((MultiPolygon)source).getGeometryN(0);
                            }
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Converting Geometry " + source.toString() + " to Polygon. This could be unsafe");
                            }
                            Coordinate[] coords = this.getPolygonCoordinates(((Geometry)source).getCoordinates());
                            return gFac.createPolygon(gFac.createLinearRing(coords), new LinearRing[0]);
                        }
                    }
                    return null;
                }

                private <T> T[] arrayCopy(T[] original, int length) {
                    Class<?> arrayType = original.getClass().getComponentType();
                    Object[] copy = (Object[])Array.newInstance(arrayType, length);
                    System.arraycopy(original, 0, copy, 0, original.length < length ? original.length : length);
                    return copy;
                }

                private Coordinate[] growCoordinatesNum(Coordinate[] input, int numpoints) {
                    if (input.length < numpoints) {
                        Object[] newCoordinates = this.arrayCopy(input, numpoints);
                        Arrays.fill(newCoordinates, input.length, numpoints, input[0]);
                        input = newCoordinates;
                    }
                    return input;
                }

                private Coordinate[] getLineStringCoordinates(Coordinate[] coordinates) {
                    coordinates = this.growCoordinatesNum(coordinates, 2);
                    return coordinates;
                }

                private Coordinate[] getPolygonCoordinates(Coordinate[] coordinates) {
                    if (!(coordinates = this.growCoordinatesNum(coordinates, 4))[coordinates.length - 1].equals(coordinates[0])) {
                        Coordinate[] newCoordinates = this.arrayCopy(coordinates, coordinates.length + 1);
                        newCoordinates[newCoordinates.length - 1] = newCoordinates[0];
                        coordinates = newCoordinates;
                    }
                    return coordinates;
                }
            };
        }
        return null;
    }
}

