/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.awt.Color;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class ColorConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (target.equals(Color.class)) {
            if (source.equals(String.class)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        String rgba = (String)source;
                        try {
                            return Color.decode(rgba);
                        }
                        catch (NumberFormatException badRGB) {
                            return null;
                        }
                    }
                };
            }
            if (source.equals(Integer.class)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Integer rgba = (Integer)source;
                        int alpha = 0xFF000000 & rgba;
                        return new Color(rgba, alpha != 0);
                    }
                };
            }
        }
        return null;
    }
}

