/*
 * Decompiled with CFR 0.152.
 */
package io;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.Model;
import jams.model.VersionComments;
import jams.tools.FileTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

@JAMSComponentDescription(title="EntitiesFromInputFile", author="Sven Kralisch", description="Creates entities from stations in a time-series input file", date="2021-09-14", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class EntitiesFromInputFile
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time-series input file name")
    public Attribute.String entityFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="entity collection")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Name of identifier", defaultValue="ID")
    public Attribute.String identName;

    public void init() {
        this.getModel().getRuntime().println("Reading model entities...", 2);
        String fileName = this.entityFileName.getValue();
        if (new File(fileName).exists()) {
            fileName = this.entityFileName.getValue();
        } else if (this.getModel().getWorkspaceDirectory() != null) {
            fileName = FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.entityFileName.getValue());
        }
        if (!new File(fileName).exists()) {
            this.getModel().getRuntime().sendErrorMsg("Couldn't read entity file " + fileName + "!\nIf you are not using an absolute path, please ensure you have defined a workspace directory!");
        }
        ArrayList<Attribute.Entity> list = EntitiesFromInputFile.readParas(fileName, this.getModel());
        for (Attribute.Entity e : list) {
            try {
                e.setId((long)e.getDouble(this.identName.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"" + this.identName + "\" while reading J2K HRU parameter file (" + this.entityFileName.getValue() + ")!");
            }
        }
        this.entities.setEntities(list);
        int nEnt = this.entities.getEntityArray().length;
        this.getModel().getRuntime().println("Entities read and created successfully! (" + nEnt + ")", 1);
    }

    public static ArrayList<Attribute.Entity> readParas(String fileName, Model model) {
        ArrayList<Attribute.Entity> entityList = new ArrayList<Attribute.Entity>();
        try {
            String s;
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while ((s = reader.readLine()) != null && !s.startsWith("@statAttribVal")) {
            }
            String[] names = reader.readLine().split("\t+");
            String[] ids = reader.readLine().split("\t+");
            String[] elevs = reader.readLine().split("\t+");
            String[] xs = reader.readLine().split("\t+");
            String[] ys = reader.readLine().split("\t+");
            for (int i = 1; i < names.length; ++i) {
                Attribute.Entity e = DefaultDataFactory.getDataFactory().createEntity();
                e.setDouble("ID", Double.parseDouble(ids[i]));
                e.setDouble("elevation", Double.parseDouble(elevs[i]));
                e.setDouble("x", Double.parseDouble(xs[i]));
                e.setDouble("y", Double.parseDouble(ys[i]));
                e.setDouble("area", 1.0);
                entityList.add(e);
            }
        }
        catch (IOException ioe) {
            model.getRuntime().handle((Throwable)ioe);
        }
        return entityList;
    }
}

