/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.grib1.Grib1Data;
import ucar.grib.grib1.Grib1GridTableLookup;
import ucar.grib.grib2.Grib2Data;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.grib.grib2.Grib2Pds;
import ucar.grib.grib2.Grib2Tables;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.CF;
import ucar.nc2.iosp.grib.GribGridServiceProvider;
import ucar.nc2.iosp.grid.GridEnsembleCoord;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridIndexToNC;
import ucar.nc2.iosp.grid.GridTimeCoord;
import ucar.nc2.iosp.grid.GridVertCoord;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil;

public class GridVariable {
    private static Logger log = LoggerFactory.getLogger(GridVariable.class);
    private static boolean warnOk = true;
    private static boolean compareData = false;
    private static boolean sendAll = false;
    private final String filename;
    private final String name;
    private String vname;
    private GridRecord firstRecord;
    private GridTableLookup lookup;
    private GridHorizCoordSys hcs;
    private GridTimeCoord tcs = null;
    private GridEnsembleCoord ecs = null;
    private GridVertCoord vc = null;
    private List<GridRecord> records = new ArrayList<GridRecord>();
    private int nlevels;
    private int nens;
    private int ntimes;
    private GridRecord[] recordTracker;
    private boolean hasVert = false;
    private volatile int hashCode = 0;

    GridVariable(String filename, String name, GridHorizCoordSys hcs, GridTableLookup lookup) {
        this.filename = filename;
        this.name = name;
        this.hcs = hcs;
        this.lookup = lookup;
    }

    void addProduct(GridRecord record) {
        this.records.add(record);
        if (this.firstRecord == null) {
            this.firstRecord = record;
        }
    }

    List<GridRecord> getRecords() {
        return this.records;
    }

    GridRecord getFirstRecord() {
        return this.records.get(0);
    }

    GridHorizCoordSys getHorizCoordSys() {
        return this.hcs;
    }

    GridVertCoord getVertCoord() {
        return this.vc;
    }

    boolean hasVert() {
        return this.hasVert;
    }

    void setVarName(String vname) {
        this.vname = vname;
    }

    void setVertCoord(GridVertCoord vc) {
        this.vc = vc;
    }

    void setTimeCoord(GridTimeCoord tcs) {
        this.tcs = tcs;
    }

    void setEnsembleCoord(GridEnsembleCoord ecs) {
        this.ecs = ecs;
    }

    public int getNEnsembles() {
        return this.ecs == null ? 1 : this.ecs.getNEnsembles();
    }

    boolean hasEnsemble() {
        return this.ecs != null;
    }

    boolean isEnsemble() {
        if (this.firstRecord instanceof GribGridRecord) {
            GribGridRecord ggr = (GribGridRecord)this.firstRecord;
            return ggr.getPds().isEnsemble();
        }
        return false;
    }

    int getVertNlevels() {
        return this.vc.getNLevels();
    }

    String getVertName() {
        return this.vc.getVariableName();
    }

    String getVertLevelName() {
        return this.vc.getLevelName();
    }

    boolean getVertIsUsed() {
        return this.vc.isVertDimensionUsed();
    }

    int getVertIndex(GridRecord p) {
        return this.vc.getIndex(p);
    }

    int getNTimes() {
        return this.tcs == null ? 1 : this.tcs.getNTimes();
    }

    Variable makeVariable(NetcdfFile ncfile, Group g, String useName, RandomAccessFile raf) {
        int icf;
        CF.CellMethods cm;
        GribGridRecord ggr;
        assert (this.records.size() > 0) : "no records for this variable";
        this.nlevels = this.getVertNlevels();
        this.ntimes = this.tcs.getNTimes();
        if (this.vname == null) {
            this.vname = useName = StringUtil.replace((String)useName, (char)' ', (String)"_");
        }
        Variable v = new Variable(ncfile, g, null, this.vname);
        v.setDataType(DataType.FLOAT);
        Formatter dims = new Formatter();
        if (this.hasEnsemble()) {
            dims.format("ens ", new Object[0]);
        }
        dims.format("%s ", this.tcs.getName());
        if (this.getVertIsUsed()) {
            dims.format("%s ", this.getVertName());
            this.hasVert = true;
        }
        if (this.hcs.isLatLon()) {
            dims.format("lat lon", new Object[0]);
        } else {
            dims.format("y x", new Object[0]);
        }
        v.setDimensions(dims.toString());
        GridParameter param = this.lookup.getParameter(this.firstRecord);
        String unit = param.getUnit();
        if (unit == null) {
            unit = "";
        }
        v.addAttribute(new Attribute("units", unit));
        v.addAttribute(new Attribute("long_name", this.makeLongName()));
        if (this.firstRecord instanceof GribGridRecord && (ggr = (GribGridRecord)this.firstRecord).isInterval() && (cm = CF.CellMethods.convertGribCodeTable4_10(ggr.getStatisticalProcessType())) != null) {
            v.addAttribute(new Attribute("cell_methods", this.tcs.getName() + ": " + cm.toString()));
        }
        v.addAttribute(new Attribute("missing_value", new Float(this.lookup.getFirstMissingValue())));
        if (!this.hcs.isLatLon()) {
            if (GribGridServiceProvider.addLatLon) {
                v.addAttribute(new Attribute("coordinates", "lat lon"));
            }
            v.addAttribute(new Attribute("grid_mapping", this.hcs.getGridName()));
        }
        String flag = (icf = this.hcs.getGds().getInt("VectorComponentFlag")) == 0 ? Grib2Tables.VectorComponentFlag.easterlyNortherlyRelative.toString() : Grib2Tables.VectorComponentFlag.gridRelative.toString();
        if (this.lookup instanceof Grib2GridTableLookup) {
            Grib2GridTableLookup g2lookup = (Grib2GridTableLookup)this.lookup;
            GribGridRecord ggr2 = (GribGridRecord)this.firstRecord;
            Grib2Pds pds2 = (Grib2Pds)ggr2.getPds();
            int[] paramId = g2lookup.getParameterId(this.firstRecord);
            v.addAttribute(new Attribute("GRIB_param_discipline", this.lookup.getDisciplineName(this.firstRecord)));
            v.addAttribute(new Attribute("GRIB_param_category", this.lookup.getCategoryName(this.firstRecord)));
            v.addAttribute(new Attribute("GRIB_param_name", param.getName()));
            v.addAttribute(new Attribute("GRIB_generating_process_type", g2lookup.getGenProcessTypeName(this.firstRecord)));
            v.addAttribute(new Attribute("GRIB_param_id", Array.factory(Integer.TYPE, new int[]{paramId.length}, (Object)paramId)));
            v.addAttribute(new Attribute("GRIB_product_definition_template", pds2.getProductDefinitionTemplate()));
            v.addAttribute(new Attribute("GRIB_product_definition_template_desc", Grib2Tables.codeTable4_0(pds2.getProductDefinitionTemplate())));
            v.addAttribute(new Attribute("GRIB_level_type", new Integer(pds2.getLevelType1())));
            v.addAttribute(new Attribute("GRIB_level_type_name", this.lookup.getLevelName(this.firstRecord)));
            if (pds2.isInterval()) {
                v.addAttribute(new Attribute("GRIB_interval_stat_type", ggr2.getStatisticalProcessTypeName()));
            }
            if (pds2.isEnsembleDerived()) {
                Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)pds2);
                v.addAttribute(new Attribute("GRIB_ensemble_derived_type", new Integer(pdsDerived.getDerivedForecastType())));
            }
            if (pds2.isEnsemble()) {
                v.addAttribute(new Attribute("GRIB_ensemble", "true"));
            }
            if (pds2.isProbability()) {
                Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)pds2);
                v.addAttribute(new Attribute("GRIB_probability_type", new Integer(pdsProb.getProbabilityType())));
                v.addAttribute(new Attribute("GRIB_probability_lower_limit", new Double(pdsProb.getProbabilityLowerLimit())));
                v.addAttribute(new Attribute("GRIB_probability_upper_limit", new Double(pdsProb.getProbabilityUpperLimit())));
            }
            v.addAttribute(new Attribute("GRIB_VectorComponentFlag", flag));
        } else if (this.lookup instanceof Grib1GridTableLookup) {
            Grib1GridTableLookup g1lookup = (Grib1GridTableLookup)this.lookup;
            int[] paramId = g1lookup.getParameterId(this.firstRecord);
            v.addAttribute(new Attribute("GRIB_param_name", param.getDescription()));
            v.addAttribute(new Attribute("GRIB_param_short_name", param.getName()));
            v.addAttribute(new Attribute("GRIB_center_id", new Integer(paramId[1])));
            v.addAttribute(new Attribute("GRIB_table_id", new Integer(paramId[2])));
            v.addAttribute(new Attribute("GRIB_param_number", new Integer(paramId[3])));
            v.addAttribute(new Attribute("GRIB_param_id", Array.factory(Integer.TYPE, new int[]{paramId.length}, (Object)paramId)));
            v.addAttribute(new Attribute("GRIB_product_definition_type", g1lookup.getProductDefinitionName(this.firstRecord)));
            v.addAttribute(new Attribute("GRIB_level_type", new Integer(this.firstRecord.getLevelType1())));
            v.addAttribute(new Attribute("GRIB_VectorComponentFlag", flag));
        } else {
            v.addAttribute(new Attribute("VectorComponentFlag", flag));
        }
        v.setSPobject(this);
        int nrecs = this.ntimes * this.nlevels;
        if (this.hasEnsemble()) {
            nrecs *= this.ecs.getNEnsembles();
        }
        this.recordTracker = new GridRecord[nrecs];
        if (log.isDebugEnabled()) {
            log.debug("Record Assignment for Variable " + this.getName());
        }
        boolean oneSent = false;
        for (GridRecord p : this.records) {
            int recno;
            int level = this.getVertIndex(p);
            if (!this.getVertIsUsed() && level > 0) {
                log.warn("inconsistent level encoding=" + level);
                level = 0;
            }
            int time = this.tcs.findIndex(p);
            if (level < 0) {
                log.warn("LEVEL NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n" + "   " + this.getVertLevelName() + " (type=" + p.getLevelType1() + "," + p.getLevelType2() + ")  value=" + p.getLevel1() + "," + p.getLevel2() + "\n");
                this.getVertIndex(p);
                continue;
            }
            if (time < 0) {
                log.warn("TIME NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n" + " validTime= " + p.getValidTime() + "\n");
                this.tcs.findIndex(p);
                continue;
            }
            if (this.hasEnsemble()) {
                GribGridRecord ggr3 = (GribGridRecord)p;
                int ens = this.ecs.getIndex(ggr3);
                if (ens < 0) {
                    int ensNumber = ggr3.getPds().getPerturbationNumber();
                    int ensType = ggr3.getPds().getPerturbationType();
                    log.warn("ENS NOT FOUND record; level=" + level + " time= " + time + " for " + this.getName() + " file=" + ncfile.getLocation() + "\n ensNumber= " + ensNumber + " ensType= " + ensType + "\n");
                    this.ecs.getIndex(ggr3);
                    continue;
                }
                recno = ens * (this.ntimes * this.nlevels) + time * this.nlevels + level;
                if (recno < 0) {
                    this.ecs.getIndex(ggr3);
                }
            } else {
                recno = time * this.nlevels + level;
            }
            boolean sentMessage = false;
            if (p instanceof GribGridRecord) {
                GribGridRecord ggp = (GribGridRecord)p;
                if (ggp.getBelongs() != null) {
                    log.warn("GribGridRecord " + ggp.cdmVariableName(this.lookup, true, true) + " recno = " + recno + " already belongs to = " + ggp.getBelongs());
                }
                ggp.setBelongs(new Belongs(recno, this));
                if (this.recordTracker[recno] != null) {
                    GribGridRecord ggq = (GribGridRecord)this.recordTracker[recno];
                    if (compareData && !this.compareData(ggq, ggp, raf)) {
                        log.warn("GridVariable " + this.vname + " recno = " + recno + " already has in slot = " + ggq.toString() + " with different data for " + this.filename);
                        sentMessage = true;
                    }
                }
            }
            if (this.recordTracker[recno] == null) {
                this.recordTracker[recno] = p;
                if (!log.isDebugEnabled()) continue;
                log.debug(" " + this.vc.getVariableName() + " (type=" + p.getLevelType1() + "," + p.getLevelType2() + ")  value=" + p.getLevel1() + "," + p.getLevel2());
                continue;
            }
            if (p instanceof GribGridRecord && !sentMessage && warnOk && !oneSent) {
                GribGridRecord gp = (GribGridRecord)p;
                GribGridRecord qp = (GribGridRecord)this.recordTracker[recno];
                log.warn("Duplicate record for " + this.filename + "\n " + gp.toString() + "\n " + qp.toString());
            }
            if (!sendAll) {
                oneSent = true;
            }
            this.recordTracker[recno] = p;
        }
        this.records.clear();
        return v;
    }

    private boolean compareData(GribGridRecord ggr1, GribGridRecord ggr2, RandomAccessFile raf) {
        if (raf == null) {
            return false;
        }
        float[] data1 = null;
        float[] data2 = null;
        try {
            if (ggr1.getEdition() == 2) {
                Grib2Data g2read = new Grib2Data(raf);
                data1 = g2read.getData(ggr1.getGdsOffset(), ggr1.getPdsOffset(), ggr1.getReferenceTimeInMsecs());
                data2 = g2read.getData(ggr2.getGdsOffset(), ggr2.getPdsOffset(), ggr2.getReferenceTimeInMsecs());
            } else {
                Grib1Data g1read = new Grib1Data(raf);
                data1 = g1read.getData(ggr1.getGdsOffset(), ggr1.getPdsOffset(), ggr1.getDecimalScale(), ggr1.isBmsExists());
                data2 = g1read.getData(ggr2.getGdsOffset(), ggr2.getPdsOffset(), ggr2.getDecimalScale(), ggr2.isBmsExists());
            }
        }
        catch (IOException e) {
            log.error("Failed to read data", e);
            return false;
        }
        if (data1.length != data2.length) {
            return false;
        }
        for (int i = 0; i < data1.length; ++i) {
            if (data1[i] == data2[i] || Double.isNaN(data1[i]) || Double.isNaN(data2[i])) continue;
            return false;
        }
        return true;
    }

    public void showRecord(int recnum, Formatter f) {
        if (recnum < 0 || recnum > this.recordTracker.length - 1) {
            f.format("%d out of range [0,%d]%n", recnum, this.recordTracker.length - 1);
            return;
        }
        GridRecord gr = this.recordTracker[recnum];
        if (this.hasEnsemble()) {
            int ens = recnum / (this.nlevels * this.ntimes);
            int tmp = recnum - ens * (this.nlevels * this.ntimes);
            int time = tmp / this.nlevels;
            int level = tmp % this.nlevels;
            f.format("recnum=%d (record hash=%d) ens=%d time=%s(%d) level=%f(%d)%n", recnum, gr.hashCode(), ens, this.tcs.getCoord(time), time, this.vc.getCoord(level), level);
        } else {
            int time = recnum / this.nlevels;
            int level = recnum % this.nlevels;
            f.format("recnum=%d (record hash=%d) time=%s(%d) level=%f(%d)%n", recnum, gr.hashCode(), this.tcs.getCoord(time), time, this.vc.getCoord(level), level);
        }
    }

    public void showMissing(Formatter f) {
        int count = 0;
        int total = 0;
        f.format("  %s%n", this.name);
        for (int j = 0; j < this.nlevels; ++j) {
            f.format("   ", new Object[0]);
            for (int i = 0; i < this.ntimes; ++i) {
                boolean missing = this.recordTracker[i * this.nlevels + j] == null;
                f.format("%s", missing ? "-" : "X");
                if (missing) {
                    ++count;
                }
                ++total;
            }
            f.format("%n", new Object[0]);
        }
        f.format("  MISSING= %d / %d for %s%n", count, total, this.name);
    }

    public int showMissingSummary(Formatter f) {
        int count = 0;
        int total = this.recordTracker.length;
        for (int i = 0; i < total; ++i) {
            if (this.recordTracker[i] != null) continue;
            ++count;
        }
        f.format("  MISSING= %d / %d for %s%n", count, total, this.name);
        return count;
    }

    public GridRecord findRecord(int ens, int time, int level) {
        if (this.hasEnsemble()) {
            return this.recordTracker[ens * (this.ntimes * this.nlevels) + time * this.nlevels + level];
        }
        return this.recordTracker[time * this.nlevels + level];
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof GridVariable)) {
            return false;
        }
        return this.hashCode() == oo.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.name.hashCode();
            result += 37 * result + this.firstRecord.getLevelType1();
            result += 37 * result + this.hcs.getID().hashCode();
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return this.vname == null ? this.name : this.vname;
    }

    public String dump() {
        DateFormatter formatter = new DateFormatter();
        Formatter sbuff = new Formatter();
        sbuff.format("%s %d %n", this.name, this.records.size());
        for (GridRecord record : this.records) {
            sbuff.format(" level = %d %f", record.getLevelType1(), record.getLevel1());
            if (null != record.getValidTime()) {
                sbuff.format(" time = %s", formatter.toDateTimeString(record.getValidTime()));
            }
            sbuff.format("%n", new Object[0]);
        }
        return sbuff.toString();
    }

    private String makeLongName() {
        String levelName;
        Formatter f = new Formatter();
        GridParameter param = this.lookup.getParameter(this.firstRecord);
        f.format("%s", param.getDescription());
        if (this.firstRecord instanceof GribGridRecord) {
            String intervalName;
            String suffixName;
            Grib2Pds pds2;
            String useGenType;
            GribGridRecord ggr = (GribGridRecord)this.firstRecord;
            if (ggr.getEdition() == 2 && (useGenType = (pds2 = (Grib2Pds)ggr.getPds()).getUseGenProcessType()) != null) {
                f.format("_%s", useGenType);
            }
            if ((suffixName = ggr.makeSuffix()) != null && suffixName.length() != 0) {
                f.format("%s", suffixName);
            }
            if (ggr.isInterval() && (intervalName = this.makeIntervalName()).length() != 0) {
                String stat = ggr.getStatisticalProcessTypeNameShort();
                if (stat != null) {
                    f.format(" (%s for %s)", ggr.getStatisticalProcessTypeName(), intervalName);
                } else {
                    f.format(" (%s)", intervalName);
                }
            }
        }
        if ((levelName = GridIndexToNC.makeLevelName(this.firstRecord, this.lookup)).length() != 0) {
            f.format(" @ %s", levelName);
        }
        return f.toString();
    }

    private String makeIntervalName() {
        if (this.tcs.getConstantInterval() < 0) {
            return " Mixed Intervals";
        }
        return this.tcs.getConstantInterval() + " " + this.tcs.getTimeUnit() + " Intervals";
    }

    public class Belongs {
        public int recnum;
        public GridVariable gv;

        private Belongs(int recnum, GridVariable gv) {
            this.recnum = recnum;
            this.gv = gv;
        }

        public String toString() {
            return "Belongs{recnum=" + this.recnum + ", gv=" + this.gv.vname + '}';
        }
    }
}

