/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.util.Date;
import ucar.grid.GridDefRecord;
import ucar.grid.GridParameter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.nc2.iosp.gempak.GempakGridParameterTable;
import ucar.nc2.iosp.gempak.GempakGridRecord;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakUtil;

public final class GempakLookup
implements GridTableLookup {
    private GempakGridRecord sample;

    public GempakLookup(GempakGridRecord sample) {
        this.sample = sample;
    }

    @Override
    public String getShapeName(GridDefRecord gds) {
        return "Spherical";
    }

    @Override
    public final String getGridName(GridDefRecord gds) {
        return this.getProjectionName(gds);
    }

    @Override
    public final GridParameter getParameter(GridRecord gr) {
        String name = gr.getParameterName();
        GempakParameter gp = GempakGridParameterTable.getParameter(name);
        if (gp != null) {
            return gp;
        }
        return new GridParameter(0, name, name, "");
    }

    @Override
    public final String getDisciplineName(GridRecord gr) {
        return "Meteorological Products";
    }

    @Override
    public final String getCategoryName(GridRecord gr) {
        return "Meteorological Parameters";
    }

    @Override
    public final String getLevelName(GridRecord gr) {
        String levelName = GempakUtil.LV_CCRD(gr.getLevelType1());
        return levelName;
    }

    @Override
    public final String getLevelDescription(GridRecord gr) {
        String levelName = this.getLevelName(gr);
        if (levelName.equals("PRES")) {
            return "pressure";
        }
        if (levelName.equals("NONE")) {
            return "surface";
        }
        if (levelName.equals("HGHT")) {
            return "height_above_ground";
        }
        if (levelName.equals("THTA")) {
            return "isentropic";
        }
        if (levelName.equals("SGMA")) {
            return "sigma";
        }
        if (levelName.equals("DPTH")) {
            return "depth";
        }
        if (levelName.equals("PDLY")) {
            return "layer_between_two_pressure_difference_from_ground";
        }
        if (levelName.equals("FRZL")) {
            return "zeroDegC_isotherm";
        }
        if (levelName.equals("TROP")) {
            return "tropopause";
        }
        if (levelName.equals("CLDL")) {
            return "cloud_base";
        }
        if (levelName.equals("CLDT")) {
            return "cloud_tops";
        }
        if (levelName.equals("MWSL")) {
            return "maximum_wind_level";
        }
        return levelName;
    }

    @Override
    public final String getLevelUnit(GridRecord gr) {
        String levelName = this.getLevelName(gr);
        if (levelName.equals("PRES")) {
            return "hPa";
        }
        if (levelName.equals("HGHT")) {
            return "m";
        }
        if (levelName.equals("THTA")) {
            return "K";
        }
        if (levelName.equals("SGMA")) {
            return "";
        }
        if (levelName.equals("DPTH")) {
            return "m";
        }
        if (levelName.equals("PDLY")) {
            return "hPa";
        }
        return "";
    }

    @Override
    public final String getTimeRangeUnitName(int tunit) {
        return "minute";
    }

    @Override
    public final Date getFirstBaseTime() {
        return this.sample.getReferenceTime();
    }

    @Override
    public final boolean isLatLon(GridDefRecord gds) {
        return this.getProjectionName(gds).equals("CED");
    }

    @Override
    public final int getProjectionType(GridDefRecord gds) {
        String name = this.getProjectionName(gds).trim();
        if (name.equals("CED")) {
            return -1;
        }
        if (name.equals("MER")) {
            return 3;
        }
        if (name.equals("MCD")) {
            return 3;
        }
        if (name.equals("LCC")) {
            return 2;
        }
        if (name.equals("SCC")) {
            return 2;
        }
        if (name.equals("PS")) {
            return 1;
        }
        if (name.equals("STR")) {
            return 1;
        }
        return -1;
    }

    @Override
    public final boolean isVerticalCoordinate(GridRecord gr) {
        int type = gr.getLevelType1();
        return type > GempakUtil.vertCoords.length || !GempakUtil.vertCoords[type].equals("NONE");
    }

    @Override
    public final boolean isPositiveUp(GridRecord gr) {
        int type = gr.getLevelType1();
        return type != 1 && type != 5;
    }

    @Override
    public final float getFirstMissingValue() {
        return -9999.0f;
    }

    @Override
    public boolean isLayer(GridRecord gr) {
        return gr.getLevel2() != -1.0;
    }

    private String getProjectionName(GridDefRecord gds) {
        return gds.getParam("ProjFlag");
    }

    @Override
    public final String getTitle() {
        return "GRID data";
    }

    @Override
    public String getInstitution() {
        return null;
    }

    @Override
    public final String getSource() {
        return null;
    }

    @Override
    public final String getComment() {
        return null;
    }

    @Override
    public String getGridType() {
        return "GEMPAK";
    }
}

