/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.plugins;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class J2KHeader {
    public static SimpleDateFormat j2kSdf = new SimpleDateFormat("dd.MM.yyyy HH:mm"){
        {
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    };
    private boolean isInputFile;
    private int timeStepCount;
    private Date dateStart;
    private Date dateEnd;
    private String property;
    private String unit;
    private double lowerBound;
    private double upperBound;
    private double missingDataValue;
    private int elementCount;
    private String[] stationNames;
    private int[] stationIDs;
    private double[] elevation;
    private double[] x;
    private double[] y;
    private int[] column;
    private TimePeriod timeStepUnit;
    private int timestep;
    private String spatialReferenceID;
    private String spatialDomainID;
    private String spatialDomainDescription;
    private String quantityDescription;
    private String unitDescription;

    public boolean getIsInputFile() {
        return this.isInputFile;
    }

    public void setIsInputFile(boolean isInputFile) {
        this.isInputFile = isInputFile;
    }

    public int getTimeStepCount() {
        return this.timeStepCount;
    }

    public void setTimeStepCount(int timeStepCount) {
        this.timeStepCount = timeStepCount;
    }

    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public Date getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public double getMissingDataValue() {
        return this.missingDataValue;
    }

    public void setMissingDataValue(double missingDataValue) {
        this.missingDataValue = missingDataValue;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public void setElementCount(int elementCount) {
        this.elementCount = elementCount;
    }

    public String[] getStationNames() {
        return this.stationNames;
    }

    public void setStationNames(String[] stationNames) {
        this.stationNames = stationNames;
    }

    public int[] getStationIDs() {
        return this.stationIDs;
    }

    public void setStationIDs(int[] stationIDs) {
        this.stationIDs = stationIDs;
    }

    public double[] getElevation() {
        return this.elevation;
    }

    public void setElevation(double[] elevation) {
        this.elevation = elevation;
    }

    public double[] getX() {
        return this.x;
    }

    public void setX(double[] x) {
        this.x = x;
    }

    public double[] getY() {
        return this.y;
    }

    public void setY(double[] y) {
        this.y = y;
    }

    public int[] getColumn() {
        return this.column;
    }

    public void setColumn(int[] column) {
        this.column = column;
    }

    public TimePeriod getTimeStepUnit() {
        return this.timeStepUnit;
    }

    public void setTimeStepUnit(TimePeriod timeStepUnit) {
        this.timeStepUnit = timeStepUnit;
    }

    public int getTimeStep() {
        return this.timestep;
    }

    private void setTimeStep(int timestep) {
        this.timestep = timestep;
    }

    public String getSpatialReferenceID() {
        return this.spatialReferenceID;
    }

    public void setSpatialReferenceID(String spatialReferenceID) {
        this.spatialReferenceID = spatialReferenceID;
    }

    public String getSpatialDomainID() {
        if (this.spatialDomainID != null) {
            return this.spatialDomainID;
        }
        return "spatial id not available!";
    }

    public void setSpatialDomainID(String spatialDomainID) {
        this.spatialDomainID = spatialDomainID;
    }

    public String getSpatialDomainDescription() {
        return this.spatialDomainDescription;
    }

    public void setSpatialDomainDescription(String spatialDomainDescription) {
        this.spatialDomainDescription = spatialDomainDescription;
    }

    public String getQuantityDescription() {
        return this.quantityDescription;
    }

    public void setQuantityDescription(String quantityDescription) {
        this.quantityDescription = quantityDescription;
    }

    public String getUnitDescription() {
        if (this.unitDescription != null) {
            return this.unitDescription;
        }
        return "unit description not available!";
    }

    public void setUnitDescription(String unitDescription) {
        this.unitDescription = unitDescription;
    }

    private Date addTimePeriod(Date date, TimePeriod period, int count) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        switch (period) {
            case DAY: {
                calendar.add(6, count);
                return calendar.getTime();
            }
            case HOUR: {
                calendar.add(10, count);
                return calendar.getTime();
            }
            case MINUTE: {
                calendar.add(12, count);
                return calendar.getTime();
            }
            case MONTH: {
                calendar.add(2, count);
                return calendar.getTime();
            }
            case WEEK: {
                calendar.add(3, count);
                return calendar.getTime();
            }
            case YEAR: {
                calendar.add(1, count);
                return calendar.getTime();
            }
        }
        return date;
    }

    public String writeHeader() {
        j2kSdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String header = "";
        header = header + "@dataConnection\n";
        header = this.isInputFile ? header + "mode\tINPUT\n" : header + "mode\tOUTPUT\n";
        header = header + "@dataValueAttribs\n";
        header = header + this.getProperty() + "\t" + this.getLowerBound() + "\t" + this.getUpperBound() + "\t??\n";
        header = header + "@dataSetAttribs\n";
        header = header + "missingDataVal\t-9999\n";
        header = header + "dataStart\t" + j2kSdf.format(this.dateStart) + "\n";
        header = header + "dataEnd\t" + j2kSdf.format(this.dateEnd) + "\n";
        switch (this.timeStepUnit) {
            case DAY: {
                this.setTimeStep(86400);
                break;
            }
            case HOUR: {
                this.setTimeStep(3600);
                break;
            }
            default: {
                this.setTimeStep(86400);
            }
        }
        if (this.getTimeStep() == 3600) {
            header = header + "tres\th\n";
        } else if (this.getTimeStep() == 86400) {
            header = header + "tres\td\n";
        }
        header = header + "@statAttribVal\n";
        String nameLine = "name\t";
        String idLine = "ID\t";
        String xLine = "x\t";
        String yLine = "y\t";
        String elevationLine = "elevation\t";
        String dataColumnLine = "dataColumn\t";
        for (int i = 0; i < this.stationIDs.length; ++i) {
            nameLine = nameLine + "SO_" + this.getStationNames()[i] + "\t";
            idLine = idLine + this.getStationIDs()[i] + "\t";
            xLine = xLine + this.getX()[i] + "\t";
            yLine = yLine + this.getY()[i] + "\t";
            elevationLine = elevationLine + this.getElevation()[i] + "\t";
            dataColumnLine = dataColumnLine + (i + 1) + "\t";
        }
        header = header + nameLine + "\n";
        header = header + idLine + "\n";
        header = header + xLine + "\n";
        header = header + yLine + "\n";
        header = header + elevationLine + "\n";
        header = header + dataColumnLine + "\n";
        header = header + "@dataVal\n";
        return header;
    }

    public void readHeader(String[] lines) throws J2KHeaderException {
        Boolean isDataValueAttribsSet = false;
        Boolean isDataSetAttribsSet = false;
        Boolean isStatAttribValSet = false;
        j2kSdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        int k = 0;
        while (k < lines.length) {
            String[] attribute;
            String attributeString;
            String attributesString;
            String[] attributes;
            String line;
            if ((line = lines[k++]).startsWith("#")) continue;
            if ((line = line.replace("\t", "")).toLowerCase().equals("@dataconnection")) {
                if ((attributes = (attributesString = lines[k++]).split("\t")).length != 2) {
                    throw new J2KHeaderException("dataValueAttribs does not contain enough tokens! found: " + attributes.length + " required: " + 4);
                }
                if (attributes[0].toLowerCase().equals("mode")) {
                    if (attributes[1].toLowerCase().equals("input")) {
                        this.setIsInputFile(true);
                    } else {
                        this.setIsInputFile(false);
                    }
                }
            }
            if (line.toLowerCase().equals("@datavalueattribs")) {
                if ((attributes = (attributesString = lines[k++]).split("\t")).length != 4) {
                    throw new J2KHeaderException("dataValueAttribs does not contain enough tokens! found: " + attributes.length + " required: " + 4);
                }
                this.property = attributes[0];
                this.lowerBound = Double.parseDouble(attributes[1]);
                this.upperBound = Double.parseDouble(attributes[2]);
                this.unit = attributes[3];
                isDataValueAttribsSet = true;
            }
            if (line.toLowerCase().equals("@datasetattribs")) {
                attributeString = null;
                while (!(attributeString = lines[k++]).startsWith("@")) {
                    attribute = attributeString.split("\t");
                    if (attribute.length != 2) {
                        throw new J2KHeaderException("dataSetAttribs does not contain enough tokens! found: " + attribute.length + " required: " + 2);
                    }
                    if (attribute[0].toLowerCase().equals("missingdataval")) {
                        this.missingDataValue = Double.parseDouble(attribute[1]);
                    } else if (attribute[0].toLowerCase().equals("datastart")) {
                        try {
                            this.dateStart = j2kSdf.parse(attribute[1]);
                        }
                        catch (ParseException pe) {
                            throw new J2KHeaderException("Unable to parse startDate:" + pe.toString());
                        }
                    } else if (attribute[0].toLowerCase().equals("dataend")) {
                        try {
                            this.dateEnd = j2kSdf.parse(attribute[1]);
                        }
                        catch (ParseException pe) {
                            throw new J2KHeaderException("Unable to parse startDate:" + pe.toString());
                        }
                    } else if (attribute[0].toLowerCase().equals("tres")) {
                        if (attribute[1].equals("h")) {
                            this.setTimeStepUnit(TimePeriod.HOUR);
                            this.setTimeStep(1);
                        }
                        if (attribute[1].equals("d")) {
                            this.setTimeStepUnit(TimePeriod.DAY);
                            this.setTimeStep(1);
                        }
                        if (attribute[1].equals("m")) {
                            this.setTimeStepUnit(TimePeriod.MONTH);
                            this.setTimeStep(1);
                        }
                    } else {
                        throw new J2KHeaderException("unknown or additional or misplaced attribute " + attribute[0]);
                    }
                    isDataSetAttribsSet = true;
                }
            }
            if (line.toLowerCase().equals("@statattribval")) {
                attributeString = null;
                while (!(attributeString = lines[k++]).startsWith("@")) {
                    int j;
                    attribute = attributeString.split("\t");
                    if (this.elementCount == 0) {
                        this.elementCount = attribute.length - 1;
                    } else if (this.elementCount != attribute.length - 1) {
                        throw new J2KHeaderException("number of stations and attributes is not consistent in attribute: " + attributeString);
                    }
                    if (attribute[0].toLowerCase().equals("name")) {
                        this.stationNames = new String[this.elementCount];
                        for (j = 1; j < attribute.length; ++j) {
                            this.stationNames[j - 1] = attribute[j];
                        }
                        continue;
                    }
                    if (attribute[0].toLowerCase().equals("id")) {
                        this.stationIDs = new int[this.elementCount];
                        for (j = 1; j < attribute.length; ++j) {
                            this.stationIDs[j - 1] = Integer.parseInt(attribute[j]);
                        }
                        continue;
                    }
                    if (attribute[0].toLowerCase().equals("elevation")) {
                        this.elevation = new double[this.elementCount];
                        for (j = 1; j < attribute.length; ++j) {
                            this.elevation[j - 1] = Double.parseDouble(attribute[j]);
                        }
                        continue;
                    }
                    if (attribute[0].toLowerCase().equals("x")) {
                        this.x = new double[this.elementCount];
                        for (j = 1; j < attribute.length; ++j) {
                            this.x[j - 1] = Double.parseDouble(attribute[j]);
                        }
                        continue;
                    }
                    if (attribute[0].toLowerCase().equals("y")) {
                        this.y = new double[this.elementCount];
                        for (j = 1; j < attribute.length; ++j) {
                            this.y[j - 1] = Double.parseDouble(attribute[j]);
                        }
                        continue;
                    }
                    if (attribute[0].toLowerCase().equals("datacolumn")) {
                        this.column = new int[this.elementCount];
                        for (j = 1; j < attribute.length; ++j) {
                            this.column[j - 1] = Integer.parseInt(attribute[j]);
                        }
                        continue;
                    }
                    throw new J2KHeaderException("unknown or additional or misplaced attribute " + attribute[0]);
                }
                isStatAttribValSet = true;
            }
            if (line.toLowerCase().equals("@dataConnection")) {
                if ((attributes = (attributesString = lines[k++]).split("\t")).length != 1) {
                    throw new J2KHeaderException("dataConnection does not contain enough tokens! found: " + attributes.length + " required: " + 4);
                }
                if (attributes[0].toLowerCase().equals("mode")) {
                    if (attributes[0].toLowerCase().equals("input")) {
                        this.setIsInputFile(true);
                    } else {
                        this.setIsInputFile(false);
                    }
                }
                isDataValueAttribsSet = true;
            }
            if (!line.toLowerCase().equals("@dataval")) continue;
            break;
        }
        if (!isDataValueAttribsSet.booleanValue()) {
            throw new J2KHeaderException("the section @dataValueAttribs is missing");
        }
        if (!isDataSetAttribsSet.booleanValue()) {
            throw new J2KHeaderException("the section @DataSetAttribs is missing");
        }
        if (!isStatAttribValSet.booleanValue()) {
            throw new J2KHeaderException("the section @StatAttribVal is missing");
        }
        long timeStampStart = this.dateStart.getTime();
        long timeStampEnd = this.dateEnd.getTime();
        long timeSteps = timeStampEnd - timeStampStart;
        switch (this.getTimeStepUnit()) {
            case MINUTE: {
                this.timeStepCount /= 60000;
                break;
            }
            case HOUR: {
                this.timeStepCount /= 3600000;
                break;
            }
            case DAY: {
                this.timeStepCount /= 86400000;
                break;
            }
            case WEEK: {
                break;
            }
            case MONTH: {
                break;
            }
        }
    }

    public class J2KHeaderException
    extends Exception {
        String exception;

        public J2KHeaderException(String exception) {
            this.exception = exception;
        }

        @Override
        public String toString() {
            return this.exception;
        }
    }

    public static enum TimePeriod {
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR,
        UNDEFINED;

    }
}

