/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning.kernels;

import jams.components.machineLearning.kernels.Kernel;

public class SimpleExponential
extends Kernel {
    public SimpleExponential(int inputDim) {
        this.inputDim = inputDim;
        this.KernelParameterCount = 1;
        this.parameterCount = 1;
    }

    @Override
    public String[] getParameterNames() {
        super.getParameterNames();
        this.KernelParameterNames[0] = "l";
        return this.KernelParameterNames;
    }

    public double SqrDistance2(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double tmp = x[i] - y[i];
            sum += tmp * tmp;
        }
        return sum;
    }

    @Override
    public double kernel(double[] x, double[] y, int index1, int index2) {
        double r = this.SqrDistance2(x, y);
        if (index1 == index2) {
            return Math.exp(-0.5 * r) + this.theta[0] * this.theta[0];
        }
        return Math.exp(-0.5 * r);
    }

    @Override
    public double dkernel(double[] x, double[] y, int d) {
        return 0.0;
    }
}

