/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning.kernels;

import jams.components.machineLearning.kernels.Kernel;

public class RationalQuadratic
extends Kernel {
    public RationalQuadratic(int inputDim) {
        this.inputDim = inputDim;
        this.parameterCount = inputDim + 2;
        this.KernelParameterCount = inputDim + 2;
    }

    @Override
    public String[] getParameterNames() {
        super.getParameterNames();
        for (int i = 0; i < this.inputDim; ++i) {
            this.KernelParameterNames[i] = "l_" + i;
        }
        this.KernelParameterNames[this.inputDim] = "alpha";
        this.KernelParameterNames[this.inputDim + 1] = "sigma";
        return this.KernelParameterNames;
    }

    public double SqrDistance2(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double tmp = (x[i] - y[i]) / this.theta[i];
            sum += tmp * tmp;
        }
        return sum;
    }

    @Override
    public double kernel(double[] x, double[] y, int index1, int index2) {
        double r = this.SqrDistance2(x, y);
        double noise = 0.0;
        if (index1 == index2) {
            noise = this.theta[this.KernelParameterCount - 1] * this.theta[this.KernelParameterCount - 1];
        }
        return Math.pow(1.0 + r / (2.0 * this.theta[this.KernelParameterCount - 2]), -this.theta[this.KernelParameterCount - 2]) + noise;
    }

    @Override
    public double dkernel(double[] x, double[] y, int d) {
        double alpha = this.theta[this.inputDim];
        double r = this.SqrDistance2(x, y);
        double base = 1.0 + r / (2.0 * alpha);
        double expterm = Math.pow(base, -alpha);
        if (d < this.inputDim) {
            double dr = (x[d] - y[d]) / this.theta[d];
            return expterm * dr * dr / (base * this.theta[d]);
        }
        if (d == this.inputDim) {
            return expterm * (-Math.log(base) + r / (2.0 * alpha * base));
        }
        if (d > this.inputDim) {
            return 0.0;
        }
        return 0.0;
    }
}

