/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning;

import jams.components.machineLearning.ActivationFunction;
import jams.components.machineLearning.DLogisticFunction;

public class LogisticFunction
implements ActivationFunction {
    private double beta;

    public LogisticFunction(double beta) {
        this.beta = beta;
    }

    @Override
    public double calculate(double x) {
        return 1.0 / (1.0 + Math.exp(-this.beta * x));
    }

    @Override
    public double[] getParams() {
        double[] params = null;
        return params;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public ActivationFunction derive() {
        DLogisticFunction derivation = new DLogisticFunction(this.beta);
        return derivation;
    }

    @Override
    public int getType() {
        return 4;
    }
}

