/*
 * Decompiled with CFR 0.152.
 */
package jams.components.machineLearning;

import jams.data.Attribute;
import jams.model.Component;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;

public class CrossValidation
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Integer k;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="TimeSerie of Temp Data")
    public Attribute.Entity Data;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="TimeSerie of Temp Data")
    public Attribute.Entity trainingData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="TimeSerie of Temp Data")
    public Attribute.Entity validationData;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="TimeSerie of Temp Data")
    public Attribute.Boolean enable;

    public void init() {
    }

    private void singleRun() {
        Component comp;
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.initAll();
            }
            catch (Exception e) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
            }
        }
    }

    public void run() {
        if (this.enable != null && !this.enable.getValue()) {
            this.singleRun();
            return;
        }
        if (this.k.getValue() <= 0) {
            this.getModel().getRuntime().sendHalt("Number of Crossvalidation Iterations less or equal zero!!");
            return;
        }
        double[][] data = null;
        double[] predict = null;
        try {
            data = (double[][])this.Data.getObject("data");
            predict = (double[])this.Data.getObject("predict");
        }
        catch (Exception e) {
            this.getModel().getRuntime().sendHalt("Keine Datens^tze gefunden!!" + e.toString());
        }
        this.getModel().getRuntime().sendInfoMsg("Cross Validation");
        int N = data.length;
        int M = data[0].length;
        int d = N / this.k.getValue();
        if (d * this.k.getValue() != N) {
            ++d;
        }
        for (int i = 0; i < this.k.getValue(); ++i) {
            int trainCounter = 0;
            int valCounter = 0;
            this.getModel().getRuntime().sendInfoMsg("Run " + (i + 1) + " of " + this.k.getValue());
            for (int j = 0; j < N; ++j) {
                if (j / d == i) {
                    ++valCounter;
                    continue;
                }
                ++trainCounter;
            }
            double[][] valData = new double[valCounter][];
            double[] valPredict = new double[valCounter];
            double[][] trainData = new double[trainCounter][];
            double[] trainPredict = new double[trainCounter];
            trainCounter = 0;
            valCounter = 0;
            for (int j = 0; j < N; ++j) {
                if (j / d == i) {
                    valData[valCounter] = data[j];
                    valPredict[valCounter] = predict[j];
                    ++valCounter;
                    continue;
                }
                trainData[trainCounter] = data[j];
                trainPredict[trainCounter] = predict[j];
                ++trainCounter;
            }
            this.trainingData.setObject("data", (Object)trainData);
            this.trainingData.setObject("predict", (Object)trainPredict);
            this.validationData.setObject("data", (Object)valData);
            this.validationData.setObject("predict", (Object)valPredict);
            this.singleRun();
        }
    }
}

