/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import jams.data.Attribute;
import jams.io.GenericDataReader;
import jams.io.JAMSTableDataArray;
import jams.io.JAMSTableDataConverter;
import jams.io.JAMSTableDataStore;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class CheckedTSDataReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Data file name")
    public Attribute.String dataFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Column of first data value")
    public Attribute.Integer startColumn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Time interval of current temporal context")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Time interval of current temporal context")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of data values for current time step")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="data set descriptor")
    public Attribute.String dataSetName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of station elevations")
    public Attribute.DoubleArray elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of station's x coordinate")
    public Attribute.DoubleArray xCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of station's y coordinate")
    public Attribute.DoubleArray yCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Regression coefficients")
    public Attribute.DoubleArray regCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculate regression coefficients? If not, regCoeff array stays empty!")
    public Attribute.Boolean skipRegression;
    private JAMSTableDataStore store;
    private JAMSTableDataArray da;
    private int timeUnit;
    private Attribute.Calendar tsTime;
    private Attribute.Calendar currentTime;
    private double[] noDataValues = new double[0];

    public void init() {
        int headerLineCount = 0;
        String dataName = null;
        String tres = null;
        String start = null;
        String end = null;
        double[] statx = null;
        double[] staty = null;
        double[] statelev = null;
        String fileName = this.getModel().getWorkspaceDirectory().getPath() + "/" + this.dataFileName.getValue();
        String line = "#";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while (line.charAt(0) == '#') {
                line = reader.readLine();
                ++headerLineCount;
            }
            StringTokenizer strTok = new StringTokenizer(line, "\t");
            String token = strTok.nextToken();
            while (token.compareTo("@dataVal") != 0) {
                String desc;
                int i;
                if (token.compareTo("@dataValueAttribs") == 0) {
                    line = reader.readLine();
                    ++headerLineCount;
                    strTok = new StringTokenizer(line, "\t");
                    dataName = strTok.nextToken();
                    double lowBound = Double.parseDouble(strTok.nextToken());
                    double uppBound = Double.parseDouble(strTok.nextToken());
                    line = reader.readLine();
                    strTok = new StringTokenizer(line, "\t");
                    token = strTok.nextToken();
                    ++headerLineCount;
                    continue;
                }
                if (token.compareTo("@dataSetAttribs") == 0) {
                    line = reader.readLine();
                    for (i = 0; i < 4; ++i) {
                        ++headerLineCount;
                        strTok = new StringTokenizer(line, "\t");
                        desc = strTok.nextToken();
                        if (desc.compareTo("missingDataVal") == 0) {
                            double missData = Double.parseDouble(strTok.nextToken());
                        } else if (desc.compareTo("dataStart") == 0) {
                            start = strTok.nextToken();
                        } else if (desc.compareTo("dataEnd") == 0) {
                            end = strTok.nextToken();
                        } else if (desc.compareTo("tres") == 0) {
                            tres = strTok.nextToken();
                        }
                        line = reader.readLine();
                        strTok = new StringTokenizer(line, "\t");
                        token = strTok.nextToken();
                    }
                    continue;
                }
                if (token.compareTo("@statAttribVal") != 0) continue;
                line = reader.readLine();
                for (i = 0; i < 6; ++i) {
                    int j;
                    ++headerLineCount;
                    strTok = new StringTokenizer(line, "\t");
                    desc = strTok.nextToken();
                    int nstat = strTok.countTokens();
                    if (desc.compareTo("name") == 0) {
                        String[] name = new String[nstat];
                        for (j = 0; j < nstat; ++j) {
                            name[j] = strTok.nextToken();
                        }
                    } else if (desc.compareTo("ID") == 0) {
                        String[] id = new String[nstat];
                        for (j = 0; j < nstat; ++j) {
                            id[j] = strTok.nextToken();
                        }
                    } else if (desc.compareTo("elevation") == 0) {
                        statelev = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            statelev[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("x") == 0) {
                        statx = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            statx[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("y") == 0) {
                        staty = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            staty[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.compareTo("dataColumn") == 0) {
                        ++headerLineCount;
                        ++headerLineCount;
                    }
                    line = reader.readLine();
                    strTok = new StringTokenizer(line, "\t");
                    token = strTok.nextToken();
                }
            }
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
        this.store = new GenericDataReader(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.dataFileName.getValue(), true, headerLineCount + 1);
        this.timeUnit = this.timeInterval.getTimeUnit();
        Attribute.Calendar startTime = this.parseTime(start);
        Attribute.Calendar endTime = this.parseTime(end);
        this.dataSetName.setValue(dataName);
        this.elevation.setValue(statelev);
        this.xCoord.setValue(statx);
        this.yCoord.setValue(staty);
        this.currentTime = this.timeInterval.getStart().clone();
        this.tsTime = this.getModel().getRuntime().getDataFactory().createCalendar();
        this.tsTime.setValue("0-01-01 00:00");
        this.getModel().getRuntime().println(this.dataSetName.getValue() + " data file initalised ... ", 2);
    }

    public void run() {
        int diff;
        while ((diff = this.time.compareTo(this.tsTime, this.timeUnit)) > 0) {
            this.da = this.store.getNext();
            this.tsTime = this.da.getTime();
        }
        if (diff == 0) {
            this.dataArray.setValue(JAMSTableDataConverter.toDouble((JAMSTableDataArray)this.da, (int)this.startColumn.getValue()));
        } else {
            this.dataArray.setValue(this.noDataValues);
        }
    }

    private Attribute.Calendar parseTime(String timeString) {
        String[] timeArray = new String[]{"1", "1", "0", "0", "0"};
        StringTokenizer st = new StringTokenizer(timeString, ".-/ :");
        int n = st.countTokens();
        for (int i = 0; i < n; ++i) {
            timeArray[i] = st.nextToken();
        }
        Attribute.Calendar cal = this.getModel().getRuntime().getDataFactory().createCalendar();
        cal.setValue(timeArray[2] + "-" + timeArray[1] + "-" + timeArray[0] + " " + timeArray[3] + ":" + timeArray[4]);
        return cal;
    }

    public void cleanup() {
        this.store.close();
    }
}

